/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendDataToWirelessDeviceRequest extends IotWirelessRequest implements
        ToCopyableBuilder<SendDataToWirelessDeviceRequest.Builder, SendDataToWirelessDeviceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SendDataToWirelessDeviceRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<Integer> TRANSMIT_MODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TransmitMode").getter(getter(SendDataToWirelessDeviceRequest::transmitMode))
            .setter(setter(Builder::transmitMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransmitMode").build()).build();

    private static final SdkField<String> PAYLOAD_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PayloadData").getter(getter(SendDataToWirelessDeviceRequest::payloadData))
            .setter(setter(Builder::payloadData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadData").build()).build();

    private static final SdkField<WirelessMetadata> WIRELESS_METADATA_FIELD = SdkField
            .<WirelessMetadata> builder(MarshallingType.SDK_POJO).memberName("WirelessMetadata")
            .getter(getter(SendDataToWirelessDeviceRequest::wirelessMetadata)).setter(setter(Builder::wirelessMetadata))
            .constructor(WirelessMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TRANSMIT_MODE_FIELD,
            PAYLOAD_DATA_FIELD, WIRELESS_METADATA_FIELD));

    private final String id;

    private final Integer transmitMode;

    private final String payloadData;

    private final WirelessMetadata wirelessMetadata;

    private SendDataToWirelessDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.transmitMode = builder.transmitMode;
        this.payloadData = builder.payloadData;
        this.wirelessMetadata = builder.wirelessMetadata;
    }

    /**
     * <p>
     * The ID of the wireless device to receive the data.
     * </p>
     * 
     * @return The ID of the wireless device to receive the data.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode)
     * or <code>1</code> for AM (acknowledge mode).
     * </p>
     * 
     * @return The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM
     *         (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).
     */
    public final Integer transmitMode() {
        return transmitMode;
    }

    /**
     * Returns the value of the PayloadData property for this object.
     * 
     * @return The value of the PayloadData property for this object.
     */
    public final String payloadData() {
        return payloadData;
    }

    /**
     * <p>
     * Metadata about the message request.
     * </p>
     * 
     * @return Metadata about the message request.
     */
    public final WirelessMetadata wirelessMetadata() {
        return wirelessMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(transmitMode());
        hashCode = 31 * hashCode + Objects.hashCode(payloadData());
        hashCode = 31 * hashCode + Objects.hashCode(wirelessMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataToWirelessDeviceRequest)) {
            return false;
        }
        SendDataToWirelessDeviceRequest other = (SendDataToWirelessDeviceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(transmitMode(), other.transmitMode())
                && Objects.equals(payloadData(), other.payloadData())
                && Objects.equals(wirelessMetadata(), other.wirelessMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendDataToWirelessDeviceRequest").add("Id", id()).add("TransmitMode", transmitMode())
                .add("PayloadData", payloadData()).add("WirelessMetadata", wirelessMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "TransmitMode":
            return Optional.ofNullable(clazz.cast(transmitMode()));
        case "PayloadData":
            return Optional.ofNullable(clazz.cast(payloadData()));
        case "WirelessMetadata":
            return Optional.ofNullable(clazz.cast(wirelessMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendDataToWirelessDeviceRequest, T> g) {
        return obj -> g.apply((SendDataToWirelessDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendDataToWirelessDeviceRequest> {
        /**
         * <p>
         * The ID of the wireless device to receive the data.
         * </p>
         * 
         * @param id
         *        The ID of the wireless device to receive the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge
         * mode) or <code>1</code> for AM (acknowledge mode).
         * </p>
         * 
         * @param transmitMode
         *        The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM
         *        (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transmitMode(Integer transmitMode);

        /**
         * Sets the value of the PayloadData property for this object.
         *
         * @param payloadData
         *        The new value for the PayloadData property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadData(String payloadData);

        /**
         * <p>
         * Metadata about the message request.
         * </p>
         * 
         * @param wirelessMetadata
         *        Metadata about the message request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessMetadata(WirelessMetadata wirelessMetadata);

        /**
         * <p>
         * Metadata about the message request.
         * </p>
         * This is a convenience method that creates an instance of the {@link WirelessMetadata.Builder} avoiding the
         * need to create one manually via {@link WirelessMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WirelessMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #wirelessMetadata(WirelessMetadata)}.
         * 
         * @param wirelessMetadata
         *        a consumer that will call methods on {@link WirelessMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wirelessMetadata(WirelessMetadata)
         */
        default Builder wirelessMetadata(Consumer<WirelessMetadata.Builder> wirelessMetadata) {
            return wirelessMetadata(WirelessMetadata.builder().applyMutation(wirelessMetadata).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String id;

        private Integer transmitMode;

        private String payloadData;

        private WirelessMetadata wirelessMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataToWirelessDeviceRequest model) {
            super(model);
            id(model.id);
            transmitMode(model.transmitMode);
            payloadData(model.payloadData);
            wirelessMetadata(model.wirelessMetadata);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getTransmitMode() {
            return transmitMode;
        }

        public final void setTransmitMode(Integer transmitMode) {
            this.transmitMode = transmitMode;
        }

        @Override
        public final Builder transmitMode(Integer transmitMode) {
            this.transmitMode = transmitMode;
            return this;
        }

        public final String getPayloadData() {
            return payloadData;
        }

        public final void setPayloadData(String payloadData) {
            this.payloadData = payloadData;
        }

        @Override
        public final Builder payloadData(String payloadData) {
            this.payloadData = payloadData;
            return this;
        }

        public final WirelessMetadata.Builder getWirelessMetadata() {
            return wirelessMetadata != null ? wirelessMetadata.toBuilder() : null;
        }

        public final void setWirelessMetadata(WirelessMetadata.BuilderImpl wirelessMetadata) {
            this.wirelessMetadata = wirelessMetadata != null ? wirelessMetadata.build() : null;
        }

        @Override
        public final Builder wirelessMetadata(WirelessMetadata wirelessMetadata) {
            this.wirelessMetadata = wirelessMetadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDataToWirelessDeviceRequest build() {
            return new SendDataToWirelessDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
