/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventNotificationResourceType {
    FUOTA_TASK("FuotaTask"),
    SIDEWALK_ACCOUNT("SidewalkAccount"),
    WIRELESS_DEVICE("WirelessDevice"),
    WIRELESS_GATEWAY("WirelessGateway"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventNotificationResourceType> VALUE_MAP;
    private final String value;

    private EventNotificationResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventNotificationResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventNotificationResourceType> knownValues() {
        EnumSet<EventNotificationResourceType> knownValues = EnumSet.allOf(EventNotificationResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventNotificationResourceType.class, EventNotificationResourceType::toString);
    }
}

