/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CDMA local ID information, which corresponds to the local identification parameters of a CDMA cell.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CdmaLocalId implements SdkPojo, Serializable, ToCopyableBuilder<CdmaLocalId.Builder, CdmaLocalId> {
    private static final SdkField<Integer> PN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PnOffset").getter(getter(CdmaLocalId::pnOffset)).setter(setter(Builder::pnOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PnOffset").build()).build();

    private static final SdkField<Integer> CDMA_CHANNEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CdmaChannel").getter(getter(CdmaLocalId::cdmaChannel)).setter(setter(Builder::cdmaChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdmaChannel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PN_OFFSET_FIELD,
            CDMA_CHANNEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer pnOffset;

    private final Integer cdmaChannel;

    private CdmaLocalId(BuilderImpl builder) {
        this.pnOffset = builder.pnOffset;
        this.cdmaChannel = builder.cdmaChannel;
    }

    /**
     * <p>
     * Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.
     * </p>
     * 
     * @return Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.
     */
    public final Integer pnOffset() {
        return pnOffset;
    }

    /**
     * <p>
     * CDMA channel information.
     * </p>
     * 
     * @return CDMA channel information.
     */
    public final Integer cdmaChannel() {
        return cdmaChannel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pnOffset());
        hashCode = 31 * hashCode + Objects.hashCode(cdmaChannel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CdmaLocalId)) {
            return false;
        }
        CdmaLocalId other = (CdmaLocalId) obj;
        return Objects.equals(pnOffset(), other.pnOffset()) && Objects.equals(cdmaChannel(), other.cdmaChannel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CdmaLocalId").add("PnOffset", pnOffset()).add("CdmaChannel", cdmaChannel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PnOffset":
            return Optional.ofNullable(clazz.cast(pnOffset()));
        case "CdmaChannel":
            return Optional.ofNullable(clazz.cast(cdmaChannel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PnOffset", PN_OFFSET_FIELD);
        map.put("CdmaChannel", CDMA_CHANNEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CdmaLocalId, T> g) {
        return obj -> g.apply((CdmaLocalId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CdmaLocalId> {
        /**
         * <p>
         * Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.
         * </p>
         * 
         * @param pnOffset
         *        Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pnOffset(Integer pnOffset);

        /**
         * <p>
         * CDMA channel information.
         * </p>
         * 
         * @param cdmaChannel
         *        CDMA channel information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdmaChannel(Integer cdmaChannel);
    }

    static final class BuilderImpl implements Builder {
        private Integer pnOffset;

        private Integer cdmaChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(CdmaLocalId model) {
            pnOffset(model.pnOffset);
            cdmaChannel(model.cdmaChannel);
        }

        public final Integer getPnOffset() {
            return pnOffset;
        }

        public final void setPnOffset(Integer pnOffset) {
            this.pnOffset = pnOffset;
        }

        @Override
        public final Builder pnOffset(Integer pnOffset) {
            this.pnOffset = pnOffset;
            return this;
        }

        public final Integer getCdmaChannel() {
            return cdmaChannel;
        }

        public final void setCdmaChannel(Integer cdmaChannel) {
            this.cdmaChannel = cdmaChannel;
        }

        @Override
        public final Builder cdmaChannel(Integer cdmaChannel) {
            this.cdmaChannel = cdmaChannel;
            return this;
        }

        @Override
        public CdmaLocalId build() {
            return new CdmaLocalId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
