/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of sidewalk certificates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateList implements SdkPojo, Serializable, ToCopyableBuilder<CertificateList.Builder, CertificateList> {
    private static final SdkField<String> SIGNING_ALG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SigningAlg").getter(getter(CertificateList::signingAlgAsString)).setter(setter(Builder::signingAlg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlg").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(CertificateList::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SIGNING_ALG_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String signingAlg;

    private final String value;

    private CertificateList(BuilderImpl builder) {
        this.signingAlg = builder.signingAlg;
        this.value = builder.value;
    }

    /**
     * <p>
     * The certificate chain algorithm provided by sidewalk.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingAlg} will
     * return {@link SigningAlg#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #signingAlgAsString}.
     * </p>
     * 
     * @return The certificate chain algorithm provided by sidewalk.
     * @see SigningAlg
     */
    public final SigningAlg signingAlg() {
        return SigningAlg.fromValue(signingAlg);
    }

    /**
     * <p>
     * The certificate chain algorithm provided by sidewalk.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingAlg} will
     * return {@link SigningAlg#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #signingAlgAsString}.
     * </p>
     * 
     * @return The certificate chain algorithm provided by sidewalk.
     * @see SigningAlg
     */
    public final String signingAlgAsString() {
        return signingAlg;
    }

    /**
     * <p>
     * The value of the chosen sidewalk certificate.
     * </p>
     * 
     * @return The value of the chosen sidewalk certificate.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signingAlgAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateList)) {
            return false;
        }
        CertificateList other = (CertificateList) obj;
        return Objects.equals(signingAlgAsString(), other.signingAlgAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CertificateList").add("SigningAlg", signingAlgAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SigningAlg":
            return Optional.ofNullable(clazz.cast(signingAlgAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SigningAlg", SIGNING_ALG_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CertificateList, T> g) {
        return obj -> g.apply((CertificateList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CertificateList> {
        /**
         * <p>
         * The certificate chain algorithm provided by sidewalk.
         * </p>
         * 
         * @param signingAlg
         *        The certificate chain algorithm provided by sidewalk.
         * @see SigningAlg
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningAlg
         */
        Builder signingAlg(String signingAlg);

        /**
         * <p>
         * The certificate chain algorithm provided by sidewalk.
         * </p>
         * 
         * @param signingAlg
         *        The certificate chain algorithm provided by sidewalk.
         * @see SigningAlg
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningAlg
         */
        Builder signingAlg(SigningAlg signingAlg);

        /**
         * <p>
         * The value of the chosen sidewalk certificate.
         * </p>
         * 
         * @param value
         *        The value of the chosen sidewalk certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String signingAlg;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateList model) {
            signingAlg(model.signingAlg);
            value(model.value);
        }

        public final String getSigningAlg() {
            return signingAlg;
        }

        public final void setSigningAlg(String signingAlg) {
            this.signingAlg = signingAlg;
        }

        @Override
        public final Builder signingAlg(String signingAlg) {
            this.signingAlg = signingAlg;
            return this;
        }

        @Override
        public final Builder signingAlg(SigningAlg signingAlg) {
            this.signingAlg(signingAlg == null ? null : signingAlg.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public CertificateList build() {
            return new CertificateList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
