/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFuotaTaskRequest extends IotWirelessRequest implements
        ToCopyableBuilder<CreateFuotaTaskRequest.Builder, CreateFuotaTaskRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateFuotaTaskRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFuotaTaskRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateFuotaTaskRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<LoRaWANFuotaTask> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANFuotaTask> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(CreateFuotaTaskRequest::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANFuotaTask::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<String> FIRMWARE_UPDATE_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirmwareUpdateImage").getter(getter(CreateFuotaTaskRequest::firmwareUpdateImage))
            .setter(setter(Builder::firmwareUpdateImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirmwareUpdateImage").build())
            .build();

    private static final SdkField<String> FIRMWARE_UPDATE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirmwareUpdateRole").getter(getter(CreateFuotaTaskRequest::firmwareUpdateRole))
            .setter(setter(Builder::firmwareUpdateRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirmwareUpdateRole").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFuotaTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> REDUNDANCY_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RedundancyPercent").getter(getter(CreateFuotaTaskRequest::redundancyPercent))
            .setter(setter(Builder::redundancyPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedundancyPercent").build()).build();

    private static final SdkField<Integer> FRAGMENT_SIZE_BYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FragmentSizeBytes").getter(getter(CreateFuotaTaskRequest::fragmentSizeBytes))
            .setter(setter(Builder::fragmentSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSizeBytes").build()).build();

    private static final SdkField<Integer> FRAGMENT_INTERVAL_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FragmentIntervalMS").getter(getter(CreateFuotaTaskRequest::fragmentIntervalMS))
            .setter(setter(Builder::fragmentIntervalMS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentIntervalMS").build())
            .build();

    private static final SdkField<String> DESCRIPTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Descriptor").getter(getter(CreateFuotaTaskRequest::descriptor)).setter(setter(Builder::descriptor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Descriptor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, LO_RA_WAN_FIELD, FIRMWARE_UPDATE_IMAGE_FIELD, FIRMWARE_UPDATE_ROLE_FIELD, TAGS_FIELD,
            REDUNDANCY_PERCENT_FIELD, FRAGMENT_SIZE_BYTES_FIELD, FRAGMENT_INTERVAL_MS_FIELD, DESCRIPTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String clientRequestToken;

    private final LoRaWANFuotaTask loRaWAN;

    private final String firmwareUpdateImage;

    private final String firmwareUpdateRole;

    private final List<Tag> tags;

    private final Integer redundancyPercent;

    private final Integer fragmentSizeBytes;

    private final Integer fragmentIntervalMS;

    private final String descriptor;

    private CreateFuotaTaskRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.loRaWAN = builder.loRaWAN;
        this.firmwareUpdateImage = builder.firmwareUpdateImage;
        this.firmwareUpdateRole = builder.firmwareUpdateRole;
        this.tags = builder.tags;
        this.redundancyPercent = builder.redundancyPercent;
        this.fragmentSizeBytes = builder.fragmentSizeBytes;
        this.fragmentIntervalMS = builder.fragmentIntervalMS;
        this.descriptor = builder.descriptor;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns the value of the LoRaWAN property for this object.
     * 
     * @return The value of the LoRaWAN property for this object.
     */
    public final LoRaWANFuotaTask loRaWAN() {
        return loRaWAN;
    }

    /**
     * Returns the value of the FirmwareUpdateImage property for this object.
     * 
     * @return The value of the FirmwareUpdateImage property for this object.
     */
    public final String firmwareUpdateImage() {
        return firmwareUpdateImage;
    }

    /**
     * Returns the value of the FirmwareUpdateRole property for this object.
     * 
     * @return The value of the FirmwareUpdateRole property for this object.
     */
    public final String firmwareUpdateRole() {
        return firmwareUpdateRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns the value of the RedundancyPercent property for this object.
     * 
     * @return The value of the RedundancyPercent property for this object.
     */
    public final Integer redundancyPercent() {
        return redundancyPercent;
    }

    /**
     * Returns the value of the FragmentSizeBytes property for this object.
     * 
     * @return The value of the FragmentSizeBytes property for this object.
     */
    public final Integer fragmentSizeBytes() {
        return fragmentSizeBytes;
    }

    /**
     * Returns the value of the FragmentIntervalMS property for this object.
     * 
     * @return The value of the FragmentIntervalMS property for this object.
     */
    public final Integer fragmentIntervalMS() {
        return fragmentIntervalMS;
    }

    /**
     * Returns the value of the Descriptor property for this object.
     * 
     * @return The value of the Descriptor property for this object.
     */
    public final String descriptor() {
        return descriptor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(firmwareUpdateImage());
        hashCode = 31 * hashCode + Objects.hashCode(firmwareUpdateRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(redundancyPercent());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentIntervalMS());
        hashCode = 31 * hashCode + Objects.hashCode(descriptor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFuotaTaskRequest)) {
            return false;
        }
        CreateFuotaTaskRequest other = (CreateFuotaTaskRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(loRaWAN(), other.loRaWAN())
                && Objects.equals(firmwareUpdateImage(), other.firmwareUpdateImage())
                && Objects.equals(firmwareUpdateRole(), other.firmwareUpdateRole()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(redundancyPercent(), other.redundancyPercent())
                && Objects.equals(fragmentSizeBytes(), other.fragmentSizeBytes())
                && Objects.equals(fragmentIntervalMS(), other.fragmentIntervalMS())
                && Objects.equals(descriptor(), other.descriptor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFuotaTaskRequest").add("Name", name()).add("Description", description())
                .add("ClientRequestToken", clientRequestToken()).add("LoRaWAN", loRaWAN())
                .add("FirmwareUpdateImage", firmwareUpdateImage()).add("FirmwareUpdateRole", firmwareUpdateRole())
                .add("Tags", hasTags() ? tags() : null).add("RedundancyPercent", redundancyPercent())
                .add("FragmentSizeBytes", fragmentSizeBytes()).add("FragmentIntervalMS", fragmentIntervalMS())
                .add("Descriptor", descriptor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "FirmwareUpdateImage":
            return Optional.ofNullable(clazz.cast(firmwareUpdateImage()));
        case "FirmwareUpdateRole":
            return Optional.ofNullable(clazz.cast(firmwareUpdateRole()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RedundancyPercent":
            return Optional.ofNullable(clazz.cast(redundancyPercent()));
        case "FragmentSizeBytes":
            return Optional.ofNullable(clazz.cast(fragmentSizeBytes()));
        case "FragmentIntervalMS":
            return Optional.ofNullable(clazz.cast(fragmentIntervalMS()));
        case "Descriptor":
            return Optional.ofNullable(clazz.cast(descriptor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("LoRaWAN", LO_RA_WAN_FIELD);
        map.put("FirmwareUpdateImage", FIRMWARE_UPDATE_IMAGE_FIELD);
        map.put("FirmwareUpdateRole", FIRMWARE_UPDATE_ROLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("RedundancyPercent", REDUNDANCY_PERCENT_FIELD);
        map.put("FragmentSizeBytes", FRAGMENT_SIZE_BYTES_FIELD);
        map.put("FragmentIntervalMS", FRAGMENT_INTERVAL_MS_FIELD);
        map.put("Descriptor", DESCRIPTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFuotaTaskRequest, T> g) {
        return obj -> g.apply((CreateFuotaTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFuotaTaskRequest> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * Sets the value of the LoRaWAN property for this object.
         *
         * @param loRaWAN
         *        The new value for the LoRaWAN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANFuotaTask loRaWAN);

        /**
         * Sets the value of the LoRaWAN property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LoRaWANFuotaTask.Builder} avoiding the
         * need to create one manually via {@link LoRaWANFuotaTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoRaWANFuotaTask.Builder#build()} is called immediately and its
         * result is passed to {@link #loRaWAN(LoRaWANFuotaTask)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANFuotaTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANFuotaTask)
         */
        default Builder loRaWAN(Consumer<LoRaWANFuotaTask.Builder> loRaWAN) {
            return loRaWAN(LoRaWANFuotaTask.builder().applyMutation(loRaWAN).build());
        }

        /**
         * Sets the value of the FirmwareUpdateImage property for this object.
         *
         * @param firmwareUpdateImage
         *        The new value for the FirmwareUpdateImage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firmwareUpdateImage(String firmwareUpdateImage);

        /**
         * Sets the value of the FirmwareUpdateRole property for this object.
         *
         * @param firmwareUpdateRole
         *        The new value for the FirmwareUpdateRole property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firmwareUpdateRole(String firmwareUpdateRole);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * Sets the value of the RedundancyPercent property for this object.
         *
         * @param redundancyPercent
         *        The new value for the RedundancyPercent property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redundancyPercent(Integer redundancyPercent);

        /**
         * Sets the value of the FragmentSizeBytes property for this object.
         *
         * @param fragmentSizeBytes
         *        The new value for the FragmentSizeBytes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentSizeBytes(Integer fragmentSizeBytes);

        /**
         * Sets the value of the FragmentIntervalMS property for this object.
         *
         * @param fragmentIntervalMS
         *        The new value for the FragmentIntervalMS property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentIntervalMS(Integer fragmentIntervalMS);

        /**
         * Sets the value of the Descriptor property for this object.
         *
         * @param descriptor
         *        The new value for the Descriptor property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptor(String descriptor);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String clientRequestToken;

        private LoRaWANFuotaTask loRaWAN;

        private String firmwareUpdateImage;

        private String firmwareUpdateRole;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Integer redundancyPercent;

        private Integer fragmentSizeBytes;

        private Integer fragmentIntervalMS;

        private String descriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFuotaTaskRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            clientRequestToken(model.clientRequestToken);
            loRaWAN(model.loRaWAN);
            firmwareUpdateImage(model.firmwareUpdateImage);
            firmwareUpdateRole(model.firmwareUpdateRole);
            tags(model.tags);
            redundancyPercent(model.redundancyPercent);
            fragmentSizeBytes(model.fragmentSizeBytes);
            fragmentIntervalMS(model.fragmentIntervalMS);
            descriptor(model.descriptor);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final LoRaWANFuotaTask.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANFuotaTask.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANFuotaTask loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getFirmwareUpdateImage() {
            return firmwareUpdateImage;
        }

        public final void setFirmwareUpdateImage(String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
        }

        @Override
        public final Builder firmwareUpdateImage(String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
            return this;
        }

        public final String getFirmwareUpdateRole() {
            return firmwareUpdateRole;
        }

        public final void setFirmwareUpdateRole(String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
        }

        @Override
        public final Builder firmwareUpdateRole(String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getRedundancyPercent() {
            return redundancyPercent;
        }

        public final void setRedundancyPercent(Integer redundancyPercent) {
            this.redundancyPercent = redundancyPercent;
        }

        @Override
        public final Builder redundancyPercent(Integer redundancyPercent) {
            this.redundancyPercent = redundancyPercent;
            return this;
        }

        public final Integer getFragmentSizeBytes() {
            return fragmentSizeBytes;
        }

        public final void setFragmentSizeBytes(Integer fragmentSizeBytes) {
            this.fragmentSizeBytes = fragmentSizeBytes;
        }

        @Override
        public final Builder fragmentSizeBytes(Integer fragmentSizeBytes) {
            this.fragmentSizeBytes = fragmentSizeBytes;
            return this;
        }

        public final Integer getFragmentIntervalMS() {
            return fragmentIntervalMS;
        }

        public final void setFragmentIntervalMS(Integer fragmentIntervalMS) {
            this.fragmentIntervalMS = fragmentIntervalMS;
        }

        @Override
        public final Builder fragmentIntervalMS(Integer fragmentIntervalMS) {
            this.fragmentIntervalMS = fragmentIntervalMS;
            return this;
        }

        public final String getDescriptor() {
            return descriptor;
        }

        public final void setDescriptor(String descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public final Builder descriptor(String descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFuotaTaskRequest build() {
            return new CreateFuotaTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
