/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The device attestation key (DAK) information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DakCertificateMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<DakCertificateMetadata.Builder, DakCertificateMetadata> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateId").getter(getter(DakCertificateMetadata::certificateId))
            .setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()).build();

    private static final SdkField<Integer> MAX_ALLOWED_SIGNATURE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAllowedSignature").getter(getter(DakCertificateMetadata::maxAllowedSignature))
            .setter(setter(Builder::maxAllowedSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllowedSignature").build())
            .build();

    private static final SdkField<Boolean> FACTORY_SUPPORT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FactorySupport").getter(getter(DakCertificateMetadata::factorySupport))
            .setter(setter(Builder::factorySupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FactorySupport").build()).build();

    private static final SdkField<String> AP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApId")
            .getter(getter(DakCertificateMetadata::apId)).setter(setter(Builder::apId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApId").build()).build();

    private static final SdkField<String> DEVICE_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceTypeId").getter(getter(DakCertificateMetadata::deviceTypeId))
            .setter(setter(Builder::deviceTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD,
            MAX_ALLOWED_SIGNATURE_FIELD, FACTORY_SUPPORT_FIELD, AP_ID_FIELD, DEVICE_TYPE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String certificateId;

    private final Integer maxAllowedSignature;

    private final Boolean factorySupport;

    private final String apId;

    private final String deviceTypeId;

    private DakCertificateMetadata(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.maxAllowedSignature = builder.maxAllowedSignature;
        this.factorySupport = builder.factorySupport;
        this.apId = builder.apId;
        this.deviceTypeId = builder.deviceTypeId;
    }

    /**
     * <p>
     * The certificate ID for the DAK.
     * </p>
     * 
     * @return The certificate ID for the DAK.
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The maximum number of signatures that the DAK can sign. A value of <code>-1</code> indicates that there's no
     * device limit.
     * </p>
     * 
     * @return The maximum number of signatures that the DAK can sign. A value of <code>-1</code> indicates that there's
     *         no device limit.
     */
    public final Integer maxAllowedSignature() {
        return maxAllowedSignature;
    }

    /**
     * <p>
     * Whether factory support has been enabled.
     * </p>
     * 
     * @return Whether factory support has been enabled.
     */
    public final Boolean factorySupport() {
        return factorySupport;
    }

    /**
     * <p>
     * The advertised product ID (APID) that's used for pre-production and production applications.
     * </p>
     * 
     * @return The advertised product ID (APID) that's used for pre-production and production applications.
     */
    public final String apId() {
        return apId;
    }

    /**
     * <p>
     * The device type ID that's used for prototyping applications.
     * </p>
     * 
     * @return The device type ID that's used for prototyping applications.
     */
    public final String deviceTypeId() {
        return deviceTypeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(maxAllowedSignature());
        hashCode = 31 * hashCode + Objects.hashCode(factorySupport());
        hashCode = 31 * hashCode + Objects.hashCode(apId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DakCertificateMetadata)) {
            return false;
        }
        DakCertificateMetadata other = (DakCertificateMetadata) obj;
        return Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(maxAllowedSignature(), other.maxAllowedSignature())
                && Objects.equals(factorySupport(), other.factorySupport()) && Objects.equals(apId(), other.apId())
                && Objects.equals(deviceTypeId(), other.deviceTypeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DakCertificateMetadata").add("CertificateId", certificateId())
                .add("MaxAllowedSignature", maxAllowedSignature()).add("FactorySupport", factorySupport()).add("ApId", apId())
                .add("DeviceTypeId", deviceTypeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "MaxAllowedSignature":
            return Optional.ofNullable(clazz.cast(maxAllowedSignature()));
        case "FactorySupport":
            return Optional.ofNullable(clazz.cast(factorySupport()));
        case "ApId":
            return Optional.ofNullable(clazz.cast(apId()));
        case "DeviceTypeId":
            return Optional.ofNullable(clazz.cast(deviceTypeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CertificateId", CERTIFICATE_ID_FIELD);
        map.put("MaxAllowedSignature", MAX_ALLOWED_SIGNATURE_FIELD);
        map.put("FactorySupport", FACTORY_SUPPORT_FIELD);
        map.put("ApId", AP_ID_FIELD);
        map.put("DeviceTypeId", DEVICE_TYPE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DakCertificateMetadata, T> g) {
        return obj -> g.apply((DakCertificateMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DakCertificateMetadata> {
        /**
         * <p>
         * The certificate ID for the DAK.
         * </p>
         * 
         * @param certificateId
         *        The certificate ID for the DAK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The maximum number of signatures that the DAK can sign. A value of <code>-1</code> indicates that there's no
         * device limit.
         * </p>
         * 
         * @param maxAllowedSignature
         *        The maximum number of signatures that the DAK can sign. A value of <code>-1</code> indicates that
         *        there's no device limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAllowedSignature(Integer maxAllowedSignature);

        /**
         * <p>
         * Whether factory support has been enabled.
         * </p>
         * 
         * @param factorySupport
         *        Whether factory support has been enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder factorySupport(Boolean factorySupport);

        /**
         * <p>
         * The advertised product ID (APID) that's used for pre-production and production applications.
         * </p>
         * 
         * @param apId
         *        The advertised product ID (APID) that's used for pre-production and production applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apId(String apId);

        /**
         * <p>
         * The device type ID that's used for prototyping applications.
         * </p>
         * 
         * @param deviceTypeId
         *        The device type ID that's used for prototyping applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypeId(String deviceTypeId);
    }

    static final class BuilderImpl implements Builder {
        private String certificateId;

        private Integer maxAllowedSignature;

        private Boolean factorySupport;

        private String apId;

        private String deviceTypeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DakCertificateMetadata model) {
            certificateId(model.certificateId);
            maxAllowedSignature(model.maxAllowedSignature);
            factorySupport(model.factorySupport);
            apId(model.apId);
            deviceTypeId(model.deviceTypeId);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final Integer getMaxAllowedSignature() {
            return maxAllowedSignature;
        }

        public final void setMaxAllowedSignature(Integer maxAllowedSignature) {
            this.maxAllowedSignature = maxAllowedSignature;
        }

        @Override
        public final Builder maxAllowedSignature(Integer maxAllowedSignature) {
            this.maxAllowedSignature = maxAllowedSignature;
            return this;
        }

        public final Boolean getFactorySupport() {
            return factorySupport;
        }

        public final void setFactorySupport(Boolean factorySupport) {
            this.factorySupport = factorySupport;
        }

        @Override
        public final Builder factorySupport(Boolean factorySupport) {
            this.factorySupport = factorySupport;
            return this;
        }

        public final String getApId() {
            return apId;
        }

        public final void setApId(String apId) {
            this.apId = apId;
        }

        @Override
        public final Builder apId(String apId) {
            this.apId = apId;
            return this;
        }

        public final String getDeviceTypeId() {
            return deviceTypeId;
        }

        public final void setDeviceTypeId(String deviceTypeId) {
            this.deviceTypeId = deviceTypeId;
        }

        @Override
        public final Builder deviceTypeId(String deviceTypeId) {
            this.deviceTypeId = deviceTypeId;
            return this;
        }

        @Override
        public DakCertificateMetadata build() {
            return new DakCertificateMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
