/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceProfileResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetDeviceProfileResponse.Builder, GetDeviceProfileResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetDeviceProfileResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetDeviceProfileResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetDeviceProfileResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<LoRaWANDeviceProfile> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANDeviceProfile> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(GetDeviceProfileResponse::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANDeviceProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<SidewalkGetDeviceProfile> SIDEWALK_FIELD = SdkField
            .<SidewalkGetDeviceProfile> builder(MarshallingType.SDK_POJO).memberName("Sidewalk")
            .getter(getter(GetDeviceProfileResponse::sidewalk)).setter(setter(Builder::sidewalk))
            .constructor(SidewalkGetDeviceProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            ID_FIELD, LO_RA_WAN_FIELD, SIDEWALK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String id;

    private final LoRaWANDeviceProfile loRaWAN;

    private final SidewalkGetDeviceProfile sidewalk;

    private GetDeviceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.id = builder.id;
        this.loRaWAN = builder.loRaWAN;
        this.sidewalk = builder.sidewalk;
    }

    /**
     * <p>
     * The Amazon Resource Name of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the device profile.
     * </p>
     * 
     * @return The ID of the device profile.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Information about the device profile.
     * </p>
     * 
     * @return Information about the device profile.
     */
    public final LoRaWANDeviceProfile loRaWAN() {
        return loRaWAN;
    }

    /**
     * <p>
     * Information about the Sidewalk parameters in the device profile.
     * </p>
     * 
     * @return Information about the Sidewalk parameters in the device profile.
     */
    public final SidewalkGetDeviceProfile sidewalk() {
        return sidewalk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceProfileResponse)) {
            return false;
        }
        GetDeviceProfileResponse other = (GetDeviceProfileResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(loRaWAN(), other.loRaWAN()) && Objects.equals(sidewalk(), other.sidewalk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeviceProfileResponse").add("Arn", arn()).add("Name", name()).add("Id", id())
                .add("LoRaWAN", loRaWAN()).add("Sidewalk", sidewalk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "Sidewalk":
            return Optional.ofNullable(clazz.cast(sidewalk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LoRaWAN", LO_RA_WAN_FIELD);
        map.put("Sidewalk", SIDEWALK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceProfileResponse, T> g) {
        return obj -> g.apply((GetDeviceProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeviceProfileResponse> {
        /**
         * <p>
         * The Amazon Resource Name of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the device profile.
         * </p>
         * 
         * @param id
         *        The ID of the device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Information about the device profile.
         * </p>
         * 
         * @param loRaWAN
         *        Information about the device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANDeviceProfile loRaWAN);

        /**
         * <p>
         * Information about the device profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoRaWANDeviceProfile.Builder} avoiding
         * the need to create one manually via {@link LoRaWANDeviceProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoRaWANDeviceProfile.Builder#build()} is called immediately and
         * its result is passed to {@link #loRaWAN(LoRaWANDeviceProfile)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANDeviceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANDeviceProfile)
         */
        default Builder loRaWAN(Consumer<LoRaWANDeviceProfile.Builder> loRaWAN) {
            return loRaWAN(LoRaWANDeviceProfile.builder().applyMutation(loRaWAN).build());
        }

        /**
         * <p>
         * Information about the Sidewalk parameters in the device profile.
         * </p>
         * 
         * @param sidewalk
         *        Information about the Sidewalk parameters in the device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalk(SidewalkGetDeviceProfile sidewalk);

        /**
         * <p>
         * Information about the Sidewalk parameters in the device profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link SidewalkGetDeviceProfile.Builder}
         * avoiding the need to create one manually via {@link SidewalkGetDeviceProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SidewalkGetDeviceProfile.Builder#build()} is called immediately
         * and its result is passed to {@link #sidewalk(SidewalkGetDeviceProfile)}.
         * 
         * @param sidewalk
         *        a consumer that will call methods on {@link SidewalkGetDeviceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sidewalk(SidewalkGetDeviceProfile)
         */
        default Builder sidewalk(Consumer<SidewalkGetDeviceProfile.Builder> sidewalk) {
            return sidewalk(SidewalkGetDeviceProfile.builder().applyMutation(sidewalk).build());
        }
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String id;

        private LoRaWANDeviceProfile loRaWAN;

        private SidewalkGetDeviceProfile sidewalk;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceProfileResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            id(model.id);
            loRaWAN(model.loRaWAN);
            sidewalk(model.sidewalk);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final LoRaWANDeviceProfile.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANDeviceProfile.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANDeviceProfile loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final SidewalkGetDeviceProfile.Builder getSidewalk() {
            return sidewalk != null ? sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkGetDeviceProfile.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkGetDeviceProfile sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        @Override
        public GetDeviceProfileResponse build() {
            return new GetDeviceProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
