/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPartnerAccountRequest extends IotWirelessRequest implements
        ToCopyableBuilder<GetPartnerAccountRequest.Builder, GetPartnerAccountRequest> {
    private static final SdkField<String> PARTNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartnerAccountId").getter(getter(GetPartnerAccountRequest::partnerAccountId))
            .setter(setter(Builder::partnerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PartnerAccountId").build()).build();

    private static final SdkField<String> PARTNER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartnerType").getter(getter(GetPartnerAccountRequest::partnerTypeAsString))
            .setter(setter(Builder::partnerType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partnerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNER_ACCOUNT_ID_FIELD,
            PARTNER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String partnerAccountId;

    private final String partnerType;

    private GetPartnerAccountRequest(BuilderImpl builder) {
        super(builder);
        this.partnerAccountId = builder.partnerAccountId;
        this.partnerType = builder.partnerType;
    }

    /**
     * <p>
     * The partner account ID to disassociate from the AWS account.
     * </p>
     * 
     * @return The partner account ID to disassociate from the AWS account.
     */
    public final String partnerAccountId() {
        return partnerAccountId;
    }

    /**
     * <p>
     * The partner type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partnerType} will
     * return {@link PartnerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partnerTypeAsString}.
     * </p>
     * 
     * @return The partner type.
     * @see PartnerType
     */
    public final PartnerType partnerType() {
        return PartnerType.fromValue(partnerType);
    }

    /**
     * <p>
     * The partner type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partnerType} will
     * return {@link PartnerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partnerTypeAsString}.
     * </p>
     * 
     * @return The partner type.
     * @see PartnerType
     */
    public final String partnerTypeAsString() {
        return partnerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(partnerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(partnerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartnerAccountRequest)) {
            return false;
        }
        GetPartnerAccountRequest other = (GetPartnerAccountRequest) obj;
        return Objects.equals(partnerAccountId(), other.partnerAccountId())
                && Objects.equals(partnerTypeAsString(), other.partnerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPartnerAccountRequest").add("PartnerAccountId", partnerAccountId())
                .add("PartnerType", partnerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartnerAccountId":
            return Optional.ofNullable(clazz.cast(partnerAccountId()));
        case "PartnerType":
            return Optional.ofNullable(clazz.cast(partnerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PartnerAccountId", PARTNER_ACCOUNT_ID_FIELD);
        map.put("partnerType", PARTNER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPartnerAccountRequest, T> g) {
        return obj -> g.apply((GetPartnerAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPartnerAccountRequest> {
        /**
         * <p>
         * The partner account ID to disassociate from the AWS account.
         * </p>
         * 
         * @param partnerAccountId
         *        The partner account ID to disassociate from the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerAccountId(String partnerAccountId);

        /**
         * <p>
         * The partner type.
         * </p>
         * 
         * @param partnerType
         *        The partner type.
         * @see PartnerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerType
         */
        Builder partnerType(String partnerType);

        /**
         * <p>
         * The partner type.
         * </p>
         * 
         * @param partnerType
         *        The partner type.
         * @see PartnerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerType
         */
        Builder partnerType(PartnerType partnerType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String partnerAccountId;

        private String partnerType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPartnerAccountRequest model) {
            super(model);
            partnerAccountId(model.partnerAccountId);
            partnerType(model.partnerType);
        }

        public final String getPartnerAccountId() {
            return partnerAccountId;
        }

        public final void setPartnerAccountId(String partnerAccountId) {
            this.partnerAccountId = partnerAccountId;
        }

        @Override
        public final Builder partnerAccountId(String partnerAccountId) {
            this.partnerAccountId = partnerAccountId;
            return this;
        }

        public final String getPartnerType() {
            return partnerType;
        }

        public final void setPartnerType(String partnerType) {
            this.partnerType = partnerType;
        }

        @Override
        public final Builder partnerType(String partnerType) {
            this.partnerType = partnerType;
            return this;
        }

        @Override
        public final Builder partnerType(PartnerType partnerType) {
            this.partnerType(partnerType == null ? null : partnerType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPartnerAccountRequest build() {
            return new GetPartnerAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
