/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWirelessDeviceResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetWirelessDeviceResponse.Builder, GetWirelessDeviceResponse> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetWirelessDeviceResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetWirelessDeviceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetWirelessDeviceResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(GetWirelessDeviceResponse::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetWirelessDeviceResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetWirelessDeviceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThingName").getter(getter(GetWirelessDeviceResponse::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThingName").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThingArn").getter(getter(GetWirelessDeviceResponse::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThingArn").build()).build();

    private static final SdkField<LoRaWANDevice> LO_RA_WAN_FIELD = SdkField.<LoRaWANDevice> builder(MarshallingType.SDK_POJO)
            .memberName("LoRaWAN").getter(getter(GetWirelessDeviceResponse::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<SidewalkDevice> SIDEWALK_FIELD = SdkField.<SidewalkDevice> builder(MarshallingType.SDK_POJO)
            .memberName("Sidewalk").getter(getter(GetWirelessDeviceResponse::sidewalk)).setter(setter(Builder::sidewalk))
            .constructor(SidewalkDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()).build();

    private static final SdkField<String> POSITIONING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Positioning").getter(getter(GetWirelessDeviceResponse::positioningAsString))
            .setter(setter(Builder::positioning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, DESTINATION_NAME_FIELD, ID_FIELD, ARN_FIELD, THING_NAME_FIELD, THING_ARN_FIELD, LO_RA_WAN_FIELD,
            SIDEWALK_FIELD, POSITIONING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String type;

    private final String name;

    private final String description;

    private final String destinationName;

    private final String id;

    private final String arn;

    private final String thingName;

    private final String thingArn;

    private final LoRaWANDevice loRaWAN;

    private final SidewalkDevice sidewalk;

    private final String positioning;

    private GetWirelessDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.destinationName = builder.destinationName;
        this.id = builder.id;
        this.arn = builder.arn;
        this.thingName = builder.thingName;
        this.thingArn = builder.thingArn;
        this.loRaWAN = builder.loRaWAN;
        this.sidewalk = builder.sidewalk;
        this.positioning = builder.positioning;
    }

    /**
     * <p>
     * The wireless device type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WirelessDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The wireless device type.
     * @see WirelessDeviceType
     */
    public final WirelessDeviceType type() {
        return WirelessDeviceType.fromValue(type);
    }

    /**
     * <p>
     * The wireless device type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WirelessDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The wireless device type.
     * @see WirelessDeviceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the resource.
     * </p>
     * 
     * @return The description of the resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the destination to which the device is assigned.
     * </p>
     * 
     * @return The name of the destination to which the device is assigned.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * The ID of the wireless device.
     * </p>
     * 
     * @return The ID of the wireless device.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the thing associated with the wireless device. The value is empty if a thing isn't associated with
     * the device.
     * </p>
     * 
     * @return The name of the thing associated with the wireless device. The value is empty if a thing isn't associated
     *         with the device.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The ARN of the thing associated with the wireless device.
     * </p>
     * 
     * @return The ARN of the thing associated with the wireless device.
     */
    public final String thingArn() {
        return thingArn;
    }

    /**
     * <p>
     * Information about the wireless device.
     * </p>
     * 
     * @return Information about the wireless device.
     */
    public final LoRaWANDevice loRaWAN() {
        return loRaWAN;
    }

    /**
     * <p>
     * Sidewalk device object.
     * </p>
     * 
     * @return Sidewalk device object.
     */
    public final SidewalkDevice sidewalk() {
        return sidewalk;
    }

    /**
     * <p>
     * FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positioning} will
     * return {@link PositioningConfigStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positioningAsString}.
     * </p>
     * 
     * @return FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
     * @see PositioningConfigStatus
     */
    public final PositioningConfigStatus positioning() {
        return PositioningConfigStatus.fromValue(positioning);
    }

    /**
     * <p>
     * FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positioning} will
     * return {@link PositioningConfigStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positioningAsString}.
     * </p>
     * 
     * @return FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
     * @see PositioningConfigStatus
     */
    public final String positioningAsString() {
        return positioning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(positioningAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessDeviceResponse)) {
            return false;
        }
        GetWirelessDeviceResponse other = (GetWirelessDeviceResponse) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(destinationName(), other.destinationName()) && Objects.equals(id(), other.id())
                && Objects.equals(arn(), other.arn()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(thingArn(), other.thingArn()) && Objects.equals(loRaWAN(), other.loRaWAN())
                && Objects.equals(sidewalk(), other.sidewalk())
                && Objects.equals(positioningAsString(), other.positioningAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWirelessDeviceResponse").add("Type", typeAsString()).add("Name", name())
                .add("Description", description()).add("DestinationName", destinationName()).add("Id", id()).add("Arn", arn())
                .add("ThingName", thingName()).add("ThingArn", thingArn()).add("LoRaWAN", loRaWAN()).add("Sidewalk", sidewalk())
                .add("Positioning", positioningAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ThingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "ThingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "Sidewalk":
            return Optional.ofNullable(clazz.cast(sidewalk()));
        case "Positioning":
            return Optional.ofNullable(clazz.cast(positioningAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DestinationName", DESTINATION_NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ThingName", THING_NAME_FIELD);
        map.put("ThingArn", THING_ARN_FIELD);
        map.put("LoRaWAN", LO_RA_WAN_FIELD);
        map.put("Sidewalk", SIDEWALK_FIELD);
        map.put("Positioning", POSITIONING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessDeviceResponse, T> g) {
        return obj -> g.apply((GetWirelessDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWirelessDeviceResponse> {
        /**
         * <p>
         * The wireless device type.
         * </p>
         * 
         * @param type
         *        The wireless device type.
         * @see WirelessDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceType
         */
        Builder type(String type);

        /**
         * <p>
         * The wireless device type.
         * </p>
         * 
         * @param type
         *        The wireless device type.
         * @see WirelessDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceType
         */
        Builder type(WirelessDeviceType type);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the resource.
         * </p>
         * 
         * @param description
         *        The description of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the destination to which the device is assigned.
         * </p>
         * 
         * @param destinationName
         *        The name of the destination to which the device is assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * The ID of the wireless device.
         * </p>
         * 
         * @param id
         *        The ID of the wireless device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the thing associated with the wireless device. The value is empty if a thing isn't associated
         * with the device.
         * </p>
         * 
         * @param thingName
         *        The name of the thing associated with the wireless device. The value is empty if a thing isn't
         *        associated with the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The ARN of the thing associated with the wireless device.
         * </p>
         * 
         * @param thingArn
         *        The ARN of the thing associated with the wireless device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        /**
         * <p>
         * Information about the wireless device.
         * </p>
         * 
         * @param loRaWAN
         *        Information about the wireless device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANDevice loRaWAN);

        /**
         * <p>
         * Information about the wireless device.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoRaWANDevice.Builder} avoiding the need
         * to create one manually via {@link LoRaWANDevice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoRaWANDevice.Builder#build()} is called immediately and its
         * result is passed to {@link #loRaWAN(LoRaWANDevice)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANDevice)
         */
        default Builder loRaWAN(Consumer<LoRaWANDevice.Builder> loRaWAN) {
            return loRaWAN(LoRaWANDevice.builder().applyMutation(loRaWAN).build());
        }

        /**
         * <p>
         * Sidewalk device object.
         * </p>
         * 
         * @param sidewalk
         *        Sidewalk device object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalk(SidewalkDevice sidewalk);

        /**
         * <p>
         * Sidewalk device object.
         * </p>
         * This is a convenience method that creates an instance of the {@link SidewalkDevice.Builder} avoiding the need
         * to create one manually via {@link SidewalkDevice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SidewalkDevice.Builder#build()} is called immediately and its
         * result is passed to {@link #sidewalk(SidewalkDevice)}.
         * 
         * @param sidewalk
         *        a consumer that will call methods on {@link SidewalkDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sidewalk(SidewalkDevice)
         */
        default Builder sidewalk(Consumer<SidewalkDevice.Builder> sidewalk) {
            return sidewalk(SidewalkDevice.builder().applyMutation(sidewalk).build());
        }

        /**
         * <p>
         * FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
         * </p>
         * 
         * @param positioning
         *        FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
         * @see PositioningConfigStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositioningConfigStatus
         */
        Builder positioning(String positioning);

        /**
         * <p>
         * FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
         * </p>
         * 
         * @param positioning
         *        FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
         * @see PositioningConfigStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositioningConfigStatus
         */
        Builder positioning(PositioningConfigStatus positioning);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String type;

        private String name;

        private String description;

        private String destinationName;

        private String id;

        private String arn;

        private String thingName;

        private String thingArn;

        private LoRaWANDevice loRaWAN;

        private SidewalkDevice sidewalk;

        private String positioning;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessDeviceResponse model) {
            super(model);
            type(model.type);
            name(model.name);
            description(model.description);
            destinationName(model.destinationName);
            id(model.id);
            arn(model.arn);
            thingName(model.thingName);
            thingArn(model.thingArn);
            loRaWAN(model.loRaWAN);
            sidewalk(model.sidewalk);
            positioning(model.positioning);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WirelessDeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingArn() {
            return thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final LoRaWANDevice.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANDevice.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANDevice loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final SidewalkDevice.Builder getSidewalk() {
            return sidewalk != null ? sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkDevice.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkDevice sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final String getPositioning() {
            return positioning;
        }

        public final void setPositioning(String positioning) {
            this.positioning = positioning;
        }

        @Override
        public final Builder positioning(String positioning) {
            this.positioning = positioning;
            return this;
        }

        @Override
        public final Builder positioning(PositioningConfigStatus positioning) {
            this.positioning(positioning == null ? null : positioning.toString());
            return this;
        }

        @Override
        public GetWirelessDeviceResponse build() {
            return new GetWirelessDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
