/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPositionConfigurationsResponse extends IotWirelessResponse implements
        ToCopyableBuilder<ListPositionConfigurationsResponse.Builder, ListPositionConfigurationsResponse> {
    private static final SdkField<List<PositionConfigurationItem>> POSITION_CONFIGURATION_LIST_FIELD = SdkField
            .<List<PositionConfigurationItem>> builder(MarshallingType.LIST)
            .memberName("PositionConfigurationList")
            .getter(getter(ListPositionConfigurationsResponse::positionConfigurationList))
            .setter(setter(Builder::positionConfigurationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionConfigurationList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PositionConfigurationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(PositionConfigurationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPositionConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            POSITION_CONFIGURATION_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PositionConfigurationItem> positionConfigurationList;

    private final String nextToken;

    private ListPositionConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.positionConfigurationList = builder.positionConfigurationList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PositionConfigurationList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPositionConfigurationList() {
        return positionConfigurationList != null && !(positionConfigurationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of position configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPositionConfigurationList} method.
     * </p>
     * 
     * @return A list of position configurations.
     */
    public final List<PositionConfigurationItem> positionConfigurationList() {
        return positionConfigurationList;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPositionConfigurationList() ? positionConfigurationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPositionConfigurationsResponse)) {
            return false;
        }
        ListPositionConfigurationsResponse other = (ListPositionConfigurationsResponse) obj;
        return hasPositionConfigurationList() == other.hasPositionConfigurationList()
                && Objects.equals(positionConfigurationList(), other.positionConfigurationList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPositionConfigurationsResponse")
                .add("PositionConfigurationList", hasPositionConfigurationList() ? positionConfigurationList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PositionConfigurationList":
            return Optional.ofNullable(clazz.cast(positionConfigurationList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PositionConfigurationList", POSITION_CONFIGURATION_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPositionConfigurationsResponse, T> g) {
        return obj -> g.apply((ListPositionConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPositionConfigurationsResponse> {
        /**
         * <p>
         * A list of position configurations.
         * </p>
         * 
         * @param positionConfigurationList
         *        A list of position configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positionConfigurationList(Collection<PositionConfigurationItem> positionConfigurationList);

        /**
         * <p>
         * A list of position configurations.
         * </p>
         * 
         * @param positionConfigurationList
         *        A list of position configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positionConfigurationList(PositionConfigurationItem... positionConfigurationList);

        /**
         * <p>
         * A list of position configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.PositionConfigurationItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotwireless.model.PositionConfigurationItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.PositionConfigurationItem.Builder#build()} is called
         * immediately and its result is passed to {@link #positionConfigurationList(List<PositionConfigurationItem>)}.
         * 
         * @param positionConfigurationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.PositionConfigurationItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #positionConfigurationList(java.util.Collection<PositionConfigurationItem>)
         */
        Builder positionConfigurationList(Consumer<PositionConfigurationItem.Builder>... positionConfigurationList);

        /**
         * <p>
         * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private List<PositionConfigurationItem> positionConfigurationList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPositionConfigurationsResponse model) {
            super(model);
            positionConfigurationList(model.positionConfigurationList);
            nextToken(model.nextToken);
        }

        public final List<PositionConfigurationItem.Builder> getPositionConfigurationList() {
            List<PositionConfigurationItem.Builder> result = PositionConfigurationListCopier
                    .copyToBuilder(this.positionConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPositionConfigurationList(Collection<PositionConfigurationItem.BuilderImpl> positionConfigurationList) {
            this.positionConfigurationList = PositionConfigurationListCopier.copyFromBuilder(positionConfigurationList);
        }

        @Override
        public final Builder positionConfigurationList(Collection<PositionConfigurationItem> positionConfigurationList) {
            this.positionConfigurationList = PositionConfigurationListCopier.copy(positionConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder positionConfigurationList(PositionConfigurationItem... positionConfigurationList) {
            positionConfigurationList(Arrays.asList(positionConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder positionConfigurationList(Consumer<PositionConfigurationItem.Builder>... positionConfigurationList) {
            positionConfigurationList(Stream.of(positionConfigurationList)
                    .map(c -> PositionConfigurationItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPositionConfigurationsResponse build() {
            return new ListPositionConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
