/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWirelessGatewayTaskDefinitionsRequest extends IotWirelessRequest implements
        ToCopyableBuilder<ListWirelessGatewayTaskDefinitionsRequest.Builder, ListWirelessGatewayTaskDefinitionsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListWirelessGatewayTaskDefinitionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWirelessGatewayTaskDefinitionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> TASK_DEFINITION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskDefinitionType")
            .getter(getter(ListWirelessGatewayTaskDefinitionsRequest::taskDefinitionTypeAsString))
            .setter(setter(Builder::taskDefinitionType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("taskDefinitionType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, TASK_DEFINITION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String taskDefinitionType;

    private ListWirelessGatewayTaskDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.taskDefinitionType = builder.taskDefinitionType;
    }

    /**
     * <p>
     * The maximum number of results to return in this operation.
     * </p>
     * 
     * @return The maximum number of results to return in this operation.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     * <b>null</b> to receive the first set of results.
     * </p>
     * 
     * @return To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     *         <b>null</b> to receive the first set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A filter to list only the wireless gateway task definitions that use this task definition type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #taskDefinitionType} will return {@link WirelessGatewayTaskDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #taskDefinitionTypeAsString}.
     * </p>
     * 
     * @return A filter to list only the wireless gateway task definitions that use this task definition type.
     * @see WirelessGatewayTaskDefinitionType
     */
    public final WirelessGatewayTaskDefinitionType taskDefinitionType() {
        return WirelessGatewayTaskDefinitionType.fromValue(taskDefinitionType);
    }

    /**
     * <p>
     * A filter to list only the wireless gateway task definitions that use this task definition type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #taskDefinitionType} will return {@link WirelessGatewayTaskDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #taskDefinitionTypeAsString}.
     * </p>
     * 
     * @return A filter to list only the wireless gateway task definitions that use this task definition type.
     * @see WirelessGatewayTaskDefinitionType
     */
    public final String taskDefinitionTypeAsString() {
        return taskDefinitionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinitionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWirelessGatewayTaskDefinitionsRequest)) {
            return false;
        }
        ListWirelessGatewayTaskDefinitionsRequest other = (ListWirelessGatewayTaskDefinitionsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(taskDefinitionTypeAsString(), other.taskDefinitionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWirelessGatewayTaskDefinitionsRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("TaskDefinitionType", taskDefinitionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TaskDefinitionType":
            return Optional.ofNullable(clazz.cast(taskDefinitionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("taskDefinitionType", TASK_DEFINITION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWirelessGatewayTaskDefinitionsRequest, T> g) {
        return obj -> g.apply((ListWirelessGatewayTaskDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWirelessGatewayTaskDefinitionsRequest> {
        /**
         * <p>
         * The maximum number of results to return in this operation.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
         * <b>null</b> to receive the first set of results.
         * </p>
         * 
         * @param nextToken
         *        To retrieve the next set of results, the <code>nextToken</code> value from a previous response;
         *        otherwise <b>null</b> to receive the first set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A filter to list only the wireless gateway task definitions that use this task definition type.
         * </p>
         * 
         * @param taskDefinitionType
         *        A filter to list only the wireless gateway task definitions that use this task definition type.
         * @see WirelessGatewayTaskDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessGatewayTaskDefinitionType
         */
        Builder taskDefinitionType(String taskDefinitionType);

        /**
         * <p>
         * A filter to list only the wireless gateway task definitions that use this task definition type.
         * </p>
         * 
         * @param taskDefinitionType
         *        A filter to list only the wireless gateway task definitions that use this task definition type.
         * @see WirelessGatewayTaskDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessGatewayTaskDefinitionType
         */
        Builder taskDefinitionType(WirelessGatewayTaskDefinitionType taskDefinitionType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String taskDefinitionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWirelessGatewayTaskDefinitionsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            taskDefinitionType(model.taskDefinitionType);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTaskDefinitionType() {
            return taskDefinitionType;
        }

        public final void setTaskDefinitionType(String taskDefinitionType) {
            this.taskDefinitionType = taskDefinitionType;
        }

        @Override
        public final Builder taskDefinitionType(String taskDefinitionType) {
            this.taskDefinitionType = taskDefinitionType;
            return this;
        }

        @Override
        public final Builder taskDefinitionType(WirelessGatewayTaskDefinitionType taskDefinitionType) {
            this.taskDefinitionType(taskDefinitionType == null ? null : taskDefinitionType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWirelessGatewayTaskDefinitionsRequest build() {
            return new ListWirelessGatewayTaskDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
