/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object for LoRaWAN join resource type event configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANJoinEventNotificationConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANJoinEventNotificationConfigurations.Builder, LoRaWANJoinEventNotificationConfigurations> {
    private static final SdkField<String> DEV_EUI_EVENT_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DevEuiEventTopic").getter(getter(LoRaWANJoinEventNotificationConfigurations::devEuiEventTopicAsString))
            .setter(setter(Builder::devEuiEventTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEuiEventTopic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_EUI_EVENT_TOPIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String devEuiEventTopic;

    private LoRaWANJoinEventNotificationConfigurations(BuilderImpl builder) {
        this.devEuiEventTopic = builder.devEuiEventTopic;
    }

    /**
     * <p>
     * Denotes whether the Dev EUI join event topic is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #devEuiEventTopic}
     * will return {@link EventNotificationTopicStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #devEuiEventTopicAsString}.
     * </p>
     * 
     * @return Denotes whether the Dev EUI join event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */
    public final EventNotificationTopicStatus devEuiEventTopic() {
        return EventNotificationTopicStatus.fromValue(devEuiEventTopic);
    }

    /**
     * <p>
     * Denotes whether the Dev EUI join event topic is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #devEuiEventTopic}
     * will return {@link EventNotificationTopicStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #devEuiEventTopicAsString}.
     * </p>
     * 
     * @return Denotes whether the Dev EUI join event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */
    public final String devEuiEventTopicAsString() {
        return devEuiEventTopic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devEuiEventTopicAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANJoinEventNotificationConfigurations)) {
            return false;
        }
        LoRaWANJoinEventNotificationConfigurations other = (LoRaWANJoinEventNotificationConfigurations) obj;
        return Objects.equals(devEuiEventTopicAsString(), other.devEuiEventTopicAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANJoinEventNotificationConfigurations").add("DevEuiEventTopic", devEuiEventTopicAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DevEuiEventTopic":
            return Optional.ofNullable(clazz.cast(devEuiEventTopicAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DevEuiEventTopic", DEV_EUI_EVENT_TOPIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANJoinEventNotificationConfigurations, T> g) {
        return obj -> g.apply((LoRaWANJoinEventNotificationConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANJoinEventNotificationConfigurations> {
        /**
         * <p>
         * Denotes whether the Dev EUI join event topic is enabled or disabled.
         * </p>
         * 
         * @param devEuiEventTopic
         *        Denotes whether the Dev EUI join event topic is enabled or disabled.
         * @see EventNotificationTopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationTopicStatus
         */
        Builder devEuiEventTopic(String devEuiEventTopic);

        /**
         * <p>
         * Denotes whether the Dev EUI join event topic is enabled or disabled.
         * </p>
         * 
         * @param devEuiEventTopic
         *        Denotes whether the Dev EUI join event topic is enabled or disabled.
         * @see EventNotificationTopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationTopicStatus
         */
        Builder devEuiEventTopic(EventNotificationTopicStatus devEuiEventTopic);
    }

    static final class BuilderImpl implements Builder {
        private String devEuiEventTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANJoinEventNotificationConfigurations model) {
            devEuiEventTopic(model.devEuiEventTopic);
        }

        public final String getDevEuiEventTopic() {
            return devEuiEventTopic;
        }

        public final void setDevEuiEventTopic(String devEuiEventTopic) {
            this.devEuiEventTopic = devEuiEventTopic;
        }

        @Override
        public final Builder devEuiEventTopic(String devEuiEventTopic) {
            this.devEuiEventTopic = devEuiEventTopic;
            return this;
        }

        @Override
        public final Builder devEuiEventTopic(EventNotificationTopicStatus devEuiEventTopic) {
            this.devEuiEventTopic(devEuiEventTopic == null ? null : devEuiEventTopic.toString());
            return this;
        }

        @Override
        public LoRaWANJoinEventNotificationConfigurations build() {
            return new LoRaWANJoinEventNotificationConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
