/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWANUpdateGatewayTaskEntry object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANUpdateGatewayTaskEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANUpdateGatewayTaskEntry.Builder, LoRaWANUpdateGatewayTaskEntry> {
    private static final SdkField<LoRaWANGatewayVersion> CURRENT_VERSION_FIELD = SdkField
            .<LoRaWANGatewayVersion> builder(MarshallingType.SDK_POJO).memberName("CurrentVersion")
            .getter(getter(LoRaWANUpdateGatewayTaskEntry::currentVersion)).setter(setter(Builder::currentVersion))
            .constructor(LoRaWANGatewayVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()).build();

    private static final SdkField<LoRaWANGatewayVersion> UPDATE_VERSION_FIELD = SdkField
            .<LoRaWANGatewayVersion> builder(MarshallingType.SDK_POJO).memberName("UpdateVersion")
            .getter(getter(LoRaWANUpdateGatewayTaskEntry::updateVersion)).setter(setter(Builder::updateVersion))
            .constructor(LoRaWANGatewayVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_VERSION_FIELD,
            UPDATE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LoRaWANGatewayVersion currentVersion;

    private final LoRaWANGatewayVersion updateVersion;

    private LoRaWANUpdateGatewayTaskEntry(BuilderImpl builder) {
        this.currentVersion = builder.currentVersion;
        this.updateVersion = builder.updateVersion;
    }

    /**
     * <p>
     * The version of the gateways that should receive the update.
     * </p>
     * 
     * @return The version of the gateways that should receive the update.
     */
    public final LoRaWANGatewayVersion currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * The firmware version to update the gateway to.
     * </p>
     * 
     * @return The firmware version to update the gateway to.
     */
    public final LoRaWANGatewayVersion updateVersion() {
        return updateVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(updateVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANUpdateGatewayTaskEntry)) {
            return false;
        }
        LoRaWANUpdateGatewayTaskEntry other = (LoRaWANUpdateGatewayTaskEntry) obj;
        return Objects.equals(currentVersion(), other.currentVersion()) && Objects.equals(updateVersion(), other.updateVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANUpdateGatewayTaskEntry").add("CurrentVersion", currentVersion())
                .add("UpdateVersion", updateVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "UpdateVersion":
            return Optional.ofNullable(clazz.cast(updateVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CurrentVersion", CURRENT_VERSION_FIELD);
        map.put("UpdateVersion", UPDATE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANUpdateGatewayTaskEntry, T> g) {
        return obj -> g.apply((LoRaWANUpdateGatewayTaskEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANUpdateGatewayTaskEntry> {
        /**
         * <p>
         * The version of the gateways that should receive the update.
         * </p>
         * 
         * @param currentVersion
         *        The version of the gateways that should receive the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(LoRaWANGatewayVersion currentVersion);

        /**
         * <p>
         * The version of the gateways that should receive the update.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoRaWANGatewayVersion.Builder} avoiding
         * the need to create one manually via {@link LoRaWANGatewayVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoRaWANGatewayVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #currentVersion(LoRaWANGatewayVersion)}.
         * 
         * @param currentVersion
         *        a consumer that will call methods on {@link LoRaWANGatewayVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentVersion(LoRaWANGatewayVersion)
         */
        default Builder currentVersion(Consumer<LoRaWANGatewayVersion.Builder> currentVersion) {
            return currentVersion(LoRaWANGatewayVersion.builder().applyMutation(currentVersion).build());
        }

        /**
         * <p>
         * The firmware version to update the gateway to.
         * </p>
         * 
         * @param updateVersion
         *        The firmware version to update the gateway to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateVersion(LoRaWANGatewayVersion updateVersion);

        /**
         * <p>
         * The firmware version to update the gateway to.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoRaWANGatewayVersion.Builder} avoiding
         * the need to create one manually via {@link LoRaWANGatewayVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoRaWANGatewayVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #updateVersion(LoRaWANGatewayVersion)}.
         * 
         * @param updateVersion
         *        a consumer that will call methods on {@link LoRaWANGatewayVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateVersion(LoRaWANGatewayVersion)
         */
        default Builder updateVersion(Consumer<LoRaWANGatewayVersion.Builder> updateVersion) {
            return updateVersion(LoRaWANGatewayVersion.builder().applyMutation(updateVersion).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LoRaWANGatewayVersion currentVersion;

        private LoRaWANGatewayVersion updateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANUpdateGatewayTaskEntry model) {
            currentVersion(model.currentVersion);
            updateVersion(model.updateVersion);
        }

        public final LoRaWANGatewayVersion.Builder getCurrentVersion() {
            return currentVersion != null ? currentVersion.toBuilder() : null;
        }

        public final void setCurrentVersion(LoRaWANGatewayVersion.BuilderImpl currentVersion) {
            this.currentVersion = currentVersion != null ? currentVersion.build() : null;
        }

        @Override
        public final Builder currentVersion(LoRaWANGatewayVersion currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final LoRaWANGatewayVersion.Builder getUpdateVersion() {
            return updateVersion != null ? updateVersion.toBuilder() : null;
        }

        public final void setUpdateVersion(LoRaWANGatewayVersion.BuilderImpl updateVersion) {
            this.updateVersion = updateVersion != null ? updateVersion.build() : null;
        }

        @Override
        public final Builder updateVersion(LoRaWANGatewayVersion updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        @Override
        public LoRaWANUpdateGatewayTaskEntry build() {
            return new LoRaWANUpdateGatewayTaskEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
