/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LTE object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LteObj implements SdkPojo, Serializable, ToCopyableBuilder<LteObj.Builder, LteObj> {
    private static final SdkField<Integer> MCC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Mcc")
            .getter(getter(LteObj::mcc)).setter(setter(Builder::mcc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mcc").build()).build();

    private static final SdkField<Integer> MNC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Mnc")
            .getter(getter(LteObj::mnc)).setter(setter(Builder::mnc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mnc").build()).build();

    private static final SdkField<Integer> EUTRAN_CID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EutranCid").getter(getter(LteObj::eutranCid)).setter(setter(Builder::eutranCid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EutranCid").build()).build();

    private static final SdkField<Integer> TAC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Tac")
            .getter(getter(LteObj::tac)).setter(setter(Builder::tac))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tac").build()).build();

    private static final SdkField<LteLocalId> LTE_LOCAL_ID_FIELD = SdkField.<LteLocalId> builder(MarshallingType.SDK_POJO)
            .memberName("LteLocalId").getter(getter(LteObj::lteLocalId)).setter(setter(Builder::lteLocalId))
            .constructor(LteLocalId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LteLocalId").build()).build();

    private static final SdkField<Integer> LTE_TIMING_ADVANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LteTimingAdvance").getter(getter(LteObj::lteTimingAdvance)).setter(setter(Builder::lteTimingAdvance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LteTimingAdvance").build()).build();

    private static final SdkField<Integer> RSRP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rsrp")
            .getter(getter(LteObj::rsrp)).setter(setter(Builder::rsrp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrp").build()).build();

    private static final SdkField<Float> RSRQ_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Rsrq")
            .getter(getter(LteObj::rsrq)).setter(setter(Builder::rsrq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrq").build()).build();

    private static final SdkField<Boolean> NR_CAPABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NrCapable").getter(getter(LteObj::nrCapable)).setter(setter(Builder::nrCapable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NrCapable").build()).build();

    private static final SdkField<List<LteNmrObj>> LTE_NMR_FIELD = SdkField
            .<List<LteNmrObj>> builder(MarshallingType.LIST)
            .memberName("LteNmr")
            .getter(getter(LteObj::lteNmr))
            .setter(setter(Builder::lteNmr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LteNmr").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LteNmrObj> builder(MarshallingType.SDK_POJO)
                                            .constructor(LteNmrObj::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MCC_FIELD, MNC_FIELD,
            EUTRAN_CID_FIELD, TAC_FIELD, LTE_LOCAL_ID_FIELD, LTE_TIMING_ADVANCE_FIELD, RSRP_FIELD, RSRQ_FIELD, NR_CAPABLE_FIELD,
            LTE_NMR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer mcc;

    private final Integer mnc;

    private final Integer eutranCid;

    private final Integer tac;

    private final LteLocalId lteLocalId;

    private final Integer lteTimingAdvance;

    private final Integer rsrp;

    private final Float rsrq;

    private final Boolean nrCapable;

    private final List<LteNmrObj> lteNmr;

    private LteObj(BuilderImpl builder) {
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.eutranCid = builder.eutranCid;
        this.tac = builder.tac;
        this.lteLocalId = builder.lteLocalId;
        this.lteTimingAdvance = builder.lteTimingAdvance;
        this.rsrp = builder.rsrp;
        this.rsrq = builder.rsrq;
        this.nrCapable = builder.nrCapable;
        this.lteNmr = builder.lteNmr;
    }

    /**
     * <p>
     * Mobile Country Code.
     * </p>
     * 
     * @return Mobile Country Code.
     */
    public final Integer mcc() {
        return mcc;
    }

    /**
     * <p>
     * Mobile Network Code.
     * </p>
     * 
     * @return Mobile Network Code.
     */
    public final Integer mnc() {
        return mnc;
    }

    /**
     * <p>
     * E-UTRAN (Evolved Universal Terrestrial Radio Access Network) Cell Global Identifier.
     * </p>
     * 
     * @return E-UTRAN (Evolved Universal Terrestrial Radio Access Network) Cell Global Identifier.
     */
    public final Integer eutranCid() {
        return eutranCid;
    }

    /**
     * <p>
     * LTE tracking area code.
     * </p>
     * 
     * @return LTE tracking area code.
     */
    public final Integer tac() {
        return tac;
    }

    /**
     * <p>
     * LTE local identification (local ID) information.
     * </p>
     * 
     * @return LTE local identification (local ID) information.
     */
    public final LteLocalId lteLocalId() {
        return lteLocalId;
    }

    /**
     * <p>
     * LTE timing advance.
     * </p>
     * 
     * @return LTE timing advance.
     */
    public final Integer lteTimingAdvance() {
        return lteTimingAdvance;
    }

    /**
     * <p>
     * Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
     * </p>
     * 
     * @return Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
     */
    public final Integer rsrp() {
        return rsrp;
    }

    /**
     * <p>
     * Signal quality of the reference Signal received, measured in decibels (dB).
     * </p>
     * 
     * @return Signal quality of the reference Signal received, measured in decibels (dB).
     */
    public final Float rsrq() {
        return rsrq;
    }

    /**
     * <p>
     * Parameter that determines whether the LTE object is capable of supporting NR (new radio).
     * </p>
     * 
     * @return Parameter that determines whether the LTE object is capable of supporting NR (new radio).
     */
    public final Boolean nrCapable() {
        return nrCapable;
    }

    /**
     * For responses, this returns true if the service returned a value for the LteNmr property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLteNmr() {
        return lteNmr != null && !(lteNmr instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * LTE object for network measurement reports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLteNmr} method.
     * </p>
     * 
     * @return LTE object for network measurement reports.
     */
    public final List<LteNmrObj> lteNmr() {
        return lteNmr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mcc());
        hashCode = 31 * hashCode + Objects.hashCode(mnc());
        hashCode = 31 * hashCode + Objects.hashCode(eutranCid());
        hashCode = 31 * hashCode + Objects.hashCode(tac());
        hashCode = 31 * hashCode + Objects.hashCode(lteLocalId());
        hashCode = 31 * hashCode + Objects.hashCode(lteTimingAdvance());
        hashCode = 31 * hashCode + Objects.hashCode(rsrp());
        hashCode = 31 * hashCode + Objects.hashCode(rsrq());
        hashCode = 31 * hashCode + Objects.hashCode(nrCapable());
        hashCode = 31 * hashCode + Objects.hashCode(hasLteNmr() ? lteNmr() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LteObj)) {
            return false;
        }
        LteObj other = (LteObj) obj;
        return Objects.equals(mcc(), other.mcc()) && Objects.equals(mnc(), other.mnc())
                && Objects.equals(eutranCid(), other.eutranCid()) && Objects.equals(tac(), other.tac())
                && Objects.equals(lteLocalId(), other.lteLocalId())
                && Objects.equals(lteTimingAdvance(), other.lteTimingAdvance()) && Objects.equals(rsrp(), other.rsrp())
                && Objects.equals(rsrq(), other.rsrq()) && Objects.equals(nrCapable(), other.nrCapable())
                && hasLteNmr() == other.hasLteNmr() && Objects.equals(lteNmr(), other.lteNmr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LteObj").add("Mcc", mcc()).add("Mnc", mnc()).add("EutranCid", eutranCid()).add("Tac", tac())
                .add("LteLocalId", lteLocalId()).add("LteTimingAdvance", lteTimingAdvance()).add("Rsrp", rsrp())
                .add("Rsrq", rsrq()).add("NrCapable", nrCapable()).add("LteNmr", hasLteNmr() ? lteNmr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mcc":
            return Optional.ofNullable(clazz.cast(mcc()));
        case "Mnc":
            return Optional.ofNullable(clazz.cast(mnc()));
        case "EutranCid":
            return Optional.ofNullable(clazz.cast(eutranCid()));
        case "Tac":
            return Optional.ofNullable(clazz.cast(tac()));
        case "LteLocalId":
            return Optional.ofNullable(clazz.cast(lteLocalId()));
        case "LteTimingAdvance":
            return Optional.ofNullable(clazz.cast(lteTimingAdvance()));
        case "Rsrp":
            return Optional.ofNullable(clazz.cast(rsrp()));
        case "Rsrq":
            return Optional.ofNullable(clazz.cast(rsrq()));
        case "NrCapable":
            return Optional.ofNullable(clazz.cast(nrCapable()));
        case "LteNmr":
            return Optional.ofNullable(clazz.cast(lteNmr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Mcc", MCC_FIELD);
        map.put("Mnc", MNC_FIELD);
        map.put("EutranCid", EUTRAN_CID_FIELD);
        map.put("Tac", TAC_FIELD);
        map.put("LteLocalId", LTE_LOCAL_ID_FIELD);
        map.put("LteTimingAdvance", LTE_TIMING_ADVANCE_FIELD);
        map.put("Rsrp", RSRP_FIELD);
        map.put("Rsrq", RSRQ_FIELD);
        map.put("NrCapable", NR_CAPABLE_FIELD);
        map.put("LteNmr", LTE_NMR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LteObj, T> g) {
        return obj -> g.apply((LteObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LteObj> {
        /**
         * <p>
         * Mobile Country Code.
         * </p>
         * 
         * @param mcc
         *        Mobile Country Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcc(Integer mcc);

        /**
         * <p>
         * Mobile Network Code.
         * </p>
         * 
         * @param mnc
         *        Mobile Network Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mnc(Integer mnc);

        /**
         * <p>
         * E-UTRAN (Evolved Universal Terrestrial Radio Access Network) Cell Global Identifier.
         * </p>
         * 
         * @param eutranCid
         *        E-UTRAN (Evolved Universal Terrestrial Radio Access Network) Cell Global Identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eutranCid(Integer eutranCid);

        /**
         * <p>
         * LTE tracking area code.
         * </p>
         * 
         * @param tac
         *        LTE tracking area code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tac(Integer tac);

        /**
         * <p>
         * LTE local identification (local ID) information.
         * </p>
         * 
         * @param lteLocalId
         *        LTE local identification (local ID) information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lteLocalId(LteLocalId lteLocalId);

        /**
         * <p>
         * LTE local identification (local ID) information.
         * </p>
         * This is a convenience method that creates an instance of the {@link LteLocalId.Builder} avoiding the need to
         * create one manually via {@link LteLocalId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LteLocalId.Builder#build()} is called immediately and its result
         * is passed to {@link #lteLocalId(LteLocalId)}.
         * 
         * @param lteLocalId
         *        a consumer that will call methods on {@link LteLocalId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lteLocalId(LteLocalId)
         */
        default Builder lteLocalId(Consumer<LteLocalId.Builder> lteLocalId) {
            return lteLocalId(LteLocalId.builder().applyMutation(lteLocalId).build());
        }

        /**
         * <p>
         * LTE timing advance.
         * </p>
         * 
         * @param lteTimingAdvance
         *        LTE timing advance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lteTimingAdvance(Integer lteTimingAdvance);

        /**
         * <p>
         * Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
         * </p>
         * 
         * @param rsrp
         *        Signal power of the reference signal received, measured in dBm (decibel-milliwatts).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsrp(Integer rsrp);

        /**
         * <p>
         * Signal quality of the reference Signal received, measured in decibels (dB).
         * </p>
         * 
         * @param rsrq
         *        Signal quality of the reference Signal received, measured in decibels (dB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsrq(Float rsrq);

        /**
         * <p>
         * Parameter that determines whether the LTE object is capable of supporting NR (new radio).
         * </p>
         * 
         * @param nrCapable
         *        Parameter that determines whether the LTE object is capable of supporting NR (new radio).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nrCapable(Boolean nrCapable);

        /**
         * <p>
         * LTE object for network measurement reports.
         * </p>
         * 
         * @param lteNmr
         *        LTE object for network measurement reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lteNmr(Collection<LteNmrObj> lteNmr);

        /**
         * <p>
         * LTE object for network measurement reports.
         * </p>
         * 
         * @param lteNmr
         *        LTE object for network measurement reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lteNmr(LteNmrObj... lteNmr);

        /**
         * <p>
         * LTE object for network measurement reports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.LteNmrObj.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.LteNmrObj#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.LteNmrObj.Builder#build()} is called immediately and
         * its result is passed to {@link #lteNmr(List<LteNmrObj>)}.
         * 
         * @param lteNmr
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.LteNmrObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lteNmr(java.util.Collection<LteNmrObj>)
         */
        Builder lteNmr(Consumer<LteNmrObj.Builder>... lteNmr);
    }

    static final class BuilderImpl implements Builder {
        private Integer mcc;

        private Integer mnc;

        private Integer eutranCid;

        private Integer tac;

        private LteLocalId lteLocalId;

        private Integer lteTimingAdvance;

        private Integer rsrp;

        private Float rsrq;

        private Boolean nrCapable;

        private List<LteNmrObj> lteNmr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LteObj model) {
            mcc(model.mcc);
            mnc(model.mnc);
            eutranCid(model.eutranCid);
            tac(model.tac);
            lteLocalId(model.lteLocalId);
            lteTimingAdvance(model.lteTimingAdvance);
            rsrp(model.rsrp);
            rsrq(model.rsrq);
            nrCapable(model.nrCapable);
            lteNmr(model.lteNmr);
        }

        public final Integer getMcc() {
            return mcc;
        }

        public final void setMcc(Integer mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(Integer mcc) {
            this.mcc = mcc;
            return this;
        }

        public final Integer getMnc() {
            return mnc;
        }

        public final void setMnc(Integer mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(Integer mnc) {
            this.mnc = mnc;
            return this;
        }

        public final Integer getEutranCid() {
            return eutranCid;
        }

        public final void setEutranCid(Integer eutranCid) {
            this.eutranCid = eutranCid;
        }

        @Override
        public final Builder eutranCid(Integer eutranCid) {
            this.eutranCid = eutranCid;
            return this;
        }

        public final Integer getTac() {
            return tac;
        }

        public final void setTac(Integer tac) {
            this.tac = tac;
        }

        @Override
        public final Builder tac(Integer tac) {
            this.tac = tac;
            return this;
        }

        public final LteLocalId.Builder getLteLocalId() {
            return lteLocalId != null ? lteLocalId.toBuilder() : null;
        }

        public final void setLteLocalId(LteLocalId.BuilderImpl lteLocalId) {
            this.lteLocalId = lteLocalId != null ? lteLocalId.build() : null;
        }

        @Override
        public final Builder lteLocalId(LteLocalId lteLocalId) {
            this.lteLocalId = lteLocalId;
            return this;
        }

        public final Integer getLteTimingAdvance() {
            return lteTimingAdvance;
        }

        public final void setLteTimingAdvance(Integer lteTimingAdvance) {
            this.lteTimingAdvance = lteTimingAdvance;
        }

        @Override
        public final Builder lteTimingAdvance(Integer lteTimingAdvance) {
            this.lteTimingAdvance = lteTimingAdvance;
            return this;
        }

        public final Integer getRsrp() {
            return rsrp;
        }

        public final void setRsrp(Integer rsrp) {
            this.rsrp = rsrp;
        }

        @Override
        public final Builder rsrp(Integer rsrp) {
            this.rsrp = rsrp;
            return this;
        }

        public final Float getRsrq() {
            return rsrq;
        }

        public final void setRsrq(Float rsrq) {
            this.rsrq = rsrq;
        }

        @Override
        public final Builder rsrq(Float rsrq) {
            this.rsrq = rsrq;
            return this;
        }

        public final Boolean getNrCapable() {
            return nrCapable;
        }

        public final void setNrCapable(Boolean nrCapable) {
            this.nrCapable = nrCapable;
        }

        @Override
        public final Builder nrCapable(Boolean nrCapable) {
            this.nrCapable = nrCapable;
            return this;
        }

        public final List<LteNmrObj.Builder> getLteNmr() {
            List<LteNmrObj.Builder> result = LteNmrListCopier.copyToBuilder(this.lteNmr);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLteNmr(Collection<LteNmrObj.BuilderImpl> lteNmr) {
            this.lteNmr = LteNmrListCopier.copyFromBuilder(lteNmr);
        }

        @Override
        public final Builder lteNmr(Collection<LteNmrObj> lteNmr) {
            this.lteNmr = LteNmrListCopier.copy(lteNmr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lteNmr(LteNmrObj... lteNmr) {
            lteNmr(Arrays.asList(lteNmr));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lteNmr(Consumer<LteNmrObj.Builder>... lteNmr) {
            lteNmr(Stream.of(lteNmr).map(c -> LteNmrObj.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LteObj build() {
            return new LteObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
