/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregated values of the metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricQueryValue implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricQueryValue.Builder, MetricQueryValue> {
    private static final SdkField<Double> MIN_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Min")
            .getter(getter(MetricQueryValue::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Min").build()).build();

    private static final SdkField<Double> MAX_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Max")
            .getter(getter(MetricQueryValue::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final SdkField<Double> SUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Sum")
            .getter(getter(MetricQueryValue::sum)).setter(setter(Builder::sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sum").build()).build();

    private static final SdkField<Double> AVG_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Avg")
            .getter(getter(MetricQueryValue::avg)).setter(setter(Builder::avg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Avg").build()).build();

    private static final SdkField<Double> STD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Std")
            .getter(getter(MetricQueryValue::std)).setter(setter(Builder::std))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Std").build()).build();

    private static final SdkField<Double> P90_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("P90")
            .getter(getter(MetricQueryValue::p90)).setter(setter(Builder::p90))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("P90").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_FIELD, MAX_FIELD,
            SUM_FIELD, AVG_FIELD, STD_FIELD, P90_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double min;

    private final Double max;

    private final Double sum;

    private final Double avg;

    private final Double std;

    private final Double p90;

    private MetricQueryValue(BuilderImpl builder) {
        this.min = builder.min;
        this.max = builder.max;
        this.sum = builder.sum;
        this.avg = builder.avg;
        this.std = builder.std;
        this.p90 = builder.p90;
    }

    /**
     * <p>
     * The minimum of the values of all data points collected during the aggregation period.
     * </p>
     * 
     * @return The minimum of the values of all data points collected during the aggregation period.
     */
    public final Double min() {
        return min;
    }

    /**
     * <p>
     * The maximum of the values of all the data points collected during the aggregation period.
     * </p>
     * 
     * @return The maximum of the values of all the data points collected during the aggregation period.
     */
    public final Double max() {
        return max;
    }

    /**
     * <p>
     * The sum of the values of all data points collected during the aggregation period.
     * </p>
     * 
     * @return The sum of the values of all data points collected during the aggregation period.
     */
    public final Double sum() {
        return sum;
    }

    /**
     * <p>
     * The average of the values of all data points collected during the aggregation period.
     * </p>
     * 
     * @return The average of the values of all data points collected during the aggregation period.
     */
    public final Double avg() {
        return avg;
    }

    /**
     * <p>
     * The standard deviation of the values of all data points collected during the aggregation period.
     * </p>
     * 
     * @return The standard deviation of the values of all data points collected during the aggregation period.
     */
    public final Double std() {
        return std;
    }

    /**
     * <p>
     * The 90th percentile of the values of all data points collected during the aggregation period.
     * </p>
     * 
     * @return The 90th percentile of the values of all data points collected during the aggregation period.
     */
    public final Double p90() {
        return p90;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(sum());
        hashCode = 31 * hashCode + Objects.hashCode(avg());
        hashCode = 31 * hashCode + Objects.hashCode(std());
        hashCode = 31 * hashCode + Objects.hashCode(p90());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricQueryValue)) {
            return false;
        }
        MetricQueryValue other = (MetricQueryValue) obj;
        return Objects.equals(min(), other.min()) && Objects.equals(max(), other.max()) && Objects.equals(sum(), other.sum())
                && Objects.equals(avg(), other.avg()) && Objects.equals(std(), other.std()) && Objects.equals(p90(), other.p90());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricQueryValue").add("Min", min()).add("Max", max()).add("Sum", sum()).add("Avg", avg())
                .add("Std", std()).add("P90", p90()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Min":
            return Optional.ofNullable(clazz.cast(min()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        case "Sum":
            return Optional.ofNullable(clazz.cast(sum()));
        case "Avg":
            return Optional.ofNullable(clazz.cast(avg()));
        case "Std":
            return Optional.ofNullable(clazz.cast(std()));
        case "P90":
            return Optional.ofNullable(clazz.cast(p90()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Min", MIN_FIELD);
        map.put("Max", MAX_FIELD);
        map.put("Sum", SUM_FIELD);
        map.put("Avg", AVG_FIELD);
        map.put("Std", STD_FIELD);
        map.put("P90", P90_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricQueryValue, T> g) {
        return obj -> g.apply((MetricQueryValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricQueryValue> {
        /**
         * <p>
         * The minimum of the values of all data points collected during the aggregation period.
         * </p>
         * 
         * @param min
         *        The minimum of the values of all data points collected during the aggregation period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Double min);

        /**
         * <p>
         * The maximum of the values of all the data points collected during the aggregation period.
         * </p>
         * 
         * @param max
         *        The maximum of the values of all the data points collected during the aggregation period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Double max);

        /**
         * <p>
         * The sum of the values of all data points collected during the aggregation period.
         * </p>
         * 
         * @param sum
         *        The sum of the values of all data points collected during the aggregation period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The average of the values of all data points collected during the aggregation period.
         * </p>
         * 
         * @param avg
         *        The average of the values of all data points collected during the aggregation period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avg(Double avg);

        /**
         * <p>
         * The standard deviation of the values of all data points collected during the aggregation period.
         * </p>
         * 
         * @param std
         *        The standard deviation of the values of all data points collected during the aggregation period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder std(Double std);

        /**
         * <p>
         * The 90th percentile of the values of all data points collected during the aggregation period.
         * </p>
         * 
         * @param p90
         *        The 90th percentile of the values of all data points collected during the aggregation period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder p90(Double p90);
    }

    static final class BuilderImpl implements Builder {
        private Double min;

        private Double max;

        private Double sum;

        private Double avg;

        private Double std;

        private Double p90;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricQueryValue model) {
            min(model.min);
            max(model.max);
            sum(model.sum);
            avg(model.avg);
            std(model.std);
            p90(model.p90);
        }

        public final Double getMin() {
            return min;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        public final Double getMax() {
            return max;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        public final Double getSum() {
            return sum;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final Double getAvg() {
            return avg;
        }

        public final void setAvg(Double avg) {
            this.avg = avg;
        }

        @Override
        public final Builder avg(Double avg) {
            this.avg = avg;
            return this;
        }

        public final Double getStd() {
            return std;
        }

        public final void setStd(Double std) {
            this.std = std;
        }

        @Override
        public final Builder std(Double std) {
            this.std = std;
            return this;
        }

        public final Double getP90() {
            return p90;
        }

        public final void setP90(Double p90) {
            this.p90 = p90;
        }

        @Override
        public final Builder p90(Double p90) {
            this.p90 = p90;
            return this;
        }

        @Override
        public MetricQueryValue build() {
            return new MetricQueryValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
