/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * OTAA device object for v1.0.x
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OtaaV1_0_x implements SdkPojo, Serializable, ToCopyableBuilder<OtaaV1_0_x.Builder, OtaaV1_0_x> {
    private static final SdkField<String> APP_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppKey")
            .getter(getter(OtaaV1_0_x::appKey)).setter(setter(Builder::appKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppKey").build()).build();

    private static final SdkField<String> APP_EUI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppEui")
            .getter(getter(OtaaV1_0_x::appEui)).setter(setter(Builder::appEui))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppEui").build()).build();

    private static final SdkField<String> JOIN_EUI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JoinEui").getter(getter(OtaaV1_0_x::joinEui)).setter(setter(Builder::joinEui))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinEui").build()).build();

    private static final SdkField<String> GEN_APP_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenAppKey").getter(getter(OtaaV1_0_x::genAppKey)).setter(setter(Builder::genAppKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenAppKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_KEY_FIELD, APP_EUI_FIELD,
            JOIN_EUI_FIELD, GEN_APP_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appKey;

    private final String appEui;

    private final String joinEui;

    private final String genAppKey;

    private OtaaV1_0_x(BuilderImpl builder) {
        this.appKey = builder.appKey;
        this.appEui = builder.appEui;
        this.joinEui = builder.joinEui;
        this.genAppKey = builder.genAppKey;
    }

    /**
     * <p>
     * The AppKey value.
     * </p>
     * 
     * @return The AppKey value.
     */
    public final String appKey() {
        return appKey;
    }

    /**
     * <p>
     * The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
     * </p>
     * 
     * @return The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
     */
    public final String appEui() {
        return appEui;
    }

    /**
     * <p>
     * The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
     * </p>
     * 
     * @return The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
     */
    public final String joinEui() {
        return joinEui;
    }

    /**
     * <p>
     * The GenAppKey value.
     * </p>
     * 
     * @return The GenAppKey value.
     */
    public final String genAppKey() {
        return genAppKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appKey());
        hashCode = 31 * hashCode + Objects.hashCode(appEui());
        hashCode = 31 * hashCode + Objects.hashCode(joinEui());
        hashCode = 31 * hashCode + Objects.hashCode(genAppKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaaV1_0_x)) {
            return false;
        }
        OtaaV1_0_x other = (OtaaV1_0_x) obj;
        return Objects.equals(appKey(), other.appKey()) && Objects.equals(appEui(), other.appEui())
                && Objects.equals(joinEui(), other.joinEui()) && Objects.equals(genAppKey(), other.genAppKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OtaaV1_0_x").add("AppKey", appKey()).add("AppEui", appEui()).add("JoinEui", joinEui())
                .add("GenAppKey", genAppKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppKey":
            return Optional.ofNullable(clazz.cast(appKey()));
        case "AppEui":
            return Optional.ofNullable(clazz.cast(appEui()));
        case "JoinEui":
            return Optional.ofNullable(clazz.cast(joinEui()));
        case "GenAppKey":
            return Optional.ofNullable(clazz.cast(genAppKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppKey", APP_KEY_FIELD);
        map.put("AppEui", APP_EUI_FIELD);
        map.put("JoinEui", JOIN_EUI_FIELD);
        map.put("GenAppKey", GEN_APP_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaaV1_0_x, T> g) {
        return obj -> g.apply((OtaaV1_0_x) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OtaaV1_0_x> {
        /**
         * <p>
         * The AppKey value.
         * </p>
         * 
         * @param appKey
         *        The AppKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appKey(String appKey);

        /**
         * <p>
         * The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
         * </p>
         * 
         * @param appEui
         *        The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appEui(String appEui);

        /**
         * <p>
         * The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
         * </p>
         * 
         * @param joinEui
         *        The JoinEUI value. You specify this value instead of the AppEUI when using LoRaWAN version v1.0.4.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinEui(String joinEui);

        /**
         * <p>
         * The GenAppKey value.
         * </p>
         * 
         * @param genAppKey
         *        The GenAppKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder genAppKey(String genAppKey);
    }

    static final class BuilderImpl implements Builder {
        private String appKey;

        private String appEui;

        private String joinEui;

        private String genAppKey;

        private BuilderImpl() {
        }

        private BuilderImpl(OtaaV1_0_x model) {
            appKey(model.appKey);
            appEui(model.appEui);
            joinEui(model.joinEui);
            genAppKey(model.genAppKey);
        }

        public final String getAppKey() {
            return appKey;
        }

        public final void setAppKey(String appKey) {
            this.appKey = appKey;
        }

        @Override
        public final Builder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public final String getAppEui() {
            return appEui;
        }

        public final void setAppEui(String appEui) {
            this.appEui = appEui;
        }

        @Override
        public final Builder appEui(String appEui) {
            this.appEui = appEui;
            return this;
        }

        public final String getJoinEui() {
            return joinEui;
        }

        public final void setJoinEui(String joinEui) {
            this.joinEui = joinEui;
        }

        @Override
        public final Builder joinEui(String joinEui) {
            this.joinEui = joinEui;
            return this;
        }

        public final String getGenAppKey() {
            return genAppKey;
        }

        public final void setGenAppKey(String genAppKey) {
            this.genAppKey = genAppKey;
        }

        @Override
        public final Builder genAppKey(String genAppKey) {
            this.genAppKey = genAppKey;
            return this;
        }

        @Override
        public OtaaV1_0_x build() {
            return new OtaaV1_0_x(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
