/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specify the list of gateways to which you want to send the multicast downlink messages. The multicast message will be
 * sent to each gateway in the sequence provided in the list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipatingGatewaysMulticast implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipatingGatewaysMulticast.Builder, ParticipatingGatewaysMulticast> {
    private static final SdkField<List<String>> GATEWAY_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GatewayList")
            .getter(getter(ParticipatingGatewaysMulticast::gatewayList))
            .setter(setter(Builder::gatewayList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TRANSMISSION_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TransmissionInterval").getter(getter(ParticipatingGatewaysMulticast::transmissionInterval))
            .setter(setter(Builder::transmissionInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransmissionInterval").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_LIST_FIELD,
            TRANSMISSION_INTERVAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> gatewayList;

    private final Integer transmissionInterval;

    private ParticipatingGatewaysMulticast(BuilderImpl builder) {
        this.gatewayList = builder.gatewayList;
        this.transmissionInterval = builder.transmissionInterval;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatewayList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGatewayList() {
        return gatewayList != null && !(gatewayList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of gateways that you want to use for sending the multicast downlink. Each downlink will be sent to all
     * the gateways in the list with transmission interval between them. If list is empty the gateway list will be
     * dynamically selected similar to the case of no ParticipatingGateways
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatewayList} method.
     * </p>
     * 
     * @return The list of gateways that you want to use for sending the multicast downlink. Each downlink will be sent
     *         to all the gateways in the list with transmission interval between them. If list is empty the gateway
     *         list will be dynamically selected similar to the case of no ParticipatingGateways
     */
    public final List<String> gatewayList() {
        return gatewayList;
    }

    /**
     * <p>
     * The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the multicast payload to
     * the next gateway in the list.
     * </p>
     * 
     * @return The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the multicast
     *         payload to the next gateway in the list.
     */
    public final Integer transmissionInterval() {
        return transmissionInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayList() ? gatewayList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transmissionInterval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingGatewaysMulticast)) {
            return false;
        }
        ParticipatingGatewaysMulticast other = (ParticipatingGatewaysMulticast) obj;
        return hasGatewayList() == other.hasGatewayList() && Objects.equals(gatewayList(), other.gatewayList())
                && Objects.equals(transmissionInterval(), other.transmissionInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipatingGatewaysMulticast").add("GatewayList", hasGatewayList() ? gatewayList() : null)
                .add("TransmissionInterval", transmissionInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayList":
            return Optional.ofNullable(clazz.cast(gatewayList()));
        case "TransmissionInterval":
            return Optional.ofNullable(clazz.cast(transmissionInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayList", GATEWAY_LIST_FIELD);
        map.put("TransmissionInterval", TRANSMISSION_INTERVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingGatewaysMulticast, T> g) {
        return obj -> g.apply((ParticipatingGatewaysMulticast) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipatingGatewaysMulticast> {
        /**
         * <p>
         * The list of gateways that you want to use for sending the multicast downlink. Each downlink will be sent to
         * all the gateways in the list with transmission interval between them. If list is empty the gateway list will
         * be dynamically selected similar to the case of no ParticipatingGateways
         * </p>
         * 
         * @param gatewayList
         *        The list of gateways that you want to use for sending the multicast downlink. Each downlink will be
         *        sent to all the gateways in the list with transmission interval between them. If list is empty the
         *        gateway list will be dynamically selected similar to the case of no ParticipatingGateways
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayList(Collection<String> gatewayList);

        /**
         * <p>
         * The list of gateways that you want to use for sending the multicast downlink. Each downlink will be sent to
         * all the gateways in the list with transmission interval between them. If list is empty the gateway list will
         * be dynamically selected similar to the case of no ParticipatingGateways
         * </p>
         * 
         * @param gatewayList
         *        The list of gateways that you want to use for sending the multicast downlink. Each downlink will be
         *        sent to all the gateways in the list with transmission interval between them. If list is empty the
         *        gateway list will be dynamically selected similar to the case of no ParticipatingGateways
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayList(String... gatewayList);

        /**
         * <p>
         * The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the multicast payload
         * to the next gateway in the list.
         * </p>
         * 
         * @param transmissionInterval
         *        The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the multicast
         *        payload to the next gateway in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transmissionInterval(Integer transmissionInterval);
    }

    static final class BuilderImpl implements Builder {
        private List<String> gatewayList = DefaultSdkAutoConstructList.getInstance();

        private Integer transmissionInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingGatewaysMulticast model) {
            gatewayList(model.gatewayList);
            transmissionInterval(model.transmissionInterval);
        }

        public final Collection<String> getGatewayList() {
            if (gatewayList instanceof SdkAutoConstructList) {
                return null;
            }
            return gatewayList;
        }

        public final void setGatewayList(Collection<String> gatewayList) {
            this.gatewayList = GatewayListMulticastCopier.copy(gatewayList);
        }

        @Override
        public final Builder gatewayList(Collection<String> gatewayList) {
            this.gatewayList = GatewayListMulticastCopier.copy(gatewayList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayList(String... gatewayList) {
            gatewayList(Arrays.asList(gatewayList));
            return this;
        }

        public final Integer getTransmissionInterval() {
            return transmissionInterval;
        }

        public final void setTransmissionInterval(Integer transmissionInterval) {
            this.transmissionInterval = transmissionInterval;
        }

        @Override
        public final Builder transmissionInterval(Integer transmissionInterval) {
            this.transmissionInterval = transmissionInterval;
            return this;
        }

        @Override
        public ParticipatingGatewaysMulticast build() {
            return new ParticipatingGatewaysMulticast(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
