/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the Semtech GNSS solver object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SemtechGnssDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SemtechGnssDetail.Builder, SemtechGnssDetail> {
    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Provider").getter(getter(SemtechGnssDetail::providerAsString)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SemtechGnssDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SemtechGnssDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Fec")
            .getter(getter(SemtechGnssDetail::fecAsString)).setter(setter(Builder::fec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_FIELD, TYPE_FIELD,
            STATUS_FIELD, FEC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String provider;

    private final String type;

    private final String status;

    private final String fec;

    private SemtechGnssDetail(BuilderImpl builder) {
        this.provider = builder.provider;
        this.type = builder.type;
        this.status = builder.status;
        this.fec = builder.fec;
    }

    /**
     * <p>
     * The vendor of the solver object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link PositionSolverProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerAsString}.
     * </p>
     * 
     * @return The vendor of the solver object.
     * @see PositionSolverProvider
     */
    public final PositionSolverProvider provider() {
        return PositionSolverProvider.fromValue(provider);
    }

    /**
     * <p>
     * The vendor of the solver object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link PositionSolverProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerAsString}.
     * </p>
     * 
     * @return The vendor of the solver object.
     * @see PositionSolverProvider
     */
    public final String providerAsString() {
        return provider;
    }

    /**
     * <p>
     * The type of positioning solver used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PositionSolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of positioning solver used.
     * @see PositionSolverType
     */
    public final PositionSolverType type() {
        return PositionSolverType.fromValue(type);
    }

    /**
     * <p>
     * The type of positioning solver used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PositionSolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of positioning solver used.
     * @see PositionSolverType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status indicating whether the solver is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PositionConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status indicating whether the solver is enabled.
     * @see PositionConfigurationStatus
     */
    public final PositionConfigurationStatus status() {
        return PositionConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status indicating whether the solver is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PositionConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status indicating whether the solver is enabled.
     * @see PositionConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Whether forward error correction is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fec} will return
     * {@link PositionConfigurationFec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fecAsString}.
     * </p>
     * 
     * @return Whether forward error correction is enabled.
     * @see PositionConfigurationFec
     */
    public final PositionConfigurationFec fec() {
        return PositionConfigurationFec.fromValue(fec);
    }

    /**
     * <p>
     * Whether forward error correction is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fec} will return
     * {@link PositionConfigurationFec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fecAsString}.
     * </p>
     * 
     * @return Whether forward error correction is enabled.
     * @see PositionConfigurationFec
     */
    public final String fecAsString() {
        return fec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fecAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemtechGnssDetail)) {
            return false;
        }
        SemtechGnssDetail other = (SemtechGnssDetail) obj;
        return Objects.equals(providerAsString(), other.providerAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(fecAsString(), other.fecAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SemtechGnssDetail").add("Provider", providerAsString()).add("Type", typeAsString())
                .add("Status", statusAsString()).add("Fec", fecAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Fec":
            return Optional.ofNullable(clazz.cast(fecAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Provider", PROVIDER_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Fec", FEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SemtechGnssDetail, T> g) {
        return obj -> g.apply((SemtechGnssDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SemtechGnssDetail> {
        /**
         * <p>
         * The vendor of the solver object.
         * </p>
         * 
         * @param provider
         *        The vendor of the solver object.
         * @see PositionSolverProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionSolverProvider
         */
        Builder provider(String provider);

        /**
         * <p>
         * The vendor of the solver object.
         * </p>
         * 
         * @param provider
         *        The vendor of the solver object.
         * @see PositionSolverProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionSolverProvider
         */
        Builder provider(PositionSolverProvider provider);

        /**
         * <p>
         * The type of positioning solver used.
         * </p>
         * 
         * @param type
         *        The type of positioning solver used.
         * @see PositionSolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionSolverType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of positioning solver used.
         * </p>
         * 
         * @param type
         *        The type of positioning solver used.
         * @see PositionSolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionSolverType
         */
        Builder type(PositionSolverType type);

        /**
         * <p>
         * The status indicating whether the solver is enabled.
         * </p>
         * 
         * @param status
         *        The status indicating whether the solver is enabled.
         * @see PositionConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status indicating whether the solver is enabled.
         * </p>
         * 
         * @param status
         *        The status indicating whether the solver is enabled.
         * @see PositionConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionConfigurationStatus
         */
        Builder status(PositionConfigurationStatus status);

        /**
         * <p>
         * Whether forward error correction is enabled.
         * </p>
         * 
         * @param fec
         *        Whether forward error correction is enabled.
         * @see PositionConfigurationFec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionConfigurationFec
         */
        Builder fec(String fec);

        /**
         * <p>
         * Whether forward error correction is enabled.
         * </p>
         * 
         * @param fec
         *        Whether forward error correction is enabled.
         * @see PositionConfigurationFec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionConfigurationFec
         */
        Builder fec(PositionConfigurationFec fec);
    }

    static final class BuilderImpl implements Builder {
        private String provider;

        private String type;

        private String status;

        private String fec;

        private BuilderImpl() {
        }

        private BuilderImpl(SemtechGnssDetail model) {
            provider(model.provider);
            type(model.type);
            status(model.status);
            fec(model.fec);
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(PositionSolverProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PositionSolverType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PositionConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFec() {
            return fec;
        }

        public final void setFec(String fec) {
            this.fec = fec;
        }

        @Override
        public final Builder fec(String fec) {
            this.fec = fec;
            return this;
        }

        @Override
        public final Builder fec(PositionConfigurationFec fec) {
            this.fec(fec == null ? null : fec.toString());
            return this;
        }

        @Override
        public SemtechGnssDetail build() {
            return new SemtechGnssDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
