/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Session keys for ABP v1.1
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionKeysAbpV1_0_x implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionKeysAbpV1_0_x.Builder, SessionKeysAbpV1_0_x> {
    private static final SdkField<String> NWK_S_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NwkSKey").getter(getter(SessionKeysAbpV1_0_x::nwkSKey)).setter(setter(Builder::nwkSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NwkSKey").build()).build();

    private static final SdkField<String> APP_S_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppSKey").getter(getter(SessionKeysAbpV1_0_x::appSKey)).setter(setter(Builder::appSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NWK_S_KEY_FIELD,
            APP_S_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nwkSKey;

    private final String appSKey;

    private SessionKeysAbpV1_0_x(BuilderImpl builder) {
        this.nwkSKey = builder.nwkSKey;
        this.appSKey = builder.appSKey;
    }

    /**
     * <p>
     * The NwkSKey value.
     * </p>
     * 
     * @return The NwkSKey value.
     */
    public final String nwkSKey() {
        return nwkSKey;
    }

    /**
     * <p>
     * The AppSKey value.
     * </p>
     * 
     * @return The AppSKey value.
     */
    public final String appSKey() {
        return appSKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nwkSKey());
        hashCode = 31 * hashCode + Objects.hashCode(appSKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionKeysAbpV1_0_x)) {
            return false;
        }
        SessionKeysAbpV1_0_x other = (SessionKeysAbpV1_0_x) obj;
        return Objects.equals(nwkSKey(), other.nwkSKey()) && Objects.equals(appSKey(), other.appSKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionKeysAbpV1_0_x").add("NwkSKey", nwkSKey()).add("AppSKey", appSKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NwkSKey":
            return Optional.ofNullable(clazz.cast(nwkSKey()));
        case "AppSKey":
            return Optional.ofNullable(clazz.cast(appSKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NwkSKey", NWK_S_KEY_FIELD);
        map.put("AppSKey", APP_S_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionKeysAbpV1_0_x, T> g) {
        return obj -> g.apply((SessionKeysAbpV1_0_x) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionKeysAbpV1_0_x> {
        /**
         * <p>
         * The NwkSKey value.
         * </p>
         * 
         * @param nwkSKey
         *        The NwkSKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nwkSKey(String nwkSKey);

        /**
         * <p>
         * The AppSKey value.
         * </p>
         * 
         * @param appSKey
         *        The AppSKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appSKey(String appSKey);
    }

    static final class BuilderImpl implements Builder {
        private String nwkSKey;

        private String appSKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionKeysAbpV1_0_x model) {
            nwkSKey(model.nwkSKey);
            appSKey(model.appSKey);
        }

        public final String getNwkSKey() {
            return nwkSKey;
        }

        public final void setNwkSKey(String nwkSKey) {
            this.nwkSKey = nwkSKey;
        }

        @Override
        public final Builder nwkSKey(String nwkSKey) {
            this.nwkSKey = nwkSKey;
            return this;
        }

        public final String getAppSKey() {
            return appSKey;
        }

        public final void setAppSKey(String appSKey) {
            this.appSKey = appSKey;
        }

        @Override
        public final Builder appSKey(String appSKey) {
            this.appSKey = appSKey;
            return this;
        }

        @Override
        public SessionKeysAbpV1_0_x build() {
            return new SessionKeysAbpV1_0_x(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
