/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <code>SidewalkEventNotificationConfigurations</code> object, which is the event configuration object for
 * Sidewalk-related event topics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkEventNotificationConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkEventNotificationConfigurations.Builder, SidewalkEventNotificationConfigurations> {
    private static final SdkField<String> AMAZON_ID_EVENT_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmazonIdEventTopic").getter(getter(SidewalkEventNotificationConfigurations::amazonIdEventTopicAsString))
            .setter(setter(Builder::amazonIdEventTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonIdEventTopic").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_ID_EVENT_TOPIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String amazonIdEventTopic;

    private SidewalkEventNotificationConfigurations(BuilderImpl builder) {
        this.amazonIdEventTopic = builder.amazonIdEventTopic;
    }

    /**
     * <p>
     * Denotes whether the Amazon ID event topic is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #amazonIdEventTopic} will return {@link EventNotificationTopicStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #amazonIdEventTopicAsString}.
     * </p>
     * 
     * @return Denotes whether the Amazon ID event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */
    public final EventNotificationTopicStatus amazonIdEventTopic() {
        return EventNotificationTopicStatus.fromValue(amazonIdEventTopic);
    }

    /**
     * <p>
     * Denotes whether the Amazon ID event topic is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #amazonIdEventTopic} will return {@link EventNotificationTopicStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #amazonIdEventTopicAsString}.
     * </p>
     * 
     * @return Denotes whether the Amazon ID event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */
    public final String amazonIdEventTopicAsString() {
        return amazonIdEventTopic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonIdEventTopicAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkEventNotificationConfigurations)) {
            return false;
        }
        SidewalkEventNotificationConfigurations other = (SidewalkEventNotificationConfigurations) obj;
        return Objects.equals(amazonIdEventTopicAsString(), other.amazonIdEventTopicAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkEventNotificationConfigurations")
                .add("AmazonIdEventTopic", amazonIdEventTopicAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonIdEventTopic":
            return Optional.ofNullable(clazz.cast(amazonIdEventTopicAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AmazonIdEventTopic", AMAZON_ID_EVENT_TOPIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SidewalkEventNotificationConfigurations, T> g) {
        return obj -> g.apply((SidewalkEventNotificationConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkEventNotificationConfigurations> {
        /**
         * <p>
         * Denotes whether the Amazon ID event topic is enabled or disabled.
         * </p>
         * 
         * @param amazonIdEventTopic
         *        Denotes whether the Amazon ID event topic is enabled or disabled.
         * @see EventNotificationTopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationTopicStatus
         */
        Builder amazonIdEventTopic(String amazonIdEventTopic);

        /**
         * <p>
         * Denotes whether the Amazon ID event topic is enabled or disabled.
         * </p>
         * 
         * @param amazonIdEventTopic
         *        Denotes whether the Amazon ID event topic is enabled or disabled.
         * @see EventNotificationTopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationTopicStatus
         */
        Builder amazonIdEventTopic(EventNotificationTopicStatus amazonIdEventTopic);
    }

    static final class BuilderImpl implements Builder {
        private String amazonIdEventTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkEventNotificationConfigurations model) {
            amazonIdEventTopic(model.amazonIdEventTopic);
        }

        public final String getAmazonIdEventTopic() {
            return amazonIdEventTopic;
        }

        public final void setAmazonIdEventTopic(String amazonIdEventTopic) {
            this.amazonIdEventTopic = amazonIdEventTopic;
        }

        @Override
        public final Builder amazonIdEventTopic(String amazonIdEventTopic) {
            this.amazonIdEventTopic = amazonIdEventTopic;
            return this;
        }

        @Override
        public final Builder amazonIdEventTopic(EventNotificationTopicStatus amazonIdEventTopic) {
            this.amazonIdEventTopic(amazonIdEventTopic == null ? null : amazonIdEventTopic.toString());
            return this;
        }

        @Override
        public SidewalkEventNotificationConfigurations build() {
            return new SidewalkEventNotificationConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
