/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sidewalk-related information for devices in an import task that are being onboarded.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkGetStartImportInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkGetStartImportInfo.Builder, SidewalkGetStartImportInfo> {
    private static final SdkField<List<String>> DEVICE_CREATION_FILE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeviceCreationFileList")
            .getter(getter(SidewalkGetStartImportInfo::deviceCreationFileList))
            .setter(setter(Builder::deviceCreationFileList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceCreationFileList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(SidewalkGetStartImportInfo::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEVICE_CREATION_FILE_LIST_FIELD, ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> deviceCreationFileList;

    private final String role;

    private SidewalkGetStartImportInfo(BuilderImpl builder) {
        this.deviceCreationFileList = builder.deviceCreationFileList;
        this.role = builder.role;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceCreationFileList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeviceCreationFileList() {
        return deviceCreationFileList != null && !(deviceCreationFileList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Sidewalk devices that are added to the import task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceCreationFileList} method.
     * </p>
     * 
     * @return List of Sidewalk devices that are added to the import task.
     */
    public final List<String> deviceCreationFileList() {
        return deviceCreationFileList;
    }

    /**
     * <p>
     * The IAM role that allows AWS IoT Wireless to access the CSV file in the S3 bucket.
     * </p>
     * 
     * @return The IAM role that allows AWS IoT Wireless to access the CSV file in the S3 bucket.
     */
    public final String role() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceCreationFileList() ? deviceCreationFileList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(role());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkGetStartImportInfo)) {
            return false;
        }
        SidewalkGetStartImportInfo other = (SidewalkGetStartImportInfo) obj;
        return hasDeviceCreationFileList() == other.hasDeviceCreationFileList()
                && Objects.equals(deviceCreationFileList(), other.deviceCreationFileList())
                && Objects.equals(role(), other.role());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkGetStartImportInfo")
                .add("DeviceCreationFileList", hasDeviceCreationFileList() ? deviceCreationFileList() : null).add("Role", role())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceCreationFileList":
            return Optional.ofNullable(clazz.cast(deviceCreationFileList()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceCreationFileList", DEVICE_CREATION_FILE_LIST_FIELD);
        map.put("Role", ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SidewalkGetStartImportInfo, T> g) {
        return obj -> g.apply((SidewalkGetStartImportInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkGetStartImportInfo> {
        /**
         * <p>
         * List of Sidewalk devices that are added to the import task.
         * </p>
         * 
         * @param deviceCreationFileList
         *        List of Sidewalk devices that are added to the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCreationFileList(Collection<String> deviceCreationFileList);

        /**
         * <p>
         * List of Sidewalk devices that are added to the import task.
         * </p>
         * 
         * @param deviceCreationFileList
         *        List of Sidewalk devices that are added to the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCreationFileList(String... deviceCreationFileList);

        /**
         * <p>
         * The IAM role that allows AWS IoT Wireless to access the CSV file in the S3 bucket.
         * </p>
         * 
         * @param role
         *        The IAM role that allows AWS IoT Wireless to access the CSV file in the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);
    }

    static final class BuilderImpl implements Builder {
        private List<String> deviceCreationFileList = DefaultSdkAutoConstructList.getInstance();

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkGetStartImportInfo model) {
            deviceCreationFileList(model.deviceCreationFileList);
            role(model.role);
        }

        public final Collection<String> getDeviceCreationFileList() {
            if (deviceCreationFileList instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceCreationFileList;
        }

        public final void setDeviceCreationFileList(Collection<String> deviceCreationFileList) {
            this.deviceCreationFileList = DeviceCreationFileListCopier.copy(deviceCreationFileList);
        }

        @Override
        public final Builder deviceCreationFileList(Collection<String> deviceCreationFileList) {
            this.deviceCreationFileList = DeviceCreationFileListCopier.copy(deviceCreationFileList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceCreationFileList(String... deviceCreationFileList) {
            deviceCreationFileList(Arrays.asList(deviceCreationFileList));
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public SidewalkGetStartImportInfo build() {
            return new SidewalkGetStartImportInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
