/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TD-SCDMA object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TdscdmaObj implements SdkPojo, Serializable, ToCopyableBuilder<TdscdmaObj.Builder, TdscdmaObj> {
    private static final SdkField<Integer> MCC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Mcc")
            .getter(getter(TdscdmaObj::mcc)).setter(setter(Builder::mcc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mcc").build()).build();

    private static final SdkField<Integer> MNC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Mnc")
            .getter(getter(TdscdmaObj::mnc)).setter(setter(Builder::mnc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mnc").build()).build();

    private static final SdkField<Integer> LAC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Lac")
            .getter(getter(TdscdmaObj::lac)).setter(setter(Builder::lac))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lac").build()).build();

    private static final SdkField<Integer> UTRAN_CID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UtranCid").getter(getter(TdscdmaObj::utranCid)).setter(setter(Builder::utranCid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtranCid").build()).build();

    private static final SdkField<TdscdmaLocalId> TDSCDMA_LOCAL_ID_FIELD = SdkField
            .<TdscdmaLocalId> builder(MarshallingType.SDK_POJO).memberName("TdscdmaLocalId")
            .getter(getter(TdscdmaObj::tdscdmaLocalId)).setter(setter(Builder::tdscdmaLocalId))
            .constructor(TdscdmaLocalId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdscdmaLocalId").build()).build();

    private static final SdkField<Integer> TDSCDMA_TIMING_ADVANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TdscdmaTimingAdvance").getter(getter(TdscdmaObj::tdscdmaTimingAdvance))
            .setter(setter(Builder::tdscdmaTimingAdvance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdscdmaTimingAdvance").build())
            .build();

    private static final SdkField<Integer> RSCP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rscp")
            .getter(getter(TdscdmaObj::rscp)).setter(setter(Builder::rscp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rscp").build()).build();

    private static final SdkField<Integer> PATH_LOSS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PathLoss").getter(getter(TdscdmaObj::pathLoss)).setter(setter(Builder::pathLoss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathLoss").build()).build();

    private static final SdkField<List<TdscdmaNmrObj>> TDSCDMA_NMR_FIELD = SdkField
            .<List<TdscdmaNmrObj>> builder(MarshallingType.LIST)
            .memberName("TdscdmaNmr")
            .getter(getter(TdscdmaObj::tdscdmaNmr))
            .setter(setter(Builder::tdscdmaNmr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdscdmaNmr").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TdscdmaNmrObj> builder(MarshallingType.SDK_POJO)
                                            .constructor(TdscdmaNmrObj::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MCC_FIELD, MNC_FIELD,
            LAC_FIELD, UTRAN_CID_FIELD, TDSCDMA_LOCAL_ID_FIELD, TDSCDMA_TIMING_ADVANCE_FIELD, RSCP_FIELD, PATH_LOSS_FIELD,
            TDSCDMA_NMR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer mcc;

    private final Integer mnc;

    private final Integer lac;

    private final Integer utranCid;

    private final TdscdmaLocalId tdscdmaLocalId;

    private final Integer tdscdmaTimingAdvance;

    private final Integer rscp;

    private final Integer pathLoss;

    private final List<TdscdmaNmrObj> tdscdmaNmr;

    private TdscdmaObj(BuilderImpl builder) {
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.lac = builder.lac;
        this.utranCid = builder.utranCid;
        this.tdscdmaLocalId = builder.tdscdmaLocalId;
        this.tdscdmaTimingAdvance = builder.tdscdmaTimingAdvance;
        this.rscp = builder.rscp;
        this.pathLoss = builder.pathLoss;
        this.tdscdmaNmr = builder.tdscdmaNmr;
    }

    /**
     * <p>
     * Mobile Country Code.
     * </p>
     * 
     * @return Mobile Country Code.
     */
    public final Integer mcc() {
        return mcc;
    }

    /**
     * <p>
     * Mobile Network Code.
     * </p>
     * 
     * @return Mobile Network Code.
     */
    public final Integer mnc() {
        return mnc;
    }

    /**
     * <p>
     * Location Area Code.
     * </p>
     * 
     * @return Location Area Code.
     */
    public final Integer lac() {
        return lac;
    }

    /**
     * <p>
     * UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
     * </p>
     * 
     * @return UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
     */
    public final Integer utranCid() {
        return utranCid;
    }

    /**
     * <p>
     * TD-SCDMA local identification (local ID) information.
     * </p>
     * 
     * @return TD-SCDMA local identification (local ID) information.
     */
    public final TdscdmaLocalId tdscdmaLocalId() {
        return tdscdmaLocalId;
    }

    /**
     * <p>
     * TD-SCDMA Timing advance.
     * </p>
     * 
     * @return TD-SCDMA Timing advance.
     */
    public final Integer tdscdmaTimingAdvance() {
        return tdscdmaTimingAdvance;
    }

    /**
     * <p>
     * Signal power of the received signal (Received Signal Code Power), measured in decibel-milliwatts (dBm).
     * </p>
     * 
     * @return Signal power of the received signal (Received Signal Code Power), measured in decibel-milliwatts (dBm).
     */
    public final Integer rscp() {
        return rscp;
    }

    /**
     * <p>
     * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates
     * through space.
     * </p>
     * 
     * @return Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it
     *         propagates through space.
     */
    public final Integer pathLoss() {
        return pathLoss;
    }

    /**
     * For responses, this returns true if the service returned a value for the TdscdmaNmr property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTdscdmaNmr() {
        return tdscdmaNmr != null && !(tdscdmaNmr instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * TD-SCDMA object for network measurement reports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTdscdmaNmr} method.
     * </p>
     * 
     * @return TD-SCDMA object for network measurement reports.
     */
    public final List<TdscdmaNmrObj> tdscdmaNmr() {
        return tdscdmaNmr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mcc());
        hashCode = 31 * hashCode + Objects.hashCode(mnc());
        hashCode = 31 * hashCode + Objects.hashCode(lac());
        hashCode = 31 * hashCode + Objects.hashCode(utranCid());
        hashCode = 31 * hashCode + Objects.hashCode(tdscdmaLocalId());
        hashCode = 31 * hashCode + Objects.hashCode(tdscdmaTimingAdvance());
        hashCode = 31 * hashCode + Objects.hashCode(rscp());
        hashCode = 31 * hashCode + Objects.hashCode(pathLoss());
        hashCode = 31 * hashCode + Objects.hashCode(hasTdscdmaNmr() ? tdscdmaNmr() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TdscdmaObj)) {
            return false;
        }
        TdscdmaObj other = (TdscdmaObj) obj;
        return Objects.equals(mcc(), other.mcc()) && Objects.equals(mnc(), other.mnc()) && Objects.equals(lac(), other.lac())
                && Objects.equals(utranCid(), other.utranCid()) && Objects.equals(tdscdmaLocalId(), other.tdscdmaLocalId())
                && Objects.equals(tdscdmaTimingAdvance(), other.tdscdmaTimingAdvance()) && Objects.equals(rscp(), other.rscp())
                && Objects.equals(pathLoss(), other.pathLoss()) && hasTdscdmaNmr() == other.hasTdscdmaNmr()
                && Objects.equals(tdscdmaNmr(), other.tdscdmaNmr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TdscdmaObj").add("Mcc", mcc()).add("Mnc", mnc()).add("Lac", lac()).add("UtranCid", utranCid())
                .add("TdscdmaLocalId", tdscdmaLocalId()).add("TdscdmaTimingAdvance", tdscdmaTimingAdvance()).add("Rscp", rscp())
                .add("PathLoss", pathLoss()).add("TdscdmaNmr", hasTdscdmaNmr() ? tdscdmaNmr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mcc":
            return Optional.ofNullable(clazz.cast(mcc()));
        case "Mnc":
            return Optional.ofNullable(clazz.cast(mnc()));
        case "Lac":
            return Optional.ofNullable(clazz.cast(lac()));
        case "UtranCid":
            return Optional.ofNullable(clazz.cast(utranCid()));
        case "TdscdmaLocalId":
            return Optional.ofNullable(clazz.cast(tdscdmaLocalId()));
        case "TdscdmaTimingAdvance":
            return Optional.ofNullable(clazz.cast(tdscdmaTimingAdvance()));
        case "Rscp":
            return Optional.ofNullable(clazz.cast(rscp()));
        case "PathLoss":
            return Optional.ofNullable(clazz.cast(pathLoss()));
        case "TdscdmaNmr":
            return Optional.ofNullable(clazz.cast(tdscdmaNmr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Mcc", MCC_FIELD);
        map.put("Mnc", MNC_FIELD);
        map.put("Lac", LAC_FIELD);
        map.put("UtranCid", UTRAN_CID_FIELD);
        map.put("TdscdmaLocalId", TDSCDMA_LOCAL_ID_FIELD);
        map.put("TdscdmaTimingAdvance", TDSCDMA_TIMING_ADVANCE_FIELD);
        map.put("Rscp", RSCP_FIELD);
        map.put("PathLoss", PATH_LOSS_FIELD);
        map.put("TdscdmaNmr", TDSCDMA_NMR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TdscdmaObj, T> g) {
        return obj -> g.apply((TdscdmaObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TdscdmaObj> {
        /**
         * <p>
         * Mobile Country Code.
         * </p>
         * 
         * @param mcc
         *        Mobile Country Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcc(Integer mcc);

        /**
         * <p>
         * Mobile Network Code.
         * </p>
         * 
         * @param mnc
         *        Mobile Network Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mnc(Integer mnc);

        /**
         * <p>
         * Location Area Code.
         * </p>
         * 
         * @param lac
         *        Location Area Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lac(Integer lac);

        /**
         * <p>
         * UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
         * </p>
         * 
         * @param utranCid
         *        UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utranCid(Integer utranCid);

        /**
         * <p>
         * TD-SCDMA local identification (local ID) information.
         * </p>
         * 
         * @param tdscdmaLocalId
         *        TD-SCDMA local identification (local ID) information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdscdmaLocalId(TdscdmaLocalId tdscdmaLocalId);

        /**
         * <p>
         * TD-SCDMA local identification (local ID) information.
         * </p>
         * This is a convenience method that creates an instance of the {@link TdscdmaLocalId.Builder} avoiding the need
         * to create one manually via {@link TdscdmaLocalId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TdscdmaLocalId.Builder#build()} is called immediately and its
         * result is passed to {@link #tdscdmaLocalId(TdscdmaLocalId)}.
         * 
         * @param tdscdmaLocalId
         *        a consumer that will call methods on {@link TdscdmaLocalId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tdscdmaLocalId(TdscdmaLocalId)
         */
        default Builder tdscdmaLocalId(Consumer<TdscdmaLocalId.Builder> tdscdmaLocalId) {
            return tdscdmaLocalId(TdscdmaLocalId.builder().applyMutation(tdscdmaLocalId).build());
        }

        /**
         * <p>
         * TD-SCDMA Timing advance.
         * </p>
         * 
         * @param tdscdmaTimingAdvance
         *        TD-SCDMA Timing advance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdscdmaTimingAdvance(Integer tdscdmaTimingAdvance);

        /**
         * <p>
         * Signal power of the received signal (Received Signal Code Power), measured in decibel-milliwatts (dBm).
         * </p>
         * 
         * @param rscp
         *        Signal power of the received signal (Received Signal Code Power), measured in decibel-milliwatts
         *        (dBm).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rscp(Integer rscp);

        /**
         * <p>
         * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates
         * through space.
         * </p>
         * 
         * @param pathLoss
         *        Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it
         *        propagates through space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathLoss(Integer pathLoss);

        /**
         * <p>
         * TD-SCDMA object for network measurement reports.
         * </p>
         * 
         * @param tdscdmaNmr
         *        TD-SCDMA object for network measurement reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdscdmaNmr(Collection<TdscdmaNmrObj> tdscdmaNmr);

        /**
         * <p>
         * TD-SCDMA object for network measurement reports.
         * </p>
         * 
         * @param tdscdmaNmr
         *        TD-SCDMA object for network measurement reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdscdmaNmr(TdscdmaNmrObj... tdscdmaNmr);

        /**
         * <p>
         * TD-SCDMA object for network measurement reports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.TdscdmaNmrObj.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotwireless.model.TdscdmaNmrObj#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.TdscdmaNmrObj.Builder#build()} is called immediately
         * and its result is passed to {@link #tdscdmaNmr(List<TdscdmaNmrObj>)}.
         * 
         * @param tdscdmaNmr
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.TdscdmaNmrObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tdscdmaNmr(java.util.Collection<TdscdmaNmrObj>)
         */
        Builder tdscdmaNmr(Consumer<TdscdmaNmrObj.Builder>... tdscdmaNmr);
    }

    static final class BuilderImpl implements Builder {
        private Integer mcc;

        private Integer mnc;

        private Integer lac;

        private Integer utranCid;

        private TdscdmaLocalId tdscdmaLocalId;

        private Integer tdscdmaTimingAdvance;

        private Integer rscp;

        private Integer pathLoss;

        private List<TdscdmaNmrObj> tdscdmaNmr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TdscdmaObj model) {
            mcc(model.mcc);
            mnc(model.mnc);
            lac(model.lac);
            utranCid(model.utranCid);
            tdscdmaLocalId(model.tdscdmaLocalId);
            tdscdmaTimingAdvance(model.tdscdmaTimingAdvance);
            rscp(model.rscp);
            pathLoss(model.pathLoss);
            tdscdmaNmr(model.tdscdmaNmr);
        }

        public final Integer getMcc() {
            return mcc;
        }

        public final void setMcc(Integer mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(Integer mcc) {
            this.mcc = mcc;
            return this;
        }

        public final Integer getMnc() {
            return mnc;
        }

        public final void setMnc(Integer mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(Integer mnc) {
            this.mnc = mnc;
            return this;
        }

        public final Integer getLac() {
            return lac;
        }

        public final void setLac(Integer lac) {
            this.lac = lac;
        }

        @Override
        public final Builder lac(Integer lac) {
            this.lac = lac;
            return this;
        }

        public final Integer getUtranCid() {
            return utranCid;
        }

        public final void setUtranCid(Integer utranCid) {
            this.utranCid = utranCid;
        }

        @Override
        public final Builder utranCid(Integer utranCid) {
            this.utranCid = utranCid;
            return this;
        }

        public final TdscdmaLocalId.Builder getTdscdmaLocalId() {
            return tdscdmaLocalId != null ? tdscdmaLocalId.toBuilder() : null;
        }

        public final void setTdscdmaLocalId(TdscdmaLocalId.BuilderImpl tdscdmaLocalId) {
            this.tdscdmaLocalId = tdscdmaLocalId != null ? tdscdmaLocalId.build() : null;
        }

        @Override
        public final Builder tdscdmaLocalId(TdscdmaLocalId tdscdmaLocalId) {
            this.tdscdmaLocalId = tdscdmaLocalId;
            return this;
        }

        public final Integer getTdscdmaTimingAdvance() {
            return tdscdmaTimingAdvance;
        }

        public final void setTdscdmaTimingAdvance(Integer tdscdmaTimingAdvance) {
            this.tdscdmaTimingAdvance = tdscdmaTimingAdvance;
        }

        @Override
        public final Builder tdscdmaTimingAdvance(Integer tdscdmaTimingAdvance) {
            this.tdscdmaTimingAdvance = tdscdmaTimingAdvance;
            return this;
        }

        public final Integer getRscp() {
            return rscp;
        }

        public final void setRscp(Integer rscp) {
            this.rscp = rscp;
        }

        @Override
        public final Builder rscp(Integer rscp) {
            this.rscp = rscp;
            return this;
        }

        public final Integer getPathLoss() {
            return pathLoss;
        }

        public final void setPathLoss(Integer pathLoss) {
            this.pathLoss = pathLoss;
        }

        @Override
        public final Builder pathLoss(Integer pathLoss) {
            this.pathLoss = pathLoss;
            return this;
        }

        public final List<TdscdmaNmrObj.Builder> getTdscdmaNmr() {
            List<TdscdmaNmrObj.Builder> result = TdscdmaNmrListCopier.copyToBuilder(this.tdscdmaNmr);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTdscdmaNmr(Collection<TdscdmaNmrObj.BuilderImpl> tdscdmaNmr) {
            this.tdscdmaNmr = TdscdmaNmrListCopier.copyFromBuilder(tdscdmaNmr);
        }

        @Override
        public final Builder tdscdmaNmr(Collection<TdscdmaNmrObj> tdscdmaNmr) {
            this.tdscdmaNmr = TdscdmaNmrListCopier.copy(tdscdmaNmr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tdscdmaNmr(TdscdmaNmrObj... tdscdmaNmr) {
            tdscdmaNmr(Arrays.asList(tdscdmaNmr));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tdscdmaNmr(Consumer<TdscdmaNmrObj.Builder>... tdscdmaNmr) {
            tdscdmaNmr(Stream.of(tdscdmaNmr).map(c -> TdscdmaNmrObj.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TdscdmaObj build() {
            return new TdscdmaObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
