/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ABP device object for LoRaWAN specification v1.1
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAbpV1_1 implements SdkPojo, Serializable, ToCopyableBuilder<UpdateAbpV1_1.Builder, UpdateAbpV1_1> {
    private static final SdkField<Integer> F_CNT_START_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FCntStart").getter(getter(UpdateAbpV1_1::fCntStart)).setter(setter(Builder::fCntStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FCntStart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F_CNT_START_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer fCntStart;

    private UpdateAbpV1_1(BuilderImpl builder) {
        this.fCntStart = builder.fCntStart;
    }

    /**
     * <p>
     * The FCnt init value.
     * </p>
     * 
     * @return The FCnt init value.
     */
    public final Integer fCntStart() {
        return fCntStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fCntStart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAbpV1_1)) {
            return false;
        }
        UpdateAbpV1_1 other = (UpdateAbpV1_1) obj;
        return Objects.equals(fCntStart(), other.fCntStart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAbpV1_1").add("FCntStart", fCntStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FCntStart":
            return Optional.ofNullable(clazz.cast(fCntStart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FCntStart", F_CNT_START_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAbpV1_1, T> g) {
        return obj -> g.apply((UpdateAbpV1_1) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateAbpV1_1> {
        /**
         * <p>
         * The FCnt init value.
         * </p>
         * 
         * @param fCntStart
         *        The FCnt init value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fCntStart(Integer fCntStart);
    }

    static final class BuilderImpl implements Builder {
        private Integer fCntStart;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAbpV1_1 model) {
            fCntStart(model.fCntStart);
        }

        public final Integer getFCntStart() {
            return fCntStart;
        }

        public final void setFCntStart(Integer fCntStart) {
            this.fCntStart = fCntStart;
        }

        @Override
        public final Builder fCntStart(Integer fCntStart) {
            this.fCntStart = fCntStart;
            return this;
        }

        @Override
        public UpdateAbpV1_1 build() {
            return new UpdateAbpV1_1(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
