/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDestinationRequest extends IotWirelessRequest implements
        ToCopyableBuilder<UpdateDestinationRequest.Builder, UpdateDestinationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDestinationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> EXPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpressionType").getter(getter(UpdateDestinationRequest::expressionTypeAsString))
            .setter(setter(Builder::expressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionType").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(UpdateDestinationRequest::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDestinationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateDestinationRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            EXPRESSION_TYPE_FIELD, EXPRESSION_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String expressionType;

    private final String expression;

    private final String description;

    private final String roleArn;

    private UpdateDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.expressionType = builder.expressionType;
        this.expression = builder.expression;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The new name of the resource.
     * </p>
     * 
     * @return The new name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of value in <code>Expression</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #expressionType}
     * will return {@link ExpressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expressionTypeAsString}.
     * </p>
     * 
     * @return The type of value in <code>Expression</code>.
     * @see ExpressionType
     */
    public final ExpressionType expressionType() {
        return ExpressionType.fromValue(expressionType);
    }

    /**
     * <p>
     * The type of value in <code>Expression</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #expressionType}
     * will return {@link ExpressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expressionTypeAsString}.
     * </p>
     * 
     * @return The type of value in <code>Expression</code>.
     * @see ExpressionType
     */
    public final String expressionTypeAsString() {
        return expressionType;
    }

    /**
     * <p>
     * The new rule name or topic rule to send messages to.
     * </p>
     * 
     * @return The new rule name or topic rule to send messages to.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * A new description of the resource.
     * </p>
     * 
     * @return A new description of the resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the IAM Role that authorizes the destination.
     * </p>
     * 
     * @return The ARN of the IAM Role that authorizes the destination.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(expressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDestinationRequest)) {
            return false;
        }
        UpdateDestinationRequest other = (UpdateDestinationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(expressionTypeAsString(), other.expressionTypeAsString())
                && Objects.equals(expression(), other.expression()) && Objects.equals(description(), other.description())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDestinationRequest").add("Name", name()).add("ExpressionType", expressionTypeAsString())
                .add("Expression", expression()).add("Description", description()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ExpressionType":
            return Optional.ofNullable(clazz.cast(expressionTypeAsString()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ExpressionType", EXPRESSION_TYPE_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDestinationRequest, T> g) {
        return obj -> g.apply((UpdateDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDestinationRequest> {
        /**
         * <p>
         * The new name of the resource.
         * </p>
         * 
         * @param name
         *        The new name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of value in <code>Expression</code>.
         * </p>
         * 
         * @param expressionType
         *        The type of value in <code>Expression</code>.
         * @see ExpressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpressionType
         */
        Builder expressionType(String expressionType);

        /**
         * <p>
         * The type of value in <code>Expression</code>.
         * </p>
         * 
         * @param expressionType
         *        The type of value in <code>Expression</code>.
         * @see ExpressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpressionType
         */
        Builder expressionType(ExpressionType expressionType);

        /**
         * <p>
         * The new rule name or topic rule to send messages to.
         * </p>
         * 
         * @param expression
         *        The new rule name or topic rule to send messages to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * A new description of the resource.
         * </p>
         * 
         * @param description
         *        A new description of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the IAM Role that authorizes the destination.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM Role that authorizes the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String name;

        private String expressionType;

        private String expression;

        private String description;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDestinationRequest model) {
            super(model);
            name(model.name);
            expressionType(model.expressionType);
            expression(model.expression);
            description(model.description);
            roleArn(model.roleArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getExpressionType() {
            return expressionType;
        }

        public final void setExpressionType(String expressionType) {
            this.expressionType = expressionType;
        }

        @Override
        public final Builder expressionType(String expressionType) {
            this.expressionType = expressionType;
            return this;
        }

        @Override
        public final Builder expressionType(ExpressionType expressionType) {
            this.expressionType(expressionType == null ? null : expressionType.toString());
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDestinationRequest build() {
            return new UpdateDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
