/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourcePositionRequest extends IotWirelessRequest implements
        ToCopyableBuilder<UpdateResourcePositionRequest.Builder, UpdateResourcePositionRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(UpdateResourcePositionRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceIdentifier").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(UpdateResourcePositionRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()).build();

    private static final SdkField<SdkBytes> GEO_JSON_PAYLOAD_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("GeoJsonPayload")
            .getter(getter(UpdateResourcePositionRequest::geoJsonPayload))
            .setter(setter(Builder::geoJsonPayload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoJsonPayload").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD,
            RESOURCE_TYPE_FIELD, GEO_JSON_PAYLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceIdentifier;

    private final String resourceType;

    private final SdkBytes geoJsonPayload;

    private UpdateResourcePositionRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceType = builder.resourceType;
        this.geoJsonPayload = builder.geoJsonPayload;
    }

    /**
     * <p>
     * The identifier of the resource for which position information is updated. It can be the wireless device ID or the
     * wireless gateway ID, depending on the resource type.
     * </p>
     * 
     * @return The identifier of the resource for which position information is updated. It can be the wireless device
     *         ID or the wireless gateway ID, depending on the resource type.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The type of resource for which position information is updated, which can be a wireless device or a wireless
     * gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link PositionResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource for which position information is updated, which can be a wireless device or a
     *         wireless gateway.
     * @see PositionResourceType
     */
    public final PositionResourceType resourceType() {
        return PositionResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource for which position information is updated, which can be a wireless device or a wireless
     * gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link PositionResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource for which position information is updated, which can be a wireless device or a
     *         wireless gateway.
     * @see PositionResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The position information of the resource, displayed as a JSON payload. The payload uses the GeoJSON format, which
     * a format that's used to encode geographic data structures. For more information, see <a
     * href="https://geojson.org/">GeoJSON</a>.
     * </p>
     * 
     * @return The position information of the resource, displayed as a JSON payload. The payload uses the GeoJSON
     *         format, which a format that's used to encode geographic data structures. For more information, see <a
     *         href="https://geojson.org/">GeoJSON</a>.
     */
    public final SdkBytes geoJsonPayload() {
        return geoJsonPayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(geoJsonPayload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourcePositionRequest)) {
            return false;
        }
        UpdateResourcePositionRequest other = (UpdateResourcePositionRequest) obj;
        return Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(geoJsonPayload(), other.geoJsonPayload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourcePositionRequest").add("ResourceIdentifier", resourceIdentifier())
                .add("ResourceType", resourceTypeAsString()).add("GeoJsonPayload", geoJsonPayload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "GeoJsonPayload":
            return Optional.ofNullable(clazz.cast(geoJsonPayload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("GeoJsonPayload", GEO_JSON_PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourcePositionRequest, T> g) {
        return obj -> g.apply((UpdateResourcePositionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResourcePositionRequest> {
        /**
         * <p>
         * The identifier of the resource for which position information is updated. It can be the wireless device ID or
         * the wireless gateway ID, depending on the resource type.
         * </p>
         * 
         * @param resourceIdentifier
         *        The identifier of the resource for which position information is updated. It can be the wireless
         *        device ID or the wireless gateway ID, depending on the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The type of resource for which position information is updated, which can be a wireless device or a wireless
         * gateway.
         * </p>
         * 
         * @param resourceType
         *        The type of resource for which position information is updated, which can be a wireless device or a
         *        wireless gateway.
         * @see PositionResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource for which position information is updated, which can be a wireless device or a wireless
         * gateway.
         * </p>
         * 
         * @param resourceType
         *        The type of resource for which position information is updated, which can be a wireless device or a
         *        wireless gateway.
         * @see PositionResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionResourceType
         */
        Builder resourceType(PositionResourceType resourceType);

        /**
         * <p>
         * The position information of the resource, displayed as a JSON payload. The payload uses the GeoJSON format,
         * which a format that's used to encode geographic data structures. For more information, see <a
         * href="https://geojson.org/">GeoJSON</a>.
         * </p>
         * 
         * @param geoJsonPayload
         *        The position information of the resource, displayed as a JSON payload. The payload uses the GeoJSON
         *        format, which a format that's used to encode geographic data structures. For more information, see <a
         *        href="https://geojson.org/">GeoJSON</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoJsonPayload(SdkBytes geoJsonPayload);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String resourceIdentifier;

        private String resourceType;

        private SdkBytes geoJsonPayload;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourcePositionRequest model) {
            super(model);
            resourceIdentifier(model.resourceIdentifier);
            resourceType(model.resourceType);
            geoJsonPayload(model.geoJsonPayload);
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(PositionResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final ByteBuffer getGeoJsonPayload() {
            return geoJsonPayload == null ? null : geoJsonPayload.asByteBuffer();
        }

        public final void setGeoJsonPayload(ByteBuffer geoJsonPayload) {
            geoJsonPayload(geoJsonPayload == null ? null : SdkBytes.fromByteBuffer(geoJsonPayload));
        }

        @Override
        public final Builder geoJsonPayload(SdkBytes geoJsonPayload) {
            this.geoJsonPayload = geoJsonPayload;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourcePositionRequest build() {
            return new UpdateResourcePositionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
