/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWirelessGatewayRequest extends IotWirelessRequest implements
        ToCopyableBuilder<UpdateWirelessGatewayRequest.Builder, UpdateWirelessGatewayRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateWirelessGatewayRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateWirelessGatewayRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateWirelessGatewayRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<List<String>>> JOIN_EUI_FILTERS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("JoinEuiFilters")
            .getter(getter(UpdateWirelessGatewayRequest::joinEuiFilters))
            .setter(setter(Builder::joinEuiFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinEuiFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> NET_ID_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetIdFilters")
            .getter(getter(UpdateWirelessGatewayRequest::netIdFilters))
            .setter(setter(Builder::netIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> MAX_EIRP_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("MaxEirp")
            .getter(getter(UpdateWirelessGatewayRequest::maxEirp)).setter(setter(Builder::maxEirp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEirp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, JOIN_EUI_FILTERS_FIELD, NET_ID_FILTERS_FIELD, MAX_EIRP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String description;

    private final List<List<String>> joinEuiFilters;

    private final List<String> netIdFilters;

    private final Float maxEirp;

    private UpdateWirelessGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.joinEuiFilters = builder.joinEuiFilters;
        this.netIdFilters = builder.netIdFilters;
        this.maxEirp = builder.maxEirp;
    }

    /**
     * <p>
     * The ID of the resource to update.
     * </p>
     * 
     * @return The ID of the resource to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The new name of the resource.
     * </p>
     * 
     * @return The new name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A new description of the resource.
     * </p>
     * 
     * @return A new description of the resource.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the JoinEuiFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJoinEuiFilters() {
        return joinEuiFilters != null && !(joinEuiFilters instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the JoinEuiFilters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJoinEuiFilters} method.
     * </p>
     * 
     * @return The value of the JoinEuiFilters property for this object.
     */
    public final List<List<String>> joinEuiFilters() {
        return joinEuiFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetIdFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetIdFilters() {
        return netIdFilters != null && !(netIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the NetIdFilters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetIdFilters} method.
     * </p>
     * 
     * @return The value of the NetIdFilters property for this object.
     */
    public final List<String> netIdFilters() {
        return netIdFilters;
    }

    /**
     * <p>
     * The MaxEIRP value.
     * </p>
     * 
     * @return The MaxEIRP value.
     */
    public final Float maxEirp() {
        return maxEirp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasJoinEuiFilters() ? joinEuiFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetIdFilters() ? netIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxEirp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWirelessGatewayRequest)) {
            return false;
        }
        UpdateWirelessGatewayRequest other = (UpdateWirelessGatewayRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasJoinEuiFilters() == other.hasJoinEuiFilters()
                && Objects.equals(joinEuiFilters(), other.joinEuiFilters()) && hasNetIdFilters() == other.hasNetIdFilters()
                && Objects.equals(netIdFilters(), other.netIdFilters()) && Objects.equals(maxEirp(), other.maxEirp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWirelessGatewayRequest").add("Id", id()).add("Name", name())
                .add("Description", description()).add("JoinEuiFilters", hasJoinEuiFilters() ? joinEuiFilters() : null)
                .add("NetIdFilters", hasNetIdFilters() ? netIdFilters() : null).add("MaxEirp", maxEirp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "JoinEuiFilters":
            return Optional.ofNullable(clazz.cast(joinEuiFilters()));
        case "NetIdFilters":
            return Optional.ofNullable(clazz.cast(netIdFilters()));
        case "MaxEirp":
            return Optional.ofNullable(clazz.cast(maxEirp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("JoinEuiFilters", JOIN_EUI_FILTERS_FIELD);
        map.put("NetIdFilters", NET_ID_FILTERS_FIELD);
        map.put("MaxEirp", MAX_EIRP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWirelessGatewayRequest, T> g) {
        return obj -> g.apply((UpdateWirelessGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWirelessGatewayRequest> {
        /**
         * <p>
         * The ID of the resource to update.
         * </p>
         * 
         * @param id
         *        The ID of the resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The new name of the resource.
         * </p>
         * 
         * @param name
         *        The new name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A new description of the resource.
         * </p>
         * 
         * @param description
         *        A new description of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the JoinEuiFilters property for this object.
         *
         * @param joinEuiFilters
         *        The new value for the JoinEuiFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinEuiFilters(Collection<? extends Collection<String>> joinEuiFilters);

        /**
         * Sets the value of the JoinEuiFilters property for this object.
         *
         * @param joinEuiFilters
         *        The new value for the JoinEuiFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinEuiFilters(Collection<String>... joinEuiFilters);

        /**
         * Sets the value of the NetIdFilters property for this object.
         *
         * @param netIdFilters
         *        The new value for the NetIdFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netIdFilters(Collection<String> netIdFilters);

        /**
         * Sets the value of the NetIdFilters property for this object.
         *
         * @param netIdFilters
         *        The new value for the NetIdFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netIdFilters(String... netIdFilters);

        /**
         * <p>
         * The MaxEIRP value.
         * </p>
         * 
         * @param maxEirp
         *        The MaxEIRP value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxEirp(Float maxEirp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private List<List<String>> joinEuiFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> netIdFilters = DefaultSdkAutoConstructList.getInstance();

        private Float maxEirp;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWirelessGatewayRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            joinEuiFilters(model.joinEuiFilters);
            netIdFilters(model.netIdFilters);
            maxEirp(model.maxEirp);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<? extends Collection<String>> getJoinEuiFilters() {
            if (joinEuiFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return joinEuiFilters;
        }

        public final void setJoinEuiFilters(Collection<? extends Collection<String>> joinEuiFilters) {
            this.joinEuiFilters = JoinEuiFiltersCopier.copy(joinEuiFilters);
        }

        @Override
        public final Builder joinEuiFilters(Collection<? extends Collection<String>> joinEuiFilters) {
            this.joinEuiFilters = JoinEuiFiltersCopier.copy(joinEuiFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinEuiFilters(Collection<String>... joinEuiFilters) {
            joinEuiFilters(Arrays.asList(joinEuiFilters));
            return this;
        }

        public final Collection<String> getNetIdFilters() {
            if (netIdFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return netIdFilters;
        }

        public final void setNetIdFilters(Collection<String> netIdFilters) {
            this.netIdFilters = NetIdFiltersCopier.copy(netIdFilters);
        }

        @Override
        public final Builder netIdFilters(Collection<String> netIdFilters) {
            this.netIdFilters = NetIdFiltersCopier.copy(netIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder netIdFilters(String... netIdFilters) {
            netIdFilters(Arrays.asList(netIdFilters));
            return this;
        }

        public final Float getMaxEirp() {
            return maxEirp;
        }

        public final void setMaxEirp(Float maxEirp) {
            this.maxEirp = maxEirp;
        }

        @Override
        public final Builder maxEirp(Float maxEirp) {
            this.maxEirp = maxEirp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWirelessGatewayRequest build() {
            return new UpdateWirelessGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
