/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Network Measurement Reports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WcdmaNmrObj implements SdkPojo, Serializable, ToCopyableBuilder<WcdmaNmrObj.Builder, WcdmaNmrObj> {
    private static final SdkField<Integer> UARFCNDL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Uarfcndl").getter(getter(WcdmaNmrObj::uarfcndl)).setter(setter(Builder::uarfcndl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uarfcndl").build()).build();

    private static final SdkField<Integer> PSC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Psc")
            .getter(getter(WcdmaNmrObj::psc)).setter(setter(Builder::psc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Psc").build()).build();

    private static final SdkField<Integer> UTRAN_CID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UtranCid").getter(getter(WcdmaNmrObj::utranCid)).setter(setter(Builder::utranCid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtranCid").build()).build();

    private static final SdkField<Integer> RSCP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rscp")
            .getter(getter(WcdmaNmrObj::rscp)).setter(setter(Builder::rscp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rscp").build()).build();

    private static final SdkField<Integer> PATH_LOSS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PathLoss").getter(getter(WcdmaNmrObj::pathLoss)).setter(setter(Builder::pathLoss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathLoss").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UARFCNDL_FIELD, PSC_FIELD,
            UTRAN_CID_FIELD, RSCP_FIELD, PATH_LOSS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer uarfcndl;

    private final Integer psc;

    private final Integer utranCid;

    private final Integer rscp;

    private final Integer pathLoss;

    private WcdmaNmrObj(BuilderImpl builder) {
        this.uarfcndl = builder.uarfcndl;
        this.psc = builder.psc;
        this.utranCid = builder.utranCid;
        this.rscp = builder.rscp;
        this.pathLoss = builder.pathLoss;
    }

    /**
     * <p>
     * WCDMA UTRA Absolute RF Channel Number downlink.
     * </p>
     * 
     * @return WCDMA UTRA Absolute RF Channel Number downlink.
     */
    public final Integer uarfcndl() {
        return uarfcndl;
    }

    /**
     * <p>
     * Primary Scrambling Code.
     * </p>
     * 
     * @return Primary Scrambling Code.
     */
    public final Integer psc() {
        return psc;
    }

    /**
     * <p>
     * UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
     * </p>
     * 
     * @return UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
     */
    public final Integer utranCid() {
        return utranCid;
    }

    /**
     * <p>
     * Received Signal Code Power (signal power) (dBm)
     * </p>
     * 
     * @return Received Signal Code Power (signal power) (dBm)
     */
    public final Integer rscp() {
        return rscp;
    }

    /**
     * <p>
     * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates
     * through space.
     * </p>
     * 
     * @return Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it
     *         propagates through space.
     */
    public final Integer pathLoss() {
        return pathLoss;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uarfcndl());
        hashCode = 31 * hashCode + Objects.hashCode(psc());
        hashCode = 31 * hashCode + Objects.hashCode(utranCid());
        hashCode = 31 * hashCode + Objects.hashCode(rscp());
        hashCode = 31 * hashCode + Objects.hashCode(pathLoss());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WcdmaNmrObj)) {
            return false;
        }
        WcdmaNmrObj other = (WcdmaNmrObj) obj;
        return Objects.equals(uarfcndl(), other.uarfcndl()) && Objects.equals(psc(), other.psc())
                && Objects.equals(utranCid(), other.utranCid()) && Objects.equals(rscp(), other.rscp())
                && Objects.equals(pathLoss(), other.pathLoss());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WcdmaNmrObj").add("Uarfcndl", uarfcndl()).add("Psc", psc()).add("UtranCid", utranCid())
                .add("Rscp", rscp()).add("PathLoss", pathLoss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uarfcndl":
            return Optional.ofNullable(clazz.cast(uarfcndl()));
        case "Psc":
            return Optional.ofNullable(clazz.cast(psc()));
        case "UtranCid":
            return Optional.ofNullable(clazz.cast(utranCid()));
        case "Rscp":
            return Optional.ofNullable(clazz.cast(rscp()));
        case "PathLoss":
            return Optional.ofNullable(clazz.cast(pathLoss()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Uarfcndl", UARFCNDL_FIELD);
        map.put("Psc", PSC_FIELD);
        map.put("UtranCid", UTRAN_CID_FIELD);
        map.put("Rscp", RSCP_FIELD);
        map.put("PathLoss", PATH_LOSS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WcdmaNmrObj, T> g) {
        return obj -> g.apply((WcdmaNmrObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WcdmaNmrObj> {
        /**
         * <p>
         * WCDMA UTRA Absolute RF Channel Number downlink.
         * </p>
         * 
         * @param uarfcndl
         *        WCDMA UTRA Absolute RF Channel Number downlink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uarfcndl(Integer uarfcndl);

        /**
         * <p>
         * Primary Scrambling Code.
         * </p>
         * 
         * @param psc
         *        Primary Scrambling Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder psc(Integer psc);

        /**
         * <p>
         * UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
         * </p>
         * 
         * @param utranCid
         *        UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utranCid(Integer utranCid);

        /**
         * <p>
         * Received Signal Code Power (signal power) (dBm)
         * </p>
         * 
         * @param rscp
         *        Received Signal Code Power (signal power) (dBm)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rscp(Integer rscp);

        /**
         * <p>
         * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates
         * through space.
         * </p>
         * 
         * @param pathLoss
         *        Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it
         *        propagates through space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathLoss(Integer pathLoss);
    }

    static final class BuilderImpl implements Builder {
        private Integer uarfcndl;

        private Integer psc;

        private Integer utranCid;

        private Integer rscp;

        private Integer pathLoss;

        private BuilderImpl() {
        }

        private BuilderImpl(WcdmaNmrObj model) {
            uarfcndl(model.uarfcndl);
            psc(model.psc);
            utranCid(model.utranCid);
            rscp(model.rscp);
            pathLoss(model.pathLoss);
        }

        public final Integer getUarfcndl() {
            return uarfcndl;
        }

        public final void setUarfcndl(Integer uarfcndl) {
            this.uarfcndl = uarfcndl;
        }

        @Override
        public final Builder uarfcndl(Integer uarfcndl) {
            this.uarfcndl = uarfcndl;
            return this;
        }

        public final Integer getPsc() {
            return psc;
        }

        public final void setPsc(Integer psc) {
            this.psc = psc;
        }

        @Override
        public final Builder psc(Integer psc) {
            this.psc = psc;
            return this;
        }

        public final Integer getUtranCid() {
            return utranCid;
        }

        public final void setUtranCid(Integer utranCid) {
            this.utranCid = utranCid;
        }

        @Override
        public final Builder utranCid(Integer utranCid) {
            this.utranCid = utranCid;
            return this;
        }

        public final Integer getRscp() {
            return rscp;
        }

        public final void setRscp(Integer rscp) {
            this.rscp = rscp;
        }

        @Override
        public final Builder rscp(Integer rscp) {
            this.rscp = rscp;
            return this;
        }

        public final Integer getPathLoss() {
            return pathLoss;
        }

        public final void setPathLoss(Integer pathLoss) {
            this.pathLoss = pathLoss;
        }

        @Override
        public final Builder pathLoss(Integer pathLoss) {
            this.pathLoss = pathLoss;
            return this;
        }

        @Override
        public WcdmaNmrObj build() {
            return new WcdmaNmrObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
