/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an import task for wireless devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WirelessDeviceImportTask implements SdkPojo, Serializable,
        ToCopyableBuilder<WirelessDeviceImportTask.Builder, WirelessDeviceImportTask> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(WirelessDeviceImportTask::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(WirelessDeviceImportTask::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(WirelessDeviceImportTask::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()).build();

    private static final SdkField<SidewalkGetStartImportInfo> SIDEWALK_FIELD = SdkField
            .<SidewalkGetStartImportInfo> builder(MarshallingType.SDK_POJO).memberName("Sidewalk")
            .getter(getter(WirelessDeviceImportTask::sidewalk)).setter(setter(Builder::sidewalk))
            .constructor(SidewalkGetStartImportInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(WirelessDeviceImportTask::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(WirelessDeviceImportTask::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(WirelessDeviceImportTask::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Long> INITIALIZED_IMPORTED_DEVICE_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("InitializedImportedDeviceCount")
            .getter(getter(WirelessDeviceImportTask::initializedImportedDeviceCount))
            .setter(setter(Builder::initializedImportedDeviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializedImportedDeviceCount")
                    .build()).build();

    private static final SdkField<Long> PENDING_IMPORTED_DEVICE_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PendingImportedDeviceCount")
            .getter(getter(WirelessDeviceImportTask::pendingImportedDeviceCount))
            .setter(setter(Builder::pendingImportedDeviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingImportedDeviceCount").build())
            .build();

    private static final SdkField<Long> ONBOARDED_IMPORTED_DEVICE_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("OnboardedImportedDeviceCount")
            .getter(getter(WirelessDeviceImportTask::onboardedImportedDeviceCount))
            .setter(setter(Builder::onboardedImportedDeviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnboardedImportedDeviceCount")
                    .build()).build();

    private static final SdkField<Long> FAILED_IMPORTED_DEVICE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FailedImportedDeviceCount").getter(getter(WirelessDeviceImportTask::failedImportedDeviceCount))
            .setter(setter(Builder::failedImportedDeviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedImportedDeviceCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            DESTINATION_NAME_FIELD, SIDEWALK_FIELD, CREATION_TIME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD,
            INITIALIZED_IMPORTED_DEVICE_COUNT_FIELD, PENDING_IMPORTED_DEVICE_COUNT_FIELD, ONBOARDED_IMPORTED_DEVICE_COUNT_FIELD,
            FAILED_IMPORTED_DEVICE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String destinationName;

    private final SidewalkGetStartImportInfo sidewalk;

    private final Instant creationTime;

    private final String status;

    private final String statusReason;

    private final Long initializedImportedDeviceCount;

    private final Long pendingImportedDeviceCount;

    private final Long onboardedImportedDeviceCount;

    private final Long failedImportedDeviceCount;

    private WirelessDeviceImportTask(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.destinationName = builder.destinationName;
        this.sidewalk = builder.sidewalk;
        this.creationTime = builder.creationTime;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.initializedImportedDeviceCount = builder.initializedImportedDeviceCount;
        this.pendingImportedDeviceCount = builder.pendingImportedDeviceCount;
        this.onboardedImportedDeviceCount = builder.onboardedImportedDeviceCount;
        this.failedImportedDeviceCount = builder.failedImportedDeviceCount;
    }

    /**
     * <p>
     * The ID of the wireless device import task.
     * </p>
     * 
     * @return The ID of the wireless device import task.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the wireless device import task.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the wireless device import task.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the Sidewalk destination that that describes the IoT rule to route messages from the device in the
     * import task that will be onboarded to AWS IoT Wireless
     * </p>
     * 
     * @return The name of the Sidewalk destination that that describes the IoT rule to route messages from the device
     *         in the import task that will be onboarded to AWS IoT Wireless
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * The Sidewalk-related information of the wireless device import task.
     * </p>
     * 
     * @return The Sidewalk-related information of the wireless device import task.
     */
    public final SidewalkGetStartImportInfo sidewalk() {
        return sidewalk;
    }

    /**
     * <p>
     * The time at which the import task was created.
     * </p>
     * 
     * @return The time at which the import task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The status information of the wireless device import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status information of the wireless device import task.
     * @see ImportTaskStatus
     */
    public final ImportTaskStatus status() {
        return ImportTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status information of the wireless device import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status information of the wireless device import task.
     * @see ImportTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason that provides additional information about the import task status.
     * </p>
     * 
     * @return The reason that provides additional information about the import task status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The summary information of count of wireless devices that are waiting for the control log to be added to an
     * import task.
     * </p>
     * 
     * @return The summary information of count of wireless devices that are waiting for the control log to be added to
     *         an import task.
     */
    public final Long initializedImportedDeviceCount() {
        return initializedImportedDeviceCount;
    }

    /**
     * <p>
     * The summary information of count of wireless devices in an import task that are waiting in the queue to be
     * onboarded.
     * </p>
     * 
     * @return The summary information of count of wireless devices in an import task that are waiting in the queue to
     *         be onboarded.
     */
    public final Long pendingImportedDeviceCount() {
        return pendingImportedDeviceCount;
    }

    /**
     * <p>
     * The summary information of count of wireless devices in an import task that have been onboarded to the import
     * task.
     * </p>
     * 
     * @return The summary information of count of wireless devices in an import task that have been onboarded to the
     *         import task.
     */
    public final Long onboardedImportedDeviceCount() {
        return onboardedImportedDeviceCount;
    }

    /**
     * <p>
     * The summary information of count of wireless devices in an import task that failed to onboarded to the import
     * task.
     * </p>
     * 
     * @return The summary information of count of wireless devices in an import task that failed to onboarded to the
     *         import task.
     */
    public final Long failedImportedDeviceCount() {
        return failedImportedDeviceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(initializedImportedDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(pendingImportedDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(onboardedImportedDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedImportedDeviceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WirelessDeviceImportTask)) {
            return false;
        }
        WirelessDeviceImportTask other = (WirelessDeviceImportTask) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(destinationName(), other.destinationName()) && Objects.equals(sidewalk(), other.sidewalk())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(initializedImportedDeviceCount(), other.initializedImportedDeviceCount())
                && Objects.equals(pendingImportedDeviceCount(), other.pendingImportedDeviceCount())
                && Objects.equals(onboardedImportedDeviceCount(), other.onboardedImportedDeviceCount())
                && Objects.equals(failedImportedDeviceCount(), other.failedImportedDeviceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WirelessDeviceImportTask").add("Id", id()).add("Arn", arn())
                .add("DestinationName", destinationName()).add("Sidewalk", sidewalk()).add("CreationTime", creationTime())
                .add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("InitializedImportedDeviceCount", initializedImportedDeviceCount())
                .add("PendingImportedDeviceCount", pendingImportedDeviceCount())
                .add("OnboardedImportedDeviceCount", onboardedImportedDeviceCount())
                .add("FailedImportedDeviceCount", failedImportedDeviceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "Sidewalk":
            return Optional.ofNullable(clazz.cast(sidewalk()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "InitializedImportedDeviceCount":
            return Optional.ofNullable(clazz.cast(initializedImportedDeviceCount()));
        case "PendingImportedDeviceCount":
            return Optional.ofNullable(clazz.cast(pendingImportedDeviceCount()));
        case "OnboardedImportedDeviceCount":
            return Optional.ofNullable(clazz.cast(onboardedImportedDeviceCount()));
        case "FailedImportedDeviceCount":
            return Optional.ofNullable(clazz.cast(failedImportedDeviceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("DestinationName", DESTINATION_NAME_FIELD);
        map.put("Sidewalk", SIDEWALK_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("InitializedImportedDeviceCount", INITIALIZED_IMPORTED_DEVICE_COUNT_FIELD);
        map.put("PendingImportedDeviceCount", PENDING_IMPORTED_DEVICE_COUNT_FIELD);
        map.put("OnboardedImportedDeviceCount", ONBOARDED_IMPORTED_DEVICE_COUNT_FIELD);
        map.put("FailedImportedDeviceCount", FAILED_IMPORTED_DEVICE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WirelessDeviceImportTask, T> g) {
        return obj -> g.apply((WirelessDeviceImportTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WirelessDeviceImportTask> {
        /**
         * <p>
         * The ID of the wireless device import task.
         * </p>
         * 
         * @param id
         *        The ID of the wireless device import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the wireless device import task.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the wireless device import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the Sidewalk destination that that describes the IoT rule to route messages from the device in
         * the import task that will be onboarded to AWS IoT Wireless
         * </p>
         * 
         * @param destinationName
         *        The name of the Sidewalk destination that that describes the IoT rule to route messages from the
         *        device in the import task that will be onboarded to AWS IoT Wireless
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * The Sidewalk-related information of the wireless device import task.
         * </p>
         * 
         * @param sidewalk
         *        The Sidewalk-related information of the wireless device import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalk(SidewalkGetStartImportInfo sidewalk);

        /**
         * <p>
         * The Sidewalk-related information of the wireless device import task.
         * </p>
         * This is a convenience method that creates an instance of the {@link SidewalkGetStartImportInfo.Builder}
         * avoiding the need to create one manually via {@link SidewalkGetStartImportInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SidewalkGetStartImportInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #sidewalk(SidewalkGetStartImportInfo)}.
         * 
         * @param sidewalk
         *        a consumer that will call methods on {@link SidewalkGetStartImportInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sidewalk(SidewalkGetStartImportInfo)
         */
        default Builder sidewalk(Consumer<SidewalkGetStartImportInfo.Builder> sidewalk) {
            return sidewalk(SidewalkGetStartImportInfo.builder().applyMutation(sidewalk).build());
        }

        /**
         * <p>
         * The time at which the import task was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the import task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The status information of the wireless device import task.
         * </p>
         * 
         * @param status
         *        The status information of the wireless device import task.
         * @see ImportTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status information of the wireless device import task.
         * </p>
         * 
         * @param status
         *        The status information of the wireless device import task.
         * @see ImportTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportTaskStatus
         */
        Builder status(ImportTaskStatus status);

        /**
         * <p>
         * The reason that provides additional information about the import task status.
         * </p>
         * 
         * @param statusReason
         *        The reason that provides additional information about the import task status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The summary information of count of wireless devices that are waiting for the control log to be added to an
         * import task.
         * </p>
         * 
         * @param initializedImportedDeviceCount
         *        The summary information of count of wireless devices that are waiting for the control log to be added
         *        to an import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializedImportedDeviceCount(Long initializedImportedDeviceCount);

        /**
         * <p>
         * The summary information of count of wireless devices in an import task that are waiting in the queue to be
         * onboarded.
         * </p>
         * 
         * @param pendingImportedDeviceCount
         *        The summary information of count of wireless devices in an import task that are waiting in the queue
         *        to be onboarded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingImportedDeviceCount(Long pendingImportedDeviceCount);

        /**
         * <p>
         * The summary information of count of wireless devices in an import task that have been onboarded to the import
         * task.
         * </p>
         * 
         * @param onboardedImportedDeviceCount
         *        The summary information of count of wireless devices in an import task that have been onboarded to the
         *        import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onboardedImportedDeviceCount(Long onboardedImportedDeviceCount);

        /**
         * <p>
         * The summary information of count of wireless devices in an import task that failed to onboarded to the import
         * task.
         * </p>
         * 
         * @param failedImportedDeviceCount
         *        The summary information of count of wireless devices in an import task that failed to onboarded to the
         *        import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedImportedDeviceCount(Long failedImportedDeviceCount);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String destinationName;

        private SidewalkGetStartImportInfo sidewalk;

        private Instant creationTime;

        private String status;

        private String statusReason;

        private Long initializedImportedDeviceCount;

        private Long pendingImportedDeviceCount;

        private Long onboardedImportedDeviceCount;

        private Long failedImportedDeviceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(WirelessDeviceImportTask model) {
            id(model.id);
            arn(model.arn);
            destinationName(model.destinationName);
            sidewalk(model.sidewalk);
            creationTime(model.creationTime);
            status(model.status);
            statusReason(model.statusReason);
            initializedImportedDeviceCount(model.initializedImportedDeviceCount);
            pendingImportedDeviceCount(model.pendingImportedDeviceCount);
            onboardedImportedDeviceCount(model.onboardedImportedDeviceCount);
            failedImportedDeviceCount(model.failedImportedDeviceCount);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final SidewalkGetStartImportInfo.Builder getSidewalk() {
            return sidewalk != null ? sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkGetStartImportInfo.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkGetStartImportInfo sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Long getInitializedImportedDeviceCount() {
            return initializedImportedDeviceCount;
        }

        public final void setInitializedImportedDeviceCount(Long initializedImportedDeviceCount) {
            this.initializedImportedDeviceCount = initializedImportedDeviceCount;
        }

        @Override
        public final Builder initializedImportedDeviceCount(Long initializedImportedDeviceCount) {
            this.initializedImportedDeviceCount = initializedImportedDeviceCount;
            return this;
        }

        public final Long getPendingImportedDeviceCount() {
            return pendingImportedDeviceCount;
        }

        public final void setPendingImportedDeviceCount(Long pendingImportedDeviceCount) {
            this.pendingImportedDeviceCount = pendingImportedDeviceCount;
        }

        @Override
        public final Builder pendingImportedDeviceCount(Long pendingImportedDeviceCount) {
            this.pendingImportedDeviceCount = pendingImportedDeviceCount;
            return this;
        }

        public final Long getOnboardedImportedDeviceCount() {
            return onboardedImportedDeviceCount;
        }

        public final void setOnboardedImportedDeviceCount(Long onboardedImportedDeviceCount) {
            this.onboardedImportedDeviceCount = onboardedImportedDeviceCount;
        }

        @Override
        public final Builder onboardedImportedDeviceCount(Long onboardedImportedDeviceCount) {
            this.onboardedImportedDeviceCount = onboardedImportedDeviceCount;
            return this;
        }

        public final Long getFailedImportedDeviceCount() {
            return failedImportedDeviceCount;
        }

        public final void setFailedImportedDeviceCount(Long failedImportedDeviceCount) {
            this.failedImportedDeviceCount = failedImportedDeviceCount;
        }

        @Override
        public final Builder failedImportedDeviceCount(Long failedImportedDeviceCount) {
            this.failedImportedDeviceCount = failedImportedDeviceCount;
            return this;
        }

        @Override
        public WirelessDeviceImportTask build() {
            return new WirelessDeviceImportTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
