/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a wireless device's operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WirelessDeviceStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<WirelessDeviceStatistics.Builder, WirelessDeviceStatistics> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(WirelessDeviceStatistics::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(WirelessDeviceStatistics::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(WirelessDeviceStatistics::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(WirelessDeviceStatistics::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(WirelessDeviceStatistics::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()).build();

    private static final SdkField<String> LAST_UPLINK_RECEIVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUplinkReceivedAt").getter(getter(WirelessDeviceStatistics::lastUplinkReceivedAt))
            .setter(setter(Builder::lastUplinkReceivedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUplinkReceivedAt").build())
            .build();

    private static final SdkField<LoRaWANListDevice> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANListDevice> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(WirelessDeviceStatistics::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANListDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<SidewalkListDevice> SIDEWALK_FIELD = SdkField
            .<SidewalkListDevice> builder(MarshallingType.SDK_POJO).memberName("Sidewalk")
            .getter(getter(WirelessDeviceStatistics::sidewalk)).setter(setter(Builder::sidewalk))
            .constructor(SidewalkListDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()).build();

    private static final SdkField<String> FUOTA_DEVICE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FuotaDeviceStatus").getter(getter(WirelessDeviceStatistics::fuotaDeviceStatusAsString))
            .setter(setter(Builder::fuotaDeviceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FuotaDeviceStatus").build()).build();

    private static final SdkField<String> MULTICAST_DEVICE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MulticastDeviceStatus").getter(getter(WirelessDeviceStatistics::multicastDeviceStatus))
            .setter(setter(Builder::multicastDeviceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastDeviceStatus").build())
            .build();

    private static final SdkField<Integer> MC_GROUP_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("McGroupId").getter(getter(WirelessDeviceStatistics::mcGroupId)).setter(setter(Builder::mcGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("McGroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            TYPE_FIELD, NAME_FIELD, DESTINATION_NAME_FIELD, LAST_UPLINK_RECEIVED_AT_FIELD, LO_RA_WAN_FIELD, SIDEWALK_FIELD,
            FUOTA_DEVICE_STATUS_FIELD, MULTICAST_DEVICE_STATUS_FIELD, MC_GROUP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String type;

    private final String name;

    private final String destinationName;

    private final String lastUplinkReceivedAt;

    private final LoRaWANListDevice loRaWAN;

    private final SidewalkListDevice sidewalk;

    private final String fuotaDeviceStatus;

    private final String multicastDeviceStatus;

    private final Integer mcGroupId;

    private WirelessDeviceStatistics(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.type = builder.type;
        this.name = builder.name;
        this.destinationName = builder.destinationName;
        this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
        this.loRaWAN = builder.loRaWAN;
        this.sidewalk = builder.sidewalk;
        this.fuotaDeviceStatus = builder.fuotaDeviceStatus;
        this.multicastDeviceStatus = builder.multicastDeviceStatus;
        this.mcGroupId = builder.mcGroupId;
    }

    /**
     * <p>
     * The Amazon Resource Name of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the wireless device reporting the data.
     * </p>
     * 
     * @return The ID of the wireless device reporting the data.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The wireless device type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WirelessDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The wireless device type.
     * @see WirelessDeviceType
     */
    public final WirelessDeviceType type() {
        return WirelessDeviceType.fromValue(type);
    }

    /**
     * <p>
     * The wireless device type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WirelessDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The wireless device type.
     * @see WirelessDeviceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the destination to which the device is assigned.
     * </p>
     * 
     * @return The name of the destination to which the device is assigned.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * The date and time when the most recent uplink was received.
     * </p>
     * <note>
     * <p>
     * Theis value is only valid for 3 months.
     * </p>
     * </note>
     * 
     * @return The date and time when the most recent uplink was received.</p> <note>
     *         <p>
     *         Theis value is only valid for 3 months.
     *         </p>
     */
    public final String lastUplinkReceivedAt() {
        return lastUplinkReceivedAt;
    }

    /**
     * <p>
     * LoRaWAN device info.
     * </p>
     * 
     * @return LoRaWAN device info.
     */
    public final LoRaWANListDevice loRaWAN() {
        return loRaWAN;
    }

    /**
     * <p>
     * The Sidewalk account credentials.
     * </p>
     * 
     * @return The Sidewalk account credentials.
     */
    public final SidewalkListDevice sidewalk() {
        return sidewalk;
    }

    /**
     * Returns the value of the FuotaDeviceStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fuotaDeviceStatus}
     * will return {@link FuotaDeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fuotaDeviceStatusAsString}.
     * </p>
     * 
     * @return The value of the FuotaDeviceStatus property for this object.
     * @see FuotaDeviceStatus
     */
    public final FuotaDeviceStatus fuotaDeviceStatus() {
        return FuotaDeviceStatus.fromValue(fuotaDeviceStatus);
    }

    /**
     * Returns the value of the FuotaDeviceStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fuotaDeviceStatus}
     * will return {@link FuotaDeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fuotaDeviceStatusAsString}.
     * </p>
     * 
     * @return The value of the FuotaDeviceStatus property for this object.
     * @see FuotaDeviceStatus
     */
    public final String fuotaDeviceStatusAsString() {
        return fuotaDeviceStatus;
    }

    /**
     * <p>
     * The status of the wireless device in the multicast group.
     * </p>
     * 
     * @return The status of the wireless device in the multicast group.
     */
    public final String multicastDeviceStatus() {
        return multicastDeviceStatus;
    }

    /**
     * Returns the value of the McGroupId property for this object.
     * 
     * @return The value of the McGroupId property for this object.
     */
    public final Integer mcGroupId() {
        return mcGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(lastUplinkReceivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(fuotaDeviceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multicastDeviceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(mcGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WirelessDeviceStatistics)) {
            return false;
        }
        WirelessDeviceStatistics other = (WirelessDeviceStatistics) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(destinationName(), other.destinationName())
                && Objects.equals(lastUplinkReceivedAt(), other.lastUplinkReceivedAt())
                && Objects.equals(loRaWAN(), other.loRaWAN()) && Objects.equals(sidewalk(), other.sidewalk())
                && Objects.equals(fuotaDeviceStatusAsString(), other.fuotaDeviceStatusAsString())
                && Objects.equals(multicastDeviceStatus(), other.multicastDeviceStatus())
                && Objects.equals(mcGroupId(), other.mcGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WirelessDeviceStatistics").add("Arn", arn()).add("Id", id()).add("Type", typeAsString())
                .add("Name", name()).add("DestinationName", destinationName())
                .add("LastUplinkReceivedAt", lastUplinkReceivedAt()).add("LoRaWAN", loRaWAN()).add("Sidewalk", sidewalk())
                .add("FuotaDeviceStatus", fuotaDeviceStatusAsString()).add("MulticastDeviceStatus", multicastDeviceStatus())
                .add("McGroupId", mcGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "LastUplinkReceivedAt":
            return Optional.ofNullable(clazz.cast(lastUplinkReceivedAt()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "Sidewalk":
            return Optional.ofNullable(clazz.cast(sidewalk()));
        case "FuotaDeviceStatus":
            return Optional.ofNullable(clazz.cast(fuotaDeviceStatusAsString()));
        case "MulticastDeviceStatus":
            return Optional.ofNullable(clazz.cast(multicastDeviceStatus()));
        case "McGroupId":
            return Optional.ofNullable(clazz.cast(mcGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DestinationName", DESTINATION_NAME_FIELD);
        map.put("LastUplinkReceivedAt", LAST_UPLINK_RECEIVED_AT_FIELD);
        map.put("LoRaWAN", LO_RA_WAN_FIELD);
        map.put("Sidewalk", SIDEWALK_FIELD);
        map.put("FuotaDeviceStatus", FUOTA_DEVICE_STATUS_FIELD);
        map.put("MulticastDeviceStatus", MULTICAST_DEVICE_STATUS_FIELD);
        map.put("McGroupId", MC_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WirelessDeviceStatistics, T> g) {
        return obj -> g.apply((WirelessDeviceStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WirelessDeviceStatistics> {
        /**
         * <p>
         * The Amazon Resource Name of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the wireless device reporting the data.
         * </p>
         * 
         * @param id
         *        The ID of the wireless device reporting the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The wireless device type.
         * </p>
         * 
         * @param type
         *        The wireless device type.
         * @see WirelessDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceType
         */
        Builder type(String type);

        /**
         * <p>
         * The wireless device type.
         * </p>
         * 
         * @param type
         *        The wireless device type.
         * @see WirelessDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceType
         */
        Builder type(WirelessDeviceType type);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the destination to which the device is assigned.
         * </p>
         * 
         * @param destinationName
         *        The name of the destination to which the device is assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * The date and time when the most recent uplink was received.
         * </p>
         * <note>
         * <p>
         * Theis value is only valid for 3 months.
         * </p>
         * </note>
         * 
         * @param lastUplinkReceivedAt
         *        The date and time when the most recent uplink was received.</p> <note>
         *        <p>
         *        Theis value is only valid for 3 months.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUplinkReceivedAt(String lastUplinkReceivedAt);

        /**
         * <p>
         * LoRaWAN device info.
         * </p>
         * 
         * @param loRaWAN
         *        LoRaWAN device info.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANListDevice loRaWAN);

        /**
         * <p>
         * LoRaWAN device info.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoRaWANListDevice.Builder} avoiding the
         * need to create one manually via {@link LoRaWANListDevice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoRaWANListDevice.Builder#build()} is called immediately and its
         * result is passed to {@link #loRaWAN(LoRaWANListDevice)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANListDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANListDevice)
         */
        default Builder loRaWAN(Consumer<LoRaWANListDevice.Builder> loRaWAN) {
            return loRaWAN(LoRaWANListDevice.builder().applyMutation(loRaWAN).build());
        }

        /**
         * <p>
         * The Sidewalk account credentials.
         * </p>
         * 
         * @param sidewalk
         *        The Sidewalk account credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalk(SidewalkListDevice sidewalk);

        /**
         * <p>
         * The Sidewalk account credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link SidewalkListDevice.Builder} avoiding the
         * need to create one manually via {@link SidewalkListDevice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SidewalkListDevice.Builder#build()} is called immediately and its
         * result is passed to {@link #sidewalk(SidewalkListDevice)}.
         * 
         * @param sidewalk
         *        a consumer that will call methods on {@link SidewalkListDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sidewalk(SidewalkListDevice)
         */
        default Builder sidewalk(Consumer<SidewalkListDevice.Builder> sidewalk) {
            return sidewalk(SidewalkListDevice.builder().applyMutation(sidewalk).build());
        }

        /**
         * Sets the value of the FuotaDeviceStatus property for this object.
         *
         * @param fuotaDeviceStatus
         *        The new value for the FuotaDeviceStatus property for this object.
         * @see FuotaDeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FuotaDeviceStatus
         */
        Builder fuotaDeviceStatus(String fuotaDeviceStatus);

        /**
         * Sets the value of the FuotaDeviceStatus property for this object.
         *
         * @param fuotaDeviceStatus
         *        The new value for the FuotaDeviceStatus property for this object.
         * @see FuotaDeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FuotaDeviceStatus
         */
        Builder fuotaDeviceStatus(FuotaDeviceStatus fuotaDeviceStatus);

        /**
         * <p>
         * The status of the wireless device in the multicast group.
         * </p>
         * 
         * @param multicastDeviceStatus
         *        The status of the wireless device in the multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastDeviceStatus(String multicastDeviceStatus);

        /**
         * Sets the value of the McGroupId property for this object.
         *
         * @param mcGroupId
         *        The new value for the McGroupId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcGroupId(Integer mcGroupId);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String type;

        private String name;

        private String destinationName;

        private String lastUplinkReceivedAt;

        private LoRaWANListDevice loRaWAN;

        private SidewalkListDevice sidewalk;

        private String fuotaDeviceStatus;

        private String multicastDeviceStatus;

        private Integer mcGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(WirelessDeviceStatistics model) {
            arn(model.arn);
            id(model.id);
            type(model.type);
            name(model.name);
            destinationName(model.destinationName);
            lastUplinkReceivedAt(model.lastUplinkReceivedAt);
            loRaWAN(model.loRaWAN);
            sidewalk(model.sidewalk);
            fuotaDeviceStatus(model.fuotaDeviceStatus);
            multicastDeviceStatus(model.multicastDeviceStatus);
            mcGroupId(model.mcGroupId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WirelessDeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getLastUplinkReceivedAt() {
            return lastUplinkReceivedAt;
        }

        public final void setLastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
        }

        @Override
        public final Builder lastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        public final LoRaWANListDevice.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANListDevice.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANListDevice loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final SidewalkListDevice.Builder getSidewalk() {
            return sidewalk != null ? sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkListDevice.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkListDevice sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final String getFuotaDeviceStatus() {
            return fuotaDeviceStatus;
        }

        public final void setFuotaDeviceStatus(String fuotaDeviceStatus) {
            this.fuotaDeviceStatus = fuotaDeviceStatus;
        }

        @Override
        public final Builder fuotaDeviceStatus(String fuotaDeviceStatus) {
            this.fuotaDeviceStatus = fuotaDeviceStatus;
            return this;
        }

        @Override
        public final Builder fuotaDeviceStatus(FuotaDeviceStatus fuotaDeviceStatus) {
            this.fuotaDeviceStatus(fuotaDeviceStatus == null ? null : fuotaDeviceStatus.toString());
            return this;
        }

        public final String getMulticastDeviceStatus() {
            return multicastDeviceStatus;
        }

        public final void setMulticastDeviceStatus(String multicastDeviceStatus) {
            this.multicastDeviceStatus = multicastDeviceStatus;
        }

        @Override
        public final Builder multicastDeviceStatus(String multicastDeviceStatus) {
            this.multicastDeviceStatus = multicastDeviceStatus;
            return this;
        }

        public final Integer getMcGroupId() {
            return mcGroupId;
        }

        public final void setMcGroupId(Integer mcGroupId) {
            this.mcGroupId = mcGroupId;
        }

        @Override
        public final Builder mcGroupId(Integer mcGroupId) {
            this.mcGroupId = mcGroupId;
            return this;
        }

        @Override
        public WirelessDeviceStatistics build() {
            return new WirelessDeviceStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
