/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Beaconing parameters for configuring the wireless gateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Beaconing implements SdkPojo, Serializable, ToCopyableBuilder<Beaconing.Builder, Beaconing> {
    private static final SdkField<Integer> DATA_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataRate").getter(getter(Beaconing::dataRate)).setter(setter(Builder::dataRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRate").build()).build();

    private static final SdkField<List<Integer>> FREQUENCIES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Frequencies")
            .getter(getter(Beaconing::frequencies))
            .setter(setter(Builder::frequencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_RATE_FIELD,
            FREQUENCIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dataRate;

    private final List<Integer> frequencies;

    private Beaconing(BuilderImpl builder) {
        this.dataRate = builder.dataRate;
        this.frequencies = builder.frequencies;
    }

    /**
     * <p>
     * The data rate for gateways that are sending the beacons.
     * </p>
     * 
     * @return The data rate for gateways that are sending the beacons.
     */
    public final Integer dataRate() {
        return dataRate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Frequencies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFrequencies() {
        return frequencies != null && !(frequencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The frequency list for the gateways to send the beacons.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFrequencies} method.
     * </p>
     * 
     * @return The frequency list for the gateways to send the beacons.
     */
    public final List<Integer> frequencies() {
        return frequencies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataRate());
        hashCode = 31 * hashCode + Objects.hashCode(hasFrequencies() ? frequencies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Beaconing)) {
            return false;
        }
        Beaconing other = (Beaconing) obj;
        return Objects.equals(dataRate(), other.dataRate()) && hasFrequencies() == other.hasFrequencies()
                && Objects.equals(frequencies(), other.frequencies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Beaconing").add("DataRate", dataRate())
                .add("Frequencies", hasFrequencies() ? frequencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataRate":
            return Optional.ofNullable(clazz.cast(dataRate()));
        case "Frequencies":
            return Optional.ofNullable(clazz.cast(frequencies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataRate", DATA_RATE_FIELD);
        map.put("Frequencies", FREQUENCIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Beaconing, T> g) {
        return obj -> g.apply((Beaconing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Beaconing> {
        /**
         * <p>
         * The data rate for gateways that are sending the beacons.
         * </p>
         * 
         * @param dataRate
         *        The data rate for gateways that are sending the beacons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRate(Integer dataRate);

        /**
         * <p>
         * The frequency list for the gateways to send the beacons.
         * </p>
         * 
         * @param frequencies
         *        The frequency list for the gateways to send the beacons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequencies(Collection<Integer> frequencies);

        /**
         * <p>
         * The frequency list for the gateways to send the beacons.
         * </p>
         * 
         * @param frequencies
         *        The frequency list for the gateways to send the beacons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequencies(Integer... frequencies);
    }

    static final class BuilderImpl implements Builder {
        private Integer dataRate;

        private List<Integer> frequencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Beaconing model) {
            dataRate(model.dataRate);
            frequencies(model.frequencies);
        }

        public final Integer getDataRate() {
            return dataRate;
        }

        public final void setDataRate(Integer dataRate) {
            this.dataRate = dataRate;
        }

        @Override
        public final Builder dataRate(Integer dataRate) {
            this.dataRate = dataRate;
            return this;
        }

        public final Collection<Integer> getFrequencies() {
            if (frequencies instanceof SdkAutoConstructList) {
                return null;
            }
            return frequencies;
        }

        public final void setFrequencies(Collection<Integer> frequencies) {
            this.frequencies = BeaconingFrequenciesCopier.copy(frequencies);
        }

        @Override
        public final Builder frequencies(Collection<Integer> frequencies) {
            this.frequencies = BeaconingFrequenciesCopier.copy(frequencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frequencies(Integer... frequencies) {
            frequencies(Arrays.asList(frequencies));
            return this;
        }

        @Override
        public Beaconing build() {
            return new Beaconing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
