/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CDMA object for network measurement reports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CdmaNmrObj implements SdkPojo, Serializable, ToCopyableBuilder<CdmaNmrObj.Builder, CdmaNmrObj> {
    private static final SdkField<Integer> PN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PnOffset").getter(getter(CdmaNmrObj::pnOffset)).setter(setter(Builder::pnOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PnOffset").build()).build();

    private static final SdkField<Integer> CDMA_CHANNEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CdmaChannel").getter(getter(CdmaNmrObj::cdmaChannel)).setter(setter(Builder::cdmaChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdmaChannel").build()).build();

    private static final SdkField<Integer> PILOT_POWER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PilotPower").getter(getter(CdmaNmrObj::pilotPower)).setter(setter(Builder::pilotPower))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PilotPower").build()).build();

    private static final SdkField<Integer> BASE_STATION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BaseStationId").getter(getter(CdmaNmrObj::baseStationId)).setter(setter(Builder::baseStationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseStationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PN_OFFSET_FIELD,
            CDMA_CHANNEL_FIELD, PILOT_POWER_FIELD, BASE_STATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer pnOffset;

    private final Integer cdmaChannel;

    private final Integer pilotPower;

    private final Integer baseStationId;

    private CdmaNmrObj(BuilderImpl builder) {
        this.pnOffset = builder.pnOffset;
        this.cdmaChannel = builder.cdmaChannel;
        this.pilotPower = builder.pilotPower;
        this.baseStationId = builder.baseStationId;
    }

    /**
     * <p>
     * Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.
     * </p>
     * 
     * @return Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.
     */
    public final Integer pnOffset() {
        return pnOffset;
    }

    /**
     * <p>
     * CDMA channel information.
     * </p>
     * 
     * @return CDMA channel information.
     */
    public final Integer cdmaChannel() {
        return cdmaChannel;
    }

    /**
     * <p>
     * Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
     * </p>
     * 
     * @return Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
     */
    public final Integer pilotPower() {
        return pilotPower;
    }

    /**
     * <p>
     * CDMA base station ID (BSID).
     * </p>
     * 
     * @return CDMA base station ID (BSID).
     */
    public final Integer baseStationId() {
        return baseStationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pnOffset());
        hashCode = 31 * hashCode + Objects.hashCode(cdmaChannel());
        hashCode = 31 * hashCode + Objects.hashCode(pilotPower());
        hashCode = 31 * hashCode + Objects.hashCode(baseStationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CdmaNmrObj)) {
            return false;
        }
        CdmaNmrObj other = (CdmaNmrObj) obj;
        return Objects.equals(pnOffset(), other.pnOffset()) && Objects.equals(cdmaChannel(), other.cdmaChannel())
                && Objects.equals(pilotPower(), other.pilotPower()) && Objects.equals(baseStationId(), other.baseStationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CdmaNmrObj").add("PnOffset", pnOffset()).add("CdmaChannel", cdmaChannel())
                .add("PilotPower", pilotPower()).add("BaseStationId", baseStationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PnOffset":
            return Optional.ofNullable(clazz.cast(pnOffset()));
        case "CdmaChannel":
            return Optional.ofNullable(clazz.cast(cdmaChannel()));
        case "PilotPower":
            return Optional.ofNullable(clazz.cast(pilotPower()));
        case "BaseStationId":
            return Optional.ofNullable(clazz.cast(baseStationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PnOffset", PN_OFFSET_FIELD);
        map.put("CdmaChannel", CDMA_CHANNEL_FIELD);
        map.put("PilotPower", PILOT_POWER_FIELD);
        map.put("BaseStationId", BASE_STATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CdmaNmrObj, T> g) {
        return obj -> g.apply((CdmaNmrObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CdmaNmrObj> {
        /**
         * <p>
         * Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.
         * </p>
         * 
         * @param pnOffset
         *        Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pnOffset(Integer pnOffset);

        /**
         * <p>
         * CDMA channel information.
         * </p>
         * 
         * @param cdmaChannel
         *        CDMA channel information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdmaChannel(Integer cdmaChannel);

        /**
         * <p>
         * Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
         * </p>
         * 
         * @param pilotPower
         *        Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pilotPower(Integer pilotPower);

        /**
         * <p>
         * CDMA base station ID (BSID).
         * </p>
         * 
         * @param baseStationId
         *        CDMA base station ID (BSID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseStationId(Integer baseStationId);
    }

    static final class BuilderImpl implements Builder {
        private Integer pnOffset;

        private Integer cdmaChannel;

        private Integer pilotPower;

        private Integer baseStationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CdmaNmrObj model) {
            pnOffset(model.pnOffset);
            cdmaChannel(model.cdmaChannel);
            pilotPower(model.pilotPower);
            baseStationId(model.baseStationId);
        }

        public final Integer getPnOffset() {
            return pnOffset;
        }

        public final void setPnOffset(Integer pnOffset) {
            this.pnOffset = pnOffset;
        }

        @Override
        public final Builder pnOffset(Integer pnOffset) {
            this.pnOffset = pnOffset;
            return this;
        }

        public final Integer getCdmaChannel() {
            return cdmaChannel;
        }

        public final void setCdmaChannel(Integer cdmaChannel) {
            this.cdmaChannel = cdmaChannel;
        }

        @Override
        public final Builder cdmaChannel(Integer cdmaChannel) {
            this.cdmaChannel = cdmaChannel;
            return this;
        }

        public final Integer getPilotPower() {
            return pilotPower;
        }

        public final void setPilotPower(Integer pilotPower) {
            this.pilotPower = pilotPower;
        }

        @Override
        public final Builder pilotPower(Integer pilotPower) {
            this.pilotPower = pilotPower;
            return this;
        }

        public final Integer getBaseStationId() {
            return baseStationId;
        }

        public final void setBaseStationId(Integer baseStationId) {
            this.baseStationId = baseStationId;
        }

        @Override
        public final Builder baseStationId(Integer baseStationId) {
            this.baseStationId = baseStationId;
            return this;
        }

        @Override
        public CdmaNmrObj build() {
            return new CdmaNmrObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
