/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cell towers that were used to perform the measurements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CellTowers implements SdkPojo, Serializable, ToCopyableBuilder<CellTowers.Builder, CellTowers> {
    private static final SdkField<List<GsmObj>> GSM_FIELD = SdkField
            .<List<GsmObj>> builder(MarshallingType.LIST)
            .memberName("Gsm")
            .getter(getter(CellTowers::gsm))
            .setter(setter(Builder::gsm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gsm").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GsmObj> builder(MarshallingType.SDK_POJO)
                                            .constructor(GsmObj::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WcdmaObj>> WCDMA_FIELD = SdkField
            .<List<WcdmaObj>> builder(MarshallingType.LIST)
            .memberName("Wcdma")
            .getter(getter(CellTowers::wcdma))
            .setter(setter(Builder::wcdma))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Wcdma").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WcdmaObj> builder(MarshallingType.SDK_POJO)
                                            .constructor(WcdmaObj::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TdscdmaObj>> TDSCDMA_FIELD = SdkField
            .<List<TdscdmaObj>> builder(MarshallingType.LIST)
            .memberName("Tdscdma")
            .getter(getter(CellTowers::tdscdma))
            .setter(setter(Builder::tdscdma))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tdscdma").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TdscdmaObj> builder(MarshallingType.SDK_POJO)
                                            .constructor(TdscdmaObj::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LteObj>> LTE_FIELD = SdkField
            .<List<LteObj>> builder(MarshallingType.LIST)
            .memberName("Lte")
            .getter(getter(CellTowers::lte))
            .setter(setter(Builder::lte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lte").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LteObj> builder(MarshallingType.SDK_POJO)
                                            .constructor(LteObj::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CdmaObj>> CDMA_FIELD = SdkField
            .<List<CdmaObj>> builder(MarshallingType.LIST)
            .memberName("Cdma")
            .getter(getter(CellTowers::cdma))
            .setter(setter(Builder::cdma))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cdma").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CdmaObj> builder(MarshallingType.SDK_POJO)
                                            .constructor(CdmaObj::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GSM_FIELD, WCDMA_FIELD,
            TDSCDMA_FIELD, LTE_FIELD, CDMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GsmObj> gsm;

    private final List<WcdmaObj> wcdma;

    private final List<TdscdmaObj> tdscdma;

    private final List<LteObj> lte;

    private final List<CdmaObj> cdma;

    private CellTowers(BuilderImpl builder) {
        this.gsm = builder.gsm;
        this.wcdma = builder.wcdma;
        this.tdscdma = builder.tdscdma;
        this.lte = builder.lte;
        this.cdma = builder.cdma;
    }

    /**
     * For responses, this returns true if the service returned a value for the Gsm property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasGsm() {
        return gsm != null && !(gsm instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * GSM object information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGsm} method.
     * </p>
     * 
     * @return GSM object information.
     */
    public final List<GsmObj> gsm() {
        return gsm;
    }

    /**
     * For responses, this returns true if the service returned a value for the Wcdma property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasWcdma() {
        return wcdma != null && !(wcdma instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * WCDMA object information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWcdma} method.
     * </p>
     * 
     * @return WCDMA object information.
     */
    public final List<WcdmaObj> wcdma() {
        return wcdma;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tdscdma property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTdscdma() {
        return tdscdma != null && !(tdscdma instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * TD-SCDMA object information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTdscdma} method.
     * </p>
     * 
     * @return TD-SCDMA object information.
     */
    public final List<TdscdmaObj> tdscdma() {
        return tdscdma;
    }

    /**
     * For responses, this returns true if the service returned a value for the Lte property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLte() {
        return lte != null && !(lte instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * LTE object information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLte} method.
     * </p>
     * 
     * @return LTE object information.
     */
    public final List<LteObj> lte() {
        return lte;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cdma property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCdma() {
        return cdma != null && !(cdma instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * CDMA object information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCdma} method.
     * </p>
     * 
     * @return CDMA object information.
     */
    public final List<CdmaObj> cdma() {
        return cdma;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGsm() ? gsm() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWcdma() ? wcdma() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTdscdma() ? tdscdma() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLte() ? lte() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCdma() ? cdma() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellTowers)) {
            return false;
        }
        CellTowers other = (CellTowers) obj;
        return hasGsm() == other.hasGsm() && Objects.equals(gsm(), other.gsm()) && hasWcdma() == other.hasWcdma()
                && Objects.equals(wcdma(), other.wcdma()) && hasTdscdma() == other.hasTdscdma()
                && Objects.equals(tdscdma(), other.tdscdma()) && hasLte() == other.hasLte() && Objects.equals(lte(), other.lte())
                && hasCdma() == other.hasCdma() && Objects.equals(cdma(), other.cdma());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CellTowers").add("Gsm", hasGsm() ? gsm() : null).add("Wcdma", hasWcdma() ? wcdma() : null)
                .add("Tdscdma", hasTdscdma() ? tdscdma() : null).add("Lte", hasLte() ? lte() : null)
                .add("Cdma", hasCdma() ? cdma() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gsm":
            return Optional.ofNullable(clazz.cast(gsm()));
        case "Wcdma":
            return Optional.ofNullable(clazz.cast(wcdma()));
        case "Tdscdma":
            return Optional.ofNullable(clazz.cast(tdscdma()));
        case "Lte":
            return Optional.ofNullable(clazz.cast(lte()));
        case "Cdma":
            return Optional.ofNullable(clazz.cast(cdma()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Gsm", GSM_FIELD);
        map.put("Wcdma", WCDMA_FIELD);
        map.put("Tdscdma", TDSCDMA_FIELD);
        map.put("Lte", LTE_FIELD);
        map.put("Cdma", CDMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CellTowers, T> g) {
        return obj -> g.apply((CellTowers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CellTowers> {
        /**
         * <p>
         * GSM object information.
         * </p>
         * 
         * @param gsm
         *        GSM object information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gsm(Collection<GsmObj> gsm);

        /**
         * <p>
         * GSM object information.
         * </p>
         * 
         * @param gsm
         *        GSM object information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gsm(GsmObj... gsm);

        /**
         * <p>
         * GSM object information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.GsmObj.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.GsmObj#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.GsmObj.Builder#build()} is called immediately and
         * its result is passed to {@link #gsm(List<GsmObj>)}.
         * 
         * @param gsm
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.GsmObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gsm(java.util.Collection<GsmObj>)
         */
        Builder gsm(Consumer<GsmObj.Builder>... gsm);

        /**
         * <p>
         * WCDMA object information.
         * </p>
         * 
         * @param wcdma
         *        WCDMA object information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wcdma(Collection<WcdmaObj> wcdma);

        /**
         * <p>
         * WCDMA object information.
         * </p>
         * 
         * @param wcdma
         *        WCDMA object information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wcdma(WcdmaObj... wcdma);

        /**
         * <p>
         * WCDMA object information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.WcdmaObj.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.WcdmaObj#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.WcdmaObj.Builder#build()} is called immediately and
         * its result is passed to {@link #wcdma(List<WcdmaObj>)}.
         * 
         * @param wcdma
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.WcdmaObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wcdma(java.util.Collection<WcdmaObj>)
         */
        Builder wcdma(Consumer<WcdmaObj.Builder>... wcdma);

        /**
         * <p>
         * TD-SCDMA object information.
         * </p>
         * 
         * @param tdscdma
         *        TD-SCDMA object information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdscdma(Collection<TdscdmaObj> tdscdma);

        /**
         * <p>
         * TD-SCDMA object information.
         * </p>
         * 
         * @param tdscdma
         *        TD-SCDMA object information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdscdma(TdscdmaObj... tdscdma);

        /**
         * <p>
         * TD-SCDMA object information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.TdscdmaObj.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.TdscdmaObj#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.TdscdmaObj.Builder#build()} is called immediately
         * and its result is passed to {@link #tdscdma(List<TdscdmaObj>)}.
         * 
         * @param tdscdma
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.TdscdmaObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tdscdma(java.util.Collection<TdscdmaObj>)
         */
        Builder tdscdma(Consumer<TdscdmaObj.Builder>... tdscdma);

        /**
         * <p>
         * LTE object information.
         * </p>
         * 
         * @param lte
         *        LTE object information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lte(Collection<LteObj> lte);

        /**
         * <p>
         * LTE object information.
         * </p>
         * 
         * @param lte
         *        LTE object information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lte(LteObj... lte);

        /**
         * <p>
         * LTE object information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.LteObj.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.LteObj#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.LteObj.Builder#build()} is called immediately and
         * its result is passed to {@link #lte(List<LteObj>)}.
         * 
         * @param lte
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.LteObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lte(java.util.Collection<LteObj>)
         */
        Builder lte(Consumer<LteObj.Builder>... lte);

        /**
         * <p>
         * CDMA object information.
         * </p>
         * 
         * @param cdma
         *        CDMA object information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdma(Collection<CdmaObj> cdma);

        /**
         * <p>
         * CDMA object information.
         * </p>
         * 
         * @param cdma
         *        CDMA object information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdma(CdmaObj... cdma);

        /**
         * <p>
         * CDMA object information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.CdmaObj.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.CdmaObj#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.CdmaObj.Builder#build()} is called immediately and
         * its result is passed to {@link #cdma(List<CdmaObj>)}.
         * 
         * @param cdma
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.CdmaObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cdma(java.util.Collection<CdmaObj>)
         */
        Builder cdma(Consumer<CdmaObj.Builder>... cdma);
    }

    static final class BuilderImpl implements Builder {
        private List<GsmObj> gsm = DefaultSdkAutoConstructList.getInstance();

        private List<WcdmaObj> wcdma = DefaultSdkAutoConstructList.getInstance();

        private List<TdscdmaObj> tdscdma = DefaultSdkAutoConstructList.getInstance();

        private List<LteObj> lte = DefaultSdkAutoConstructList.getInstance();

        private List<CdmaObj> cdma = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CellTowers model) {
            gsm(model.gsm);
            wcdma(model.wcdma);
            tdscdma(model.tdscdma);
            lte(model.lte);
            cdma(model.cdma);
        }

        public final List<GsmObj.Builder> getGsm() {
            List<GsmObj.Builder> result = GsmListCopier.copyToBuilder(this.gsm);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGsm(Collection<GsmObj.BuilderImpl> gsm) {
            this.gsm = GsmListCopier.copyFromBuilder(gsm);
        }

        @Override
        public final Builder gsm(Collection<GsmObj> gsm) {
            this.gsm = GsmListCopier.copy(gsm);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gsm(GsmObj... gsm) {
            gsm(Arrays.asList(gsm));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gsm(Consumer<GsmObj.Builder>... gsm) {
            gsm(Stream.of(gsm).map(c -> GsmObj.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WcdmaObj.Builder> getWcdma() {
            List<WcdmaObj.Builder> result = WcdmaListCopier.copyToBuilder(this.wcdma);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWcdma(Collection<WcdmaObj.BuilderImpl> wcdma) {
            this.wcdma = WcdmaListCopier.copyFromBuilder(wcdma);
        }

        @Override
        public final Builder wcdma(Collection<WcdmaObj> wcdma) {
            this.wcdma = WcdmaListCopier.copy(wcdma);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wcdma(WcdmaObj... wcdma) {
            wcdma(Arrays.asList(wcdma));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wcdma(Consumer<WcdmaObj.Builder>... wcdma) {
            wcdma(Stream.of(wcdma).map(c -> WcdmaObj.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TdscdmaObj.Builder> getTdscdma() {
            List<TdscdmaObj.Builder> result = TdscdmaListCopier.copyToBuilder(this.tdscdma);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTdscdma(Collection<TdscdmaObj.BuilderImpl> tdscdma) {
            this.tdscdma = TdscdmaListCopier.copyFromBuilder(tdscdma);
        }

        @Override
        public final Builder tdscdma(Collection<TdscdmaObj> tdscdma) {
            this.tdscdma = TdscdmaListCopier.copy(tdscdma);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tdscdma(TdscdmaObj... tdscdma) {
            tdscdma(Arrays.asList(tdscdma));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tdscdma(Consumer<TdscdmaObj.Builder>... tdscdma) {
            tdscdma(Stream.of(tdscdma).map(c -> TdscdmaObj.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LteObj.Builder> getLte() {
            List<LteObj.Builder> result = LteListCopier.copyToBuilder(this.lte);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLte(Collection<LteObj.BuilderImpl> lte) {
            this.lte = LteListCopier.copyFromBuilder(lte);
        }

        @Override
        public final Builder lte(Collection<LteObj> lte) {
            this.lte = LteListCopier.copy(lte);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lte(LteObj... lte) {
            lte(Arrays.asList(lte));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lte(Consumer<LteObj.Builder>... lte) {
            lte(Stream.of(lte).map(c -> LteObj.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CdmaObj.Builder> getCdma() {
            List<CdmaObj.Builder> result = CdmaListCopier.copyToBuilder(this.cdma);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCdma(Collection<CdmaObj.BuilderImpl> cdma) {
            this.cdma = CdmaListCopier.copyFromBuilder(cdma);
        }

        @Override
        public final Builder cdma(Collection<CdmaObj> cdma) {
            this.cdma = CdmaListCopier.copy(cdma);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cdma(CdmaObj... cdma) {
            cdma(Arrays.asList(cdma));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cdma(Consumer<CdmaObj.Builder>... cdma) {
            cdma(Stream.of(cdma).map(c -> CdmaObj.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CellTowers build() {
            return new CellTowers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
