/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Connection status event configuration object for enabling or disabling topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionStatusEventConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionStatusEventConfiguration.Builder, ConnectionStatusEventConfiguration> {
    private static final SdkField<LoRaWANConnectionStatusEventNotificationConfigurations> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANConnectionStatusEventNotificationConfigurations> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(ConnectionStatusEventConfiguration::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANConnectionStatusEventNotificationConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<String> WIRELESS_GATEWAY_ID_EVENT_TOPIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WirelessGatewayIdEventTopic")
            .getter(getter(ConnectionStatusEventConfiguration::wirelessGatewayIdEventTopicAsString))
            .setter(setter(Builder::wirelessGatewayIdEventTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayIdEventTopic")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LO_RA_WAN_FIELD,
            WIRELESS_GATEWAY_ID_EVENT_TOPIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LoRaWANConnectionStatusEventNotificationConfigurations loRaWAN;

    private final String wirelessGatewayIdEventTopic;

    private ConnectionStatusEventConfiguration(BuilderImpl builder) {
        this.loRaWAN = builder.loRaWAN;
        this.wirelessGatewayIdEventTopic = builder.wirelessGatewayIdEventTopic;
    }

    /**
     * <p>
     * Connection status event configuration object for enabling or disabling LoRaWAN related event topics.
     * </p>
     * 
     * @return Connection status event configuration object for enabling or disabling LoRaWAN related event topics.
     */
    public final LoRaWANConnectionStatusEventNotificationConfigurations loRaWAN() {
        return loRaWAN;
    }

    /**
     * <p>
     * Denotes whether the wireless gateway ID connection status event topic is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessGatewayIdEventTopic} will return {@link EventNotificationTopicStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #wirelessGatewayIdEventTopicAsString}.
     * </p>
     * 
     * @return Denotes whether the wireless gateway ID connection status event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */
    public final EventNotificationTopicStatus wirelessGatewayIdEventTopic() {
        return EventNotificationTopicStatus.fromValue(wirelessGatewayIdEventTopic);
    }

    /**
     * <p>
     * Denotes whether the wireless gateway ID connection status event topic is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessGatewayIdEventTopic} will return {@link EventNotificationTopicStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #wirelessGatewayIdEventTopicAsString}.
     * </p>
     * 
     * @return Denotes whether the wireless gateway ID connection status event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */
    public final String wirelessGatewayIdEventTopicAsString() {
        return wirelessGatewayIdEventTopic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(wirelessGatewayIdEventTopicAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionStatusEventConfiguration)) {
            return false;
        }
        ConnectionStatusEventConfiguration other = (ConnectionStatusEventConfiguration) obj;
        return Objects.equals(loRaWAN(), other.loRaWAN())
                && Objects.equals(wirelessGatewayIdEventTopicAsString(), other.wirelessGatewayIdEventTopicAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionStatusEventConfiguration").add("LoRaWAN", loRaWAN())
                .add("WirelessGatewayIdEventTopic", wirelessGatewayIdEventTopicAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "WirelessGatewayIdEventTopic":
            return Optional.ofNullable(clazz.cast(wirelessGatewayIdEventTopicAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LoRaWAN", LO_RA_WAN_FIELD);
        map.put("WirelessGatewayIdEventTopic", WIRELESS_GATEWAY_ID_EVENT_TOPIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionStatusEventConfiguration, T> g) {
        return obj -> g.apply((ConnectionStatusEventConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionStatusEventConfiguration> {
        /**
         * <p>
         * Connection status event configuration object for enabling or disabling LoRaWAN related event topics.
         * </p>
         * 
         * @param loRaWAN
         *        Connection status event configuration object for enabling or disabling LoRaWAN related event topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANConnectionStatusEventNotificationConfigurations loRaWAN);

        /**
         * <p>
         * Connection status event configuration object for enabling or disabling LoRaWAN related event topics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LoRaWANConnectionStatusEventNotificationConfigurations.Builder} avoiding the need to create one
         * manually via {@link LoRaWANConnectionStatusEventNotificationConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link LoRaWANConnectionStatusEventNotificationConfigurations.Builder#build()} is called immediately and its
         * result is passed to {@link #loRaWAN(LoRaWANConnectionStatusEventNotificationConfigurations)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on
         *        {@link LoRaWANConnectionStatusEventNotificationConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANConnectionStatusEventNotificationConfigurations)
         */
        default Builder loRaWAN(Consumer<LoRaWANConnectionStatusEventNotificationConfigurations.Builder> loRaWAN) {
            return loRaWAN(LoRaWANConnectionStatusEventNotificationConfigurations.builder().applyMutation(loRaWAN).build());
        }

        /**
         * <p>
         * Denotes whether the wireless gateway ID connection status event topic is enabled or disabled.
         * </p>
         * 
         * @param wirelessGatewayIdEventTopic
         *        Denotes whether the wireless gateway ID connection status event topic is enabled or disabled.
         * @see EventNotificationTopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationTopicStatus
         */
        Builder wirelessGatewayIdEventTopic(String wirelessGatewayIdEventTopic);

        /**
         * <p>
         * Denotes whether the wireless gateway ID connection status event topic is enabled or disabled.
         * </p>
         * 
         * @param wirelessGatewayIdEventTopic
         *        Denotes whether the wireless gateway ID connection status event topic is enabled or disabled.
         * @see EventNotificationTopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationTopicStatus
         */
        Builder wirelessGatewayIdEventTopic(EventNotificationTopicStatus wirelessGatewayIdEventTopic);
    }

    static final class BuilderImpl implements Builder {
        private LoRaWANConnectionStatusEventNotificationConfigurations loRaWAN;

        private String wirelessGatewayIdEventTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionStatusEventConfiguration model) {
            loRaWAN(model.loRaWAN);
            wirelessGatewayIdEventTopic(model.wirelessGatewayIdEventTopic);
        }

        public final LoRaWANConnectionStatusEventNotificationConfigurations.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANConnectionStatusEventNotificationConfigurations.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANConnectionStatusEventNotificationConfigurations loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getWirelessGatewayIdEventTopic() {
            return wirelessGatewayIdEventTopic;
        }

        public final void setWirelessGatewayIdEventTopic(String wirelessGatewayIdEventTopic) {
            this.wirelessGatewayIdEventTopic = wirelessGatewayIdEventTopic;
        }

        @Override
        public final Builder wirelessGatewayIdEventTopic(String wirelessGatewayIdEventTopic) {
            this.wirelessGatewayIdEventTopic = wirelessGatewayIdEventTopic;
            return this;
        }

        @Override
        public final Builder wirelessGatewayIdEventTopic(EventNotificationTopicStatus wirelessGatewayIdEventTopic) {
            this.wirelessGatewayIdEventTopic(wirelessGatewayIdEventTopic == null ? null : wirelessGatewayIdEventTopic.toString());
            return this;
        }

        @Override
        public ConnectionStatusEventConfiguration build() {
            return new ConnectionStatusEventConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
