/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceProfileRequest extends IotWirelessRequest implements
        ToCopyableBuilder<CreateServiceProfileRequest.Builder, CreateServiceProfileRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateServiceProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<LoRaWANServiceProfile> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANServiceProfile> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(CreateServiceProfileRequest::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANServiceProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateServiceProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateServiceProfileRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LO_RA_WAN_FIELD,
            TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final LoRaWANServiceProfile loRaWAN;

    private final List<Tag> tags;

    private final String clientRequestToken;

    private CreateServiceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.loRaWAN = builder.loRaWAN;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the new resource.
     * </p>
     * <note>
     * <p>
     * The following special characters aren't accepted: <code>&lt;&gt;^#~$</code>
     * </p>
     * </note>
     * 
     * @return The name of the new resource.</p> <note>
     *         <p>
     *         The following special characters aren't accepted: <code>&lt;&gt;^#~$</code>
     *         </p>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The service profile information to use to create the service profile.
     * </p>
     * 
     * @return The service profile information to use to create the service profile.
     */
    public final LoRaWANServiceProfile loRaWAN() {
        return loRaWAN;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Each resource must have a unique client request token. The client token is used to implement idempotency. It
     * ensures that the request completes no more than one time. If you retry a request with the same token and the same
     * parameters, the request will complete successfully. However, if you try to create a new resource using the same
     * token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically
     * generate a unique client request. For more information about idempotency, see <a
     * href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in Amazon
     * EC2 API requests</a>.
     * </p>
     * 
     * @return Each resource must have a unique client request token. The client token is used to implement idempotency.
     *         It ensures that the request completes no more than one time. If you retry a request with the same token
     *         and the same parameters, the request will complete successfully. However, if you try to create a new
     *         resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this
     *         value, AWS SDKs will automatically generate a unique client request. For more information about
     *         idempotency, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in
     *         Amazon EC2 API requests</a>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceProfileRequest)) {
            return false;
        }
        CreateServiceProfileRequest other = (CreateServiceProfileRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(loRaWAN(), other.loRaWAN()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceProfileRequest").add("Name", name()).add("LoRaWAN", loRaWAN())
                .add("Tags", hasTags() ? tags() : null).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("LoRaWAN", LO_RA_WAN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceProfileRequest, T> g) {
        return obj -> g.apply((CreateServiceProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceProfileRequest> {
        /**
         * <p>
         * The name of the new resource.
         * </p>
         * <note>
         * <p>
         * The following special characters aren't accepted: <code>&lt;&gt;^#~$</code>
         * </p>
         * </note>
         * 
         * @param name
         *        The name of the new resource.</p> <note>
         *        <p>
         *        The following special characters aren't accepted: <code>&lt;&gt;^#~$</code>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The service profile information to use to create the service profile.
         * </p>
         * 
         * @param loRaWAN
         *        The service profile information to use to create the service profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANServiceProfile loRaWAN);

        /**
         * <p>
         * The service profile information to use to create the service profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoRaWANServiceProfile.Builder} avoiding
         * the need to create one manually via {@link LoRaWANServiceProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoRaWANServiceProfile.Builder#build()} is called immediately and
         * its result is passed to {@link #loRaWAN(LoRaWANServiceProfile)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANServiceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANServiceProfile)
         */
        default Builder loRaWAN(Consumer<LoRaWANServiceProfile.Builder> loRaWAN) {
            return loRaWAN(LoRaWANServiceProfile.builder().applyMutation(loRaWAN).build());
        }

        /**
         * <p>
         * The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.
         * </p>
         * 
         * @param tags
         *        The tags to attach to the new service profile. Tags are metadata that you can use to manage a
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.
         * </p>
         * 
         * @param tags
         *        The tags to attach to the new service profile. Tags are metadata that you can use to manage a
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Each resource must have a unique client request token. The client token is used to implement idempotency. It
         * ensures that the request completes no more than one time. If you retry a request with the same token and the
         * same parameters, the request will complete successfully. However, if you try to create a new resource using
         * the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will
         * automatically generate a unique client request. For more information about idempotency, see <a
         * href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency in
         * Amazon EC2 API requests</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        Each resource must have a unique client request token. The client token is used to implement
         *        idempotency. It ensures that the request completes no more than one time. If you retry a request with
         *        the same token and the same parameters, the request will complete successfully. However, if you try to
         *        create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If
         *        you omit this value, AWS SDKs will automatically generate a unique client request. For more
         *        information about idempotency, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency
         *        in Amazon EC2 API requests</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String name;

        private LoRaWANServiceProfile loRaWAN;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceProfileRequest model) {
            super(model);
            name(model.name);
            loRaWAN(model.loRaWAN);
            tags(model.tags);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final LoRaWANServiceProfile.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANServiceProfile.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANServiceProfile loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceProfileRequest build() {
            return new CreateServiceProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
