/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Event configuration object for a single resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventConfigurationItem implements SdkPojo, Serializable,
        ToCopyableBuilder<EventConfigurationItem.Builder, EventConfigurationItem> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(EventConfigurationItem::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> IDENTIFIER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentifierType").getter(getter(EventConfigurationItem::identifierTypeAsString))
            .setter(setter(Builder::identifierType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifierType").build()).build();

    private static final SdkField<String> PARTNER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartnerType").getter(getter(EventConfigurationItem::partnerTypeAsString))
            .setter(setter(Builder::partnerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerType").build()).build();

    private static final SdkField<EventNotificationItemConfigurations> EVENTS_FIELD = SdkField
            .<EventNotificationItemConfigurations> builder(MarshallingType.SDK_POJO).memberName("Events")
            .getter(getter(EventConfigurationItem::events)).setter(setter(Builder::events))
            .constructor(EventNotificationItemConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            IDENTIFIER_TYPE_FIELD, PARTNER_TYPE_FIELD, EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String identifierType;

    private final String partnerType;

    private final EventNotificationItemConfigurations events;

    private EventConfigurationItem(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.identifierType = builder.identifierType;
        this.partnerType = builder.partnerType;
        this.events = builder.events;
    }

    /**
     * <p>
     * Resource identifier opted in for event messaging.
     * </p>
     * 
     * @return Resource identifier opted in for event messaging.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Identifier type of the particular resource identifier for event configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identifierType}
     * will return {@link IdentifierType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #identifierTypeAsString}.
     * </p>
     * 
     * @return Identifier type of the particular resource identifier for event configuration.
     * @see IdentifierType
     */
    public final IdentifierType identifierType() {
        return IdentifierType.fromValue(identifierType);
    }

    /**
     * <p>
     * Identifier type of the particular resource identifier for event configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identifierType}
     * will return {@link IdentifierType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #identifierTypeAsString}.
     * </p>
     * 
     * @return Identifier type of the particular resource identifier for event configuration.
     * @see IdentifierType
     */
    public final String identifierTypeAsString() {
        return identifierType;
    }

    /**
     * <p>
     * Partner type of the resource if the identifier type is PartnerAccountId.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partnerType} will
     * return {@link EventNotificationPartnerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #partnerTypeAsString}.
     * </p>
     * 
     * @return Partner type of the resource if the identifier type is PartnerAccountId.
     * @see EventNotificationPartnerType
     */
    public final EventNotificationPartnerType partnerType() {
        return EventNotificationPartnerType.fromValue(partnerType);
    }

    /**
     * <p>
     * Partner type of the resource if the identifier type is PartnerAccountId.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partnerType} will
     * return {@link EventNotificationPartnerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #partnerTypeAsString}.
     * </p>
     * 
     * @return Partner type of the resource if the identifier type is PartnerAccountId.
     * @see EventNotificationPartnerType
     */
    public final String partnerTypeAsString() {
        return partnerType;
    }

    /**
     * Returns the value of the Events property for this object.
     * 
     * @return The value of the Events property for this object.
     */
    public final EventNotificationItemConfigurations events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifierTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(partnerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(events());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventConfigurationItem)) {
            return false;
        }
        EventConfigurationItem other = (EventConfigurationItem) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(identifierTypeAsString(), other.identifierTypeAsString())
                && Objects.equals(partnerTypeAsString(), other.partnerTypeAsString()) && Objects.equals(events(), other.events());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventConfigurationItem").add("Identifier", identifier())
                .add("IdentifierType", identifierTypeAsString()).add("PartnerType", partnerTypeAsString())
                .add("Events", events()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "IdentifierType":
            return Optional.ofNullable(clazz.cast(identifierTypeAsString()));
        case "PartnerType":
            return Optional.ofNullable(clazz.cast(partnerTypeAsString()));
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("IdentifierType", IDENTIFIER_TYPE_FIELD);
        map.put("PartnerType", PARTNER_TYPE_FIELD);
        map.put("Events", EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventConfigurationItem, T> g) {
        return obj -> g.apply((EventConfigurationItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventConfigurationItem> {
        /**
         * <p>
         * Resource identifier opted in for event messaging.
         * </p>
         * 
         * @param identifier
         *        Resource identifier opted in for event messaging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Identifier type of the particular resource identifier for event configuration.
         * </p>
         * 
         * @param identifierType
         *        Identifier type of the particular resource identifier for event configuration.
         * @see IdentifierType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentifierType
         */
        Builder identifierType(String identifierType);

        /**
         * <p>
         * Identifier type of the particular resource identifier for event configuration.
         * </p>
         * 
         * @param identifierType
         *        Identifier type of the particular resource identifier for event configuration.
         * @see IdentifierType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentifierType
         */
        Builder identifierType(IdentifierType identifierType);

        /**
         * <p>
         * Partner type of the resource if the identifier type is PartnerAccountId.
         * </p>
         * 
         * @param partnerType
         *        Partner type of the resource if the identifier type is PartnerAccountId.
         * @see EventNotificationPartnerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationPartnerType
         */
        Builder partnerType(String partnerType);

        /**
         * <p>
         * Partner type of the resource if the identifier type is PartnerAccountId.
         * </p>
         * 
         * @param partnerType
         *        Partner type of the resource if the identifier type is PartnerAccountId.
         * @see EventNotificationPartnerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventNotificationPartnerType
         */
        Builder partnerType(EventNotificationPartnerType partnerType);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(EventNotificationItemConfigurations events);

        /**
         * Sets the value of the Events property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link EventNotificationItemConfigurations.Builder} avoiding the need to create one manually via
         * {@link EventNotificationItemConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventNotificationItemConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #events(EventNotificationItemConfigurations)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link EventNotificationItemConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(EventNotificationItemConfigurations)
         */
        default Builder events(Consumer<EventNotificationItemConfigurations.Builder> events) {
            return events(EventNotificationItemConfigurations.builder().applyMutation(events).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String identifierType;

        private String partnerType;

        private EventNotificationItemConfigurations events;

        private BuilderImpl() {
        }

        private BuilderImpl(EventConfigurationItem model) {
            identifier(model.identifier);
            identifierType(model.identifierType);
            partnerType(model.partnerType);
            events(model.events);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getIdentifierType() {
            return identifierType;
        }

        public final void setIdentifierType(String identifierType) {
            this.identifierType = identifierType;
        }

        @Override
        public final Builder identifierType(String identifierType) {
            this.identifierType = identifierType;
            return this;
        }

        @Override
        public final Builder identifierType(IdentifierType identifierType) {
            this.identifierType(identifierType == null ? null : identifierType.toString());
            return this;
        }

        public final String getPartnerType() {
            return partnerType;
        }

        public final void setPartnerType(String partnerType) {
            this.partnerType = partnerType;
        }

        @Override
        public final Builder partnerType(String partnerType) {
            this.partnerType = partnerType;
            return this;
        }

        @Override
        public final Builder partnerType(EventNotificationPartnerType partnerType) {
            this.partnerType(partnerType == null ? null : partnerType.toString());
            return this;
        }

        public final EventNotificationItemConfigurations.Builder getEvents() {
            return events != null ? events.toBuilder() : null;
        }

        public final void setEvents(EventNotificationItemConfigurations.BuilderImpl events) {
            this.events = events != null ? events.build() : null;
        }

        @Override
        public final Builder events(EventNotificationItemConfigurations events) {
            this.events = events;
            return this;
        }

        @Override
        public EventConfigurationItem build() {
            return new EventConfigurationItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
