/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of FPort assigned for different LoRaWAN application packages to use
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FPorts implements SdkPojo, Serializable, ToCopyableBuilder<FPorts.Builder, FPorts> {
    private static final SdkField<Integer> FUOTA_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Fuota")
            .getter(getter(FPorts::fuota)).setter(setter(Builder::fuota))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fuota").build()).build();

    private static final SdkField<Integer> MULTICAST_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Multicast").getter(getter(FPorts::multicast)).setter(setter(Builder::multicast))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Multicast").build()).build();

    private static final SdkField<Integer> CLOCK_SYNC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClockSync").getter(getter(FPorts::clockSync)).setter(setter(Builder::clockSync))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClockSync").build()).build();

    private static final SdkField<Positioning> POSITIONING_FIELD = SdkField.<Positioning> builder(MarshallingType.SDK_POJO)
            .memberName("Positioning").getter(getter(FPorts::positioning)).setter(setter(Builder::positioning))
            .constructor(Positioning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()).build();

    private static final SdkField<List<ApplicationConfig>> APPLICATIONS_FIELD = SdkField
            .<List<ApplicationConfig>> builder(MarshallingType.LIST)
            .memberName("Applications")
            .getter(getter(FPorts::applications))
            .setter(setter(Builder::applications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUOTA_FIELD, MULTICAST_FIELD,
            CLOCK_SYNC_FIELD, POSITIONING_FIELD, APPLICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer fuota;

    private final Integer multicast;

    private final Integer clockSync;

    private final Positioning positioning;

    private final List<ApplicationConfig> applications;

    private FPorts(BuilderImpl builder) {
        this.fuota = builder.fuota;
        this.multicast = builder.multicast;
        this.clockSync = builder.clockSync;
        this.positioning = builder.positioning;
        this.applications = builder.applications;
    }

    /**
     * Returns the value of the Fuota property for this object.
     * 
     * @return The value of the Fuota property for this object.
     */
    public final Integer fuota() {
        return fuota;
    }

    /**
     * Returns the value of the Multicast property for this object.
     * 
     * @return The value of the Multicast property for this object.
     */
    public final Integer multicast() {
        return multicast;
    }

    /**
     * Returns the value of the ClockSync property for this object.
     * 
     * @return The value of the ClockSync property for this object.
     */
    public final Integer clockSync() {
        return clockSync;
    }

    /**
     * <p>
     * FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
     * </p>
     * 
     * @return FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
     */
    public final Positioning positioning() {
        return positioning;
    }

    /**
     * For responses, this returns true if the service returned a value for the Applications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplications() {
        return applications != null && !(applications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional LoRaWAN application information, which can be used for geolocation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplications} method.
     * </p>
     * 
     * @return Optional LoRaWAN application information, which can be used for geolocation.
     */
    public final List<ApplicationConfig> applications() {
        return applications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fuota());
        hashCode = 31 * hashCode + Objects.hashCode(multicast());
        hashCode = 31 * hashCode + Objects.hashCode(clockSync());
        hashCode = 31 * hashCode + Objects.hashCode(positioning());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplications() ? applications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FPorts)) {
            return false;
        }
        FPorts other = (FPorts) obj;
        return Objects.equals(fuota(), other.fuota()) && Objects.equals(multicast(), other.multicast())
                && Objects.equals(clockSync(), other.clockSync()) && Objects.equals(positioning(), other.positioning())
                && hasApplications() == other.hasApplications() && Objects.equals(applications(), other.applications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FPorts").add("Fuota", fuota()).add("Multicast", multicast()).add("ClockSync", clockSync())
                .add("Positioning", positioning()).add("Applications", hasApplications() ? applications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fuota":
            return Optional.ofNullable(clazz.cast(fuota()));
        case "Multicast":
            return Optional.ofNullable(clazz.cast(multicast()));
        case "ClockSync":
            return Optional.ofNullable(clazz.cast(clockSync()));
        case "Positioning":
            return Optional.ofNullable(clazz.cast(positioning()));
        case "Applications":
            return Optional.ofNullable(clazz.cast(applications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Fuota", FUOTA_FIELD);
        map.put("Multicast", MULTICAST_FIELD);
        map.put("ClockSync", CLOCK_SYNC_FIELD);
        map.put("Positioning", POSITIONING_FIELD);
        map.put("Applications", APPLICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FPorts, T> g) {
        return obj -> g.apply((FPorts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FPorts> {
        /**
         * Sets the value of the Fuota property for this object.
         *
         * @param fuota
         *        The new value for the Fuota property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fuota(Integer fuota);

        /**
         * Sets the value of the Multicast property for this object.
         *
         * @param multicast
         *        The new value for the Multicast property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicast(Integer multicast);

        /**
         * Sets the value of the ClockSync property for this object.
         *
         * @param clockSync
         *        The new value for the ClockSync property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clockSync(Integer clockSync);

        /**
         * <p>
         * FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
         * </p>
         * 
         * @param positioning
         *        FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positioning(Positioning positioning);

        /**
         * <p>
         * FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
         * </p>
         * This is a convenience method that creates an instance of the {@link Positioning.Builder} avoiding the need to
         * create one manually via {@link Positioning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Positioning.Builder#build()} is called immediately and its result
         * is passed to {@link #positioning(Positioning)}.
         * 
         * @param positioning
         *        a consumer that will call methods on {@link Positioning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #positioning(Positioning)
         */
        default Builder positioning(Consumer<Positioning.Builder> positioning) {
            return positioning(Positioning.builder().applyMutation(positioning).build());
        }

        /**
         * <p>
         * Optional LoRaWAN application information, which can be used for geolocation.
         * </p>
         * 
         * @param applications
         *        Optional LoRaWAN application information, which can be used for geolocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<ApplicationConfig> applications);

        /**
         * <p>
         * Optional LoRaWAN application information, which can be used for geolocation.
         * </p>
         * 
         * @param applications
         *        Optional LoRaWAN application information, which can be used for geolocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(ApplicationConfig... applications);

        /**
         * <p>
         * Optional LoRaWAN application information, which can be used for geolocation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.ApplicationConfig.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotwireless.model.ApplicationConfig#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.ApplicationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #applications(List<ApplicationConfig>)}.
         * 
         * @param applications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.ApplicationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applications(java.util.Collection<ApplicationConfig>)
         */
        Builder applications(Consumer<ApplicationConfig.Builder>... applications);
    }

    static final class BuilderImpl implements Builder {
        private Integer fuota;

        private Integer multicast;

        private Integer clockSync;

        private Positioning positioning;

        private List<ApplicationConfig> applications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FPorts model) {
            fuota(model.fuota);
            multicast(model.multicast);
            clockSync(model.clockSync);
            positioning(model.positioning);
            applications(model.applications);
        }

        public final Integer getFuota() {
            return fuota;
        }

        public final void setFuota(Integer fuota) {
            this.fuota = fuota;
        }

        @Override
        public final Builder fuota(Integer fuota) {
            this.fuota = fuota;
            return this;
        }

        public final Integer getMulticast() {
            return multicast;
        }

        public final void setMulticast(Integer multicast) {
            this.multicast = multicast;
        }

        @Override
        public final Builder multicast(Integer multicast) {
            this.multicast = multicast;
            return this;
        }

        public final Integer getClockSync() {
            return clockSync;
        }

        public final void setClockSync(Integer clockSync) {
            this.clockSync = clockSync;
        }

        @Override
        public final Builder clockSync(Integer clockSync) {
            this.clockSync = clockSync;
            return this;
        }

        public final Positioning.Builder getPositioning() {
            return positioning != null ? positioning.toBuilder() : null;
        }

        public final void setPositioning(Positioning.BuilderImpl positioning) {
            this.positioning = positioning != null ? positioning.build() : null;
        }

        @Override
        public final Builder positioning(Positioning positioning) {
            this.positioning = positioning;
            return this;
        }

        public final List<ApplicationConfig.Builder> getApplications() {
            List<ApplicationConfig.Builder> result = ApplicationsCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplications(Collection<ApplicationConfig.BuilderImpl> applications) {
            this.applications = ApplicationsCopier.copyFromBuilder(applications);
        }

        @Override
        public final Builder applications(Collection<ApplicationConfig> applications) {
            this.applications = ApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(ApplicationConfig... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<ApplicationConfig.Builder>... applications) {
            applications(Stream.of(applications).map(c -> ApplicationConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FPorts build() {
            return new FPorts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
