/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNetworkAnalyzerConfigurationResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetNetworkAnalyzerConfigurationResponse.Builder, GetNetworkAnalyzerConfigurationResponse> {
    private static final SdkField<TraceContent> TRACE_CONTENT_FIELD = SdkField.<TraceContent> builder(MarshallingType.SDK_POJO)
            .memberName("TraceContent").getter(getter(GetNetworkAnalyzerConfigurationResponse::traceContent))
            .setter(setter(Builder::traceContent)).constructor(TraceContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceContent").build()).build();

    private static final SdkField<List<String>> WIRELESS_DEVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WirelessDevices")
            .getter(getter(GetNetworkAnalyzerConfigurationResponse::wirelessDevices))
            .setter(setter(Builder::wirelessDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WIRELESS_GATEWAYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WirelessGateways")
            .getter(getter(GetNetworkAnalyzerConfigurationResponse::wirelessGateways))
            .setter(setter(Builder::wirelessGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGateways").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetNetworkAnalyzerConfigurationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetNetworkAnalyzerConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetNetworkAnalyzerConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> MULTICAST_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MulticastGroups")
            .getter(getter(GetNetworkAnalyzerConfigurationResponse::multicastGroups))
            .setter(setter(Builder::multicastGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_CONTENT_FIELD,
            WIRELESS_DEVICES_FIELD, WIRELESS_GATEWAYS_FIELD, DESCRIPTION_FIELD, ARN_FIELD, NAME_FIELD, MULTICAST_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TraceContent traceContent;

    private final List<String> wirelessDevices;

    private final List<String> wirelessGateways;

    private final String description;

    private final String arn;

    private final String name;

    private final List<String> multicastGroups;

    private GetNetworkAnalyzerConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.traceContent = builder.traceContent;
        this.wirelessDevices = builder.wirelessDevices;
        this.wirelessGateways = builder.wirelessGateways;
        this.description = builder.description;
        this.arn = builder.arn;
        this.name = builder.name;
        this.multicastGroups = builder.multicastGroups;
    }

    /**
     * Returns the value of the TraceContent property for this object.
     * 
     * @return The value of the TraceContent property for this object.
     */
    public final TraceContent traceContent() {
        return traceContent;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessDevices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWirelessDevices() {
        return wirelessDevices != null && !(wirelessDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of wireless device resources that have been added to the network analyzer configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessDevices} method.
     * </p>
     * 
     * @return List of wireless device resources that have been added to the network analyzer configuration.
     */
    public final List<String> wirelessDevices() {
        return wirelessDevices;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessGateways property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWirelessGateways() {
        return wirelessGateways != null && !(wirelessGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of wireless gateway resources that have been added to the network analyzer configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessGateways} method.
     * </p>
     * 
     * @return List of wireless gateway resources that have been added to the network analyzer configuration.
     */
    public final List<String> wirelessGateways() {
        return wirelessGateways;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name of the new resource.
     * </p>
     * 
     * @return The Amazon Resource Name of the new resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the MulticastGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMulticastGroups() {
        return multicastGroups != null && !(multicastGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of multicast group resources that have been added to the network analyzer configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMulticastGroups} method.
     * </p>
     * 
     * @return List of multicast group resources that have been added to the network analyzer configuration.
     */
    public final List<String> multicastGroups() {
        return multicastGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(traceContent());
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessDevices() ? wirelessDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessGateways() ? wirelessGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasMulticastGroups() ? multicastGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkAnalyzerConfigurationResponse)) {
            return false;
        }
        GetNetworkAnalyzerConfigurationResponse other = (GetNetworkAnalyzerConfigurationResponse) obj;
        return Objects.equals(traceContent(), other.traceContent()) && hasWirelessDevices() == other.hasWirelessDevices()
                && Objects.equals(wirelessDevices(), other.wirelessDevices())
                && hasWirelessGateways() == other.hasWirelessGateways()
                && Objects.equals(wirelessGateways(), other.wirelessGateways())
                && Objects.equals(description(), other.description()) && Objects.equals(arn(), other.arn())
                && Objects.equals(name(), other.name()) && hasMulticastGroups() == other.hasMulticastGroups()
                && Objects.equals(multicastGroups(), other.multicastGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNetworkAnalyzerConfigurationResponse").add("TraceContent", traceContent())
                .add("WirelessDevices", hasWirelessDevices() ? wirelessDevices() : null)
                .add("WirelessGateways", hasWirelessGateways() ? wirelessGateways() : null).add("Description", description())
                .add("Arn", arn()).add("Name", name()).add("MulticastGroups", hasMulticastGroups() ? multicastGroups() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TraceContent":
            return Optional.ofNullable(clazz.cast(traceContent()));
        case "WirelessDevices":
            return Optional.ofNullable(clazz.cast(wirelessDevices()));
        case "WirelessGateways":
            return Optional.ofNullable(clazz.cast(wirelessGateways()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MulticastGroups":
            return Optional.ofNullable(clazz.cast(multicastGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TraceContent", TRACE_CONTENT_FIELD);
        map.put("WirelessDevices", WIRELESS_DEVICES_FIELD);
        map.put("WirelessGateways", WIRELESS_GATEWAYS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("MulticastGroups", MULTICAST_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkAnalyzerConfigurationResponse, T> g) {
        return obj -> g.apply((GetNetworkAnalyzerConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetNetworkAnalyzerConfigurationResponse> {
        /**
         * Sets the value of the TraceContent property for this object.
         *
         * @param traceContent
         *        The new value for the TraceContent property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceContent(TraceContent traceContent);

        /**
         * Sets the value of the TraceContent property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TraceContent.Builder} avoiding the need
         * to create one manually via {@link TraceContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TraceContent.Builder#build()} is called immediately and its
         * result is passed to {@link #traceContent(TraceContent)}.
         * 
         * @param traceContent
         *        a consumer that will call methods on {@link TraceContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traceContent(TraceContent)
         */
        default Builder traceContent(Consumer<TraceContent.Builder> traceContent) {
            return traceContent(TraceContent.builder().applyMutation(traceContent).build());
        }

        /**
         * <p>
         * List of wireless device resources that have been added to the network analyzer configuration.
         * </p>
         * 
         * @param wirelessDevices
         *        List of wireless device resources that have been added to the network analyzer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDevices(Collection<String> wirelessDevices);

        /**
         * <p>
         * List of wireless device resources that have been added to the network analyzer configuration.
         * </p>
         * 
         * @param wirelessDevices
         *        List of wireless device resources that have been added to the network analyzer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDevices(String... wirelessDevices);

        /**
         * <p>
         * List of wireless gateway resources that have been added to the network analyzer configuration.
         * </p>
         * 
         * @param wirelessGateways
         *        List of wireless gateway resources that have been added to the network analyzer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGateways(Collection<String> wirelessGateways);

        /**
         * <p>
         * List of wireless gateway resources that have been added to the network analyzer configuration.
         * </p>
         * 
         * @param wirelessGateways
         *        List of wireless gateway resources that have been added to the network analyzer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGateways(String... wirelessGateways);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name of the new resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name of the new resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * List of multicast group resources that have been added to the network analyzer configuration.
         * </p>
         * 
         * @param multicastGroups
         *        List of multicast group resources that have been added to the network analyzer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastGroups(Collection<String> multicastGroups);

        /**
         * <p>
         * List of multicast group resources that have been added to the network analyzer configuration.
         * </p>
         * 
         * @param multicastGroups
         *        List of multicast group resources that have been added to the network analyzer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastGroups(String... multicastGroups);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private TraceContent traceContent;

        private List<String> wirelessDevices = DefaultSdkAutoConstructList.getInstance();

        private List<String> wirelessGateways = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String arn;

        private String name;

        private List<String> multicastGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkAnalyzerConfigurationResponse model) {
            super(model);
            traceContent(model.traceContent);
            wirelessDevices(model.wirelessDevices);
            wirelessGateways(model.wirelessGateways);
            description(model.description);
            arn(model.arn);
            name(model.name);
            multicastGroups(model.multicastGroups);
        }

        public final TraceContent.Builder getTraceContent() {
            return traceContent != null ? traceContent.toBuilder() : null;
        }

        public final void setTraceContent(TraceContent.BuilderImpl traceContent) {
            this.traceContent = traceContent != null ? traceContent.build() : null;
        }

        @Override
        public final Builder traceContent(TraceContent traceContent) {
            this.traceContent = traceContent;
            return this;
        }

        public final Collection<String> getWirelessDevices() {
            if (wirelessDevices instanceof SdkAutoConstructList) {
                return null;
            }
            return wirelessDevices;
        }

        public final void setWirelessDevices(Collection<String> wirelessDevices) {
            this.wirelessDevices = WirelessDeviceListCopier.copy(wirelessDevices);
        }

        @Override
        public final Builder wirelessDevices(Collection<String> wirelessDevices) {
            this.wirelessDevices = WirelessDeviceListCopier.copy(wirelessDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDevices(String... wirelessDevices) {
            wirelessDevices(Arrays.asList(wirelessDevices));
            return this;
        }

        public final Collection<String> getWirelessGateways() {
            if (wirelessGateways instanceof SdkAutoConstructList) {
                return null;
            }
            return wirelessGateways;
        }

        public final void setWirelessGateways(Collection<String> wirelessGateways) {
            this.wirelessGateways = WirelessGatewayListCopier.copy(wirelessGateways);
        }

        @Override
        public final Builder wirelessGateways(Collection<String> wirelessGateways) {
            this.wirelessGateways = WirelessGatewayListCopier.copy(wirelessGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGateways(String... wirelessGateways) {
            wirelessGateways(Arrays.asList(wirelessGateways));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getMulticastGroups() {
            if (multicastGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return multicastGroups;
        }

        public final void setMulticastGroups(Collection<String> multicastGroups) {
            this.multicastGroups = NetworkAnalyzerMulticastGroupListCopier.copy(multicastGroups);
        }

        @Override
        public final Builder multicastGroups(Collection<String> multicastGroups) {
            this.multicastGroups = NetworkAnalyzerMulticastGroupListCopier.copy(multicastGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroups(String... multicastGroups) {
            multicastGroups(Arrays.asList(multicastGroups));
            return this;
        }

        @Override
        public GetNetworkAnalyzerConfigurationResponse build() {
            return new GetNetworkAnalyzerConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
