/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPositionResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetPositionResponse.Builder, GetPositionResponse> {
    private static final SdkField<List<Float>> POSITION_FIELD = SdkField
            .<List<Float>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(GetPositionResponse::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Float> builder(MarshallingType.FLOAT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Accuracy> ACCURACY_FIELD = SdkField.<Accuracy> builder(MarshallingType.SDK_POJO)
            .memberName("Accuracy").getter(getter(GetPositionResponse::accuracy)).setter(setter(Builder::accuracy))
            .constructor(Accuracy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accuracy").build()).build();

    private static final SdkField<String> SOLVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SolverType").getter(getter(GetPositionResponse::solverTypeAsString)).setter(setter(Builder::solverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolverType").build()).build();

    private static final SdkField<String> SOLVER_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SolverProvider").getter(getter(GetPositionResponse::solverProviderAsString))
            .setter(setter(Builder::solverProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolverProvider").build()).build();

    private static final SdkField<String> SOLVER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SolverVersion").getter(getter(GetPositionResponse::solverVersion))
            .setter(setter(Builder::solverVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolverVersion").build()).build();

    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timestamp").getter(getter(GetPositionResponse::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD,
            ACCURACY_FIELD, SOLVER_TYPE_FIELD, SOLVER_PROVIDER_FIELD, SOLVER_VERSION_FIELD, TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Float> position;

    private final Accuracy accuracy;

    private final String solverType;

    private final String solverProvider;

    private final String solverVersion;

    private final String timestamp;

    private GetPositionResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.accuracy = builder.accuracy;
        this.solverType = builder.solverType;
        this.solverProvider = builder.solverProvider;
        this.solverVersion = builder.solverVersion;
        this.timestamp = builder.timestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The position information of the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return The position information of the resource.
     */
    public final List<Float> position() {
        return position;
    }

    /**
     * <p>
     * The accuracy of the estimated position in meters. An empty value indicates that no position data is available. A
     * value of ‘0.0’ value indicates that position data is available. This data corresponds to the position information
     * that you specified instead of the position computed by solver.
     * </p>
     * 
     * @return The accuracy of the estimated position in meters. An empty value indicates that no position data is
     *         available. A value of ‘0.0’ value indicates that position data is available. This data corresponds to the
     *         position information that you specified instead of the position computed by solver.
     */
    public final Accuracy accuracy() {
        return accuracy;
    }

    /**
     * <p>
     * The type of solver used to identify the position of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #solverType} will
     * return {@link PositionSolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #solverTypeAsString}.
     * </p>
     * 
     * @return The type of solver used to identify the position of the resource.
     * @see PositionSolverType
     */
    public final PositionSolverType solverType() {
        return PositionSolverType.fromValue(solverType);
    }

    /**
     * <p>
     * The type of solver used to identify the position of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #solverType} will
     * return {@link PositionSolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #solverTypeAsString}.
     * </p>
     * 
     * @return The type of solver used to identify the position of the resource.
     * @see PositionSolverType
     */
    public final String solverTypeAsString() {
        return solverType;
    }

    /**
     * <p>
     * The vendor of the positioning solver.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #solverProvider}
     * will return {@link PositionSolverProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #solverProviderAsString}.
     * </p>
     * 
     * @return The vendor of the positioning solver.
     * @see PositionSolverProvider
     */
    public final PositionSolverProvider solverProvider() {
        return PositionSolverProvider.fromValue(solverProvider);
    }

    /**
     * <p>
     * The vendor of the positioning solver.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #solverProvider}
     * will return {@link PositionSolverProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #solverProviderAsString}.
     * </p>
     * 
     * @return The vendor of the positioning solver.
     * @see PositionSolverProvider
     */
    public final String solverProviderAsString() {
        return solverProvider;
    }

    /**
     * <p>
     * The version of the positioning solver.
     * </p>
     * 
     * @return The version of the positioning solver.
     */
    public final String solverVersion() {
        return solverVersion;
    }

    /**
     * <p>
     * The timestamp at which the device's position was determined.
     * </p>
     * 
     * @return The timestamp at which the device's position was determined.
     */
    public final String timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accuracy());
        hashCode = 31 * hashCode + Objects.hashCode(solverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(solverProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(solverVersion());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPositionResponse)) {
            return false;
        }
        GetPositionResponse other = (GetPositionResponse) obj;
        return hasPosition() == other.hasPosition() && Objects.equals(position(), other.position())
                && Objects.equals(accuracy(), other.accuracy())
                && Objects.equals(solverTypeAsString(), other.solverTypeAsString())
                && Objects.equals(solverProviderAsString(), other.solverProviderAsString())
                && Objects.equals(solverVersion(), other.solverVersion()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPositionResponse").add("Position", hasPosition() ? position() : null)
                .add("Accuracy", accuracy()).add("SolverType", solverTypeAsString())
                .add("SolverProvider", solverProviderAsString()).add("SolverVersion", solverVersion())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "Accuracy":
            return Optional.ofNullable(clazz.cast(accuracy()));
        case "SolverType":
            return Optional.ofNullable(clazz.cast(solverTypeAsString()));
        case "SolverProvider":
            return Optional.ofNullable(clazz.cast(solverProviderAsString()));
        case "SolverVersion":
            return Optional.ofNullable(clazz.cast(solverVersion()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Position", POSITION_FIELD);
        map.put("Accuracy", ACCURACY_FIELD);
        map.put("SolverType", SOLVER_TYPE_FIELD);
        map.put("SolverProvider", SOLVER_PROVIDER_FIELD);
        map.put("SolverVersion", SOLVER_VERSION_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPositionResponse, T> g) {
        return obj -> g.apply((GetPositionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPositionResponse> {
        /**
         * <p>
         * The position information of the resource.
         * </p>
         * 
         * @param position
         *        The position information of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Float> position);

        /**
         * <p>
         * The position information of the resource.
         * </p>
         * 
         * @param position
         *        The position information of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Float... position);

        /**
         * <p>
         * The accuracy of the estimated position in meters. An empty value indicates that no position data is
         * available. A value of ‘0.0’ value indicates that position data is available. This data corresponds to the
         * position information that you specified instead of the position computed by solver.
         * </p>
         * 
         * @param accuracy
         *        The accuracy of the estimated position in meters. An empty value indicates that no position data is
         *        available. A value of ‘0.0’ value indicates that position data is available. This data corresponds to
         *        the position information that you specified instead of the position computed by solver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accuracy(Accuracy accuracy);

        /**
         * <p>
         * The accuracy of the estimated position in meters. An empty value indicates that no position data is
         * available. A value of ‘0.0’ value indicates that position data is available. This data corresponds to the
         * position information that you specified instead of the position computed by solver.
         * </p>
         * This is a convenience method that creates an instance of the {@link Accuracy.Builder} avoiding the need to
         * create one manually via {@link Accuracy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Accuracy.Builder#build()} is called immediately and its result is
         * passed to {@link #accuracy(Accuracy)}.
         * 
         * @param accuracy
         *        a consumer that will call methods on {@link Accuracy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accuracy(Accuracy)
         */
        default Builder accuracy(Consumer<Accuracy.Builder> accuracy) {
            return accuracy(Accuracy.builder().applyMutation(accuracy).build());
        }

        /**
         * <p>
         * The type of solver used to identify the position of the resource.
         * </p>
         * 
         * @param solverType
         *        The type of solver used to identify the position of the resource.
         * @see PositionSolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionSolverType
         */
        Builder solverType(String solverType);

        /**
         * <p>
         * The type of solver used to identify the position of the resource.
         * </p>
         * 
         * @param solverType
         *        The type of solver used to identify the position of the resource.
         * @see PositionSolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionSolverType
         */
        Builder solverType(PositionSolverType solverType);

        /**
         * <p>
         * The vendor of the positioning solver.
         * </p>
         * 
         * @param solverProvider
         *        The vendor of the positioning solver.
         * @see PositionSolverProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionSolverProvider
         */
        Builder solverProvider(String solverProvider);

        /**
         * <p>
         * The vendor of the positioning solver.
         * </p>
         * 
         * @param solverProvider
         *        The vendor of the positioning solver.
         * @see PositionSolverProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionSolverProvider
         */
        Builder solverProvider(PositionSolverProvider solverProvider);

        /**
         * <p>
         * The version of the positioning solver.
         * </p>
         * 
         * @param solverVersion
         *        The version of the positioning solver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solverVersion(String solverVersion);

        /**
         * <p>
         * The timestamp at which the device's position was determined.
         * </p>
         * 
         * @param timestamp
         *        The timestamp at which the device's position was determined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private List<Float> position = DefaultSdkAutoConstructList.getInstance();

        private Accuracy accuracy;

        private String solverType;

        private String solverProvider;

        private String solverVersion;

        private String timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPositionResponse model) {
            super(model);
            position(model.position);
            accuracy(model.accuracy);
            solverType(model.solverType);
            solverProvider(model.solverProvider);
            solverVersion(model.solverVersion);
            timestamp(model.timestamp);
        }

        public final Collection<Float> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Float> position) {
            this.position = PositionCoordinateCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Float> position) {
            this.position = PositionCoordinateCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Float... position) {
            position(Arrays.asList(position));
            return this;
        }

        public final Accuracy.Builder getAccuracy() {
            return accuracy != null ? accuracy.toBuilder() : null;
        }

        public final void setAccuracy(Accuracy.BuilderImpl accuracy) {
            this.accuracy = accuracy != null ? accuracy.build() : null;
        }

        @Override
        public final Builder accuracy(Accuracy accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public final String getSolverType() {
            return solverType;
        }

        public final void setSolverType(String solverType) {
            this.solverType = solverType;
        }

        @Override
        public final Builder solverType(String solverType) {
            this.solverType = solverType;
            return this;
        }

        @Override
        public final Builder solverType(PositionSolverType solverType) {
            this.solverType(solverType == null ? null : solverType.toString());
            return this;
        }

        public final String getSolverProvider() {
            return solverProvider;
        }

        public final void setSolverProvider(String solverProvider) {
            this.solverProvider = solverProvider;
        }

        @Override
        public final Builder solverProvider(String solverProvider) {
            this.solverProvider = solverProvider;
            return this;
        }

        @Override
        public final Builder solverProvider(PositionSolverProvider solverProvider) {
            this.solverProvider(solverProvider == null ? null : solverProvider.toString());
            return this;
        }

        public final String getSolverVersion() {
            return solverVersion;
        }

        public final void setSolverVersion(String solverVersion) {
            this.solverVersion = solverVersion;
        }

        @Override
        public final Builder solverVersion(String solverVersion) {
            this.solverVersion = solverVersion;
            return this;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public GetPositionResponse build() {
            return new GetPositionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
