/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceEventConfigurationResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetResourceEventConfigurationResponse.Builder, GetResourceEventConfigurationResponse> {
    private static final SdkField<DeviceRegistrationStateEventConfiguration> DEVICE_REGISTRATION_STATE_FIELD = SdkField
            .<DeviceRegistrationStateEventConfiguration> builder(MarshallingType.SDK_POJO).memberName("DeviceRegistrationState")
            .getter(getter(GetResourceEventConfigurationResponse::deviceRegistrationState))
            .setter(setter(Builder::deviceRegistrationState)).constructor(DeviceRegistrationStateEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceRegistrationState").build())
            .build();

    private static final SdkField<ProximityEventConfiguration> PROXIMITY_FIELD = SdkField
            .<ProximityEventConfiguration> builder(MarshallingType.SDK_POJO).memberName("Proximity")
            .getter(getter(GetResourceEventConfigurationResponse::proximity)).setter(setter(Builder::proximity))
            .constructor(ProximityEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proximity").build()).build();

    private static final SdkField<JoinEventConfiguration> JOIN_FIELD = SdkField
            .<JoinEventConfiguration> builder(MarshallingType.SDK_POJO).memberName("Join")
            .getter(getter(GetResourceEventConfigurationResponse::join)).setter(setter(Builder::join))
            .constructor(JoinEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Join").build()).build();

    private static final SdkField<ConnectionStatusEventConfiguration> CONNECTION_STATUS_FIELD = SdkField
            .<ConnectionStatusEventConfiguration> builder(MarshallingType.SDK_POJO).memberName("ConnectionStatus")
            .getter(getter(GetResourceEventConfigurationResponse::connectionStatus)).setter(setter(Builder::connectionStatus))
            .constructor(ConnectionStatusEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()).build();

    private static final SdkField<MessageDeliveryStatusEventConfiguration> MESSAGE_DELIVERY_STATUS_FIELD = SdkField
            .<MessageDeliveryStatusEventConfiguration> builder(MarshallingType.SDK_POJO).memberName("MessageDeliveryStatus")
            .getter(getter(GetResourceEventConfigurationResponse::messageDeliveryStatus))
            .setter(setter(Builder::messageDeliveryStatus)).constructor(MessageDeliveryStatusEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDeliveryStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DEVICE_REGISTRATION_STATE_FIELD, PROXIMITY_FIELD, JOIN_FIELD,
                    CONNECTION_STATUS_FIELD, MESSAGE_DELIVERY_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DeviceRegistrationStateEventConfiguration deviceRegistrationState;

    private final ProximityEventConfiguration proximity;

    private final JoinEventConfiguration join;

    private final ConnectionStatusEventConfiguration connectionStatus;

    private final MessageDeliveryStatusEventConfiguration messageDeliveryStatus;

    private GetResourceEventConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.deviceRegistrationState = builder.deviceRegistrationState;
        this.proximity = builder.proximity;
        this.join = builder.join;
        this.connectionStatus = builder.connectionStatus;
        this.messageDeliveryStatus = builder.messageDeliveryStatus;
    }

    /**
     * <p>
     * Event configuration for the device registration state event.
     * </p>
     * 
     * @return Event configuration for the device registration state event.
     */
    public final DeviceRegistrationStateEventConfiguration deviceRegistrationState() {
        return deviceRegistrationState;
    }

    /**
     * <p>
     * Event configuration for the proximity event.
     * </p>
     * 
     * @return Event configuration for the proximity event.
     */
    public final ProximityEventConfiguration proximity() {
        return proximity;
    }

    /**
     * <p>
     * Event configuration for the join event.
     * </p>
     * 
     * @return Event configuration for the join event.
     */
    public final JoinEventConfiguration join() {
        return join;
    }

    /**
     * <p>
     * Event configuration for the connection status event.
     * </p>
     * 
     * @return Event configuration for the connection status event.
     */
    public final ConnectionStatusEventConfiguration connectionStatus() {
        return connectionStatus;
    }

    /**
     * <p>
     * Event configuration for the message delivery status event.
     * </p>
     * 
     * @return Event configuration for the message delivery status event.
     */
    public final MessageDeliveryStatusEventConfiguration messageDeliveryStatus() {
        return messageDeliveryStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceRegistrationState());
        hashCode = 31 * hashCode + Objects.hashCode(proximity());
        hashCode = 31 * hashCode + Objects.hashCode(join());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(messageDeliveryStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceEventConfigurationResponse)) {
            return false;
        }
        GetResourceEventConfigurationResponse other = (GetResourceEventConfigurationResponse) obj;
        return Objects.equals(deviceRegistrationState(), other.deviceRegistrationState())
                && Objects.equals(proximity(), other.proximity()) && Objects.equals(join(), other.join())
                && Objects.equals(connectionStatus(), other.connectionStatus())
                && Objects.equals(messageDeliveryStatus(), other.messageDeliveryStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceEventConfigurationResponse")
                .add("DeviceRegistrationState", deviceRegistrationState()).add("Proximity", proximity()).add("Join", join())
                .add("ConnectionStatus", connectionStatus()).add("MessageDeliveryStatus", messageDeliveryStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceRegistrationState":
            return Optional.ofNullable(clazz.cast(deviceRegistrationState()));
        case "Proximity":
            return Optional.ofNullable(clazz.cast(proximity()));
        case "Join":
            return Optional.ofNullable(clazz.cast(join()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatus()));
        case "MessageDeliveryStatus":
            return Optional.ofNullable(clazz.cast(messageDeliveryStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceRegistrationState", DEVICE_REGISTRATION_STATE_FIELD);
        map.put("Proximity", PROXIMITY_FIELD);
        map.put("Join", JOIN_FIELD);
        map.put("ConnectionStatus", CONNECTION_STATUS_FIELD);
        map.put("MessageDeliveryStatus", MESSAGE_DELIVERY_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceEventConfigurationResponse, T> g) {
        return obj -> g.apply((GetResourceEventConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceEventConfigurationResponse> {
        /**
         * <p>
         * Event configuration for the device registration state event.
         * </p>
         * 
         * @param deviceRegistrationState
         *        Event configuration for the device registration state event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceRegistrationState(DeviceRegistrationStateEventConfiguration deviceRegistrationState);

        /**
         * <p>
         * Event configuration for the device registration state event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DeviceRegistrationStateEventConfiguration.Builder} avoiding the need to create one manually via
         * {@link DeviceRegistrationStateEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceRegistrationStateEventConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deviceRegistrationState(DeviceRegistrationStateEventConfiguration)}.
         * 
         * @param deviceRegistrationState
         *        a consumer that will call methods on {@link DeviceRegistrationStateEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceRegistrationState(DeviceRegistrationStateEventConfiguration)
         */
        default Builder deviceRegistrationState(
                Consumer<DeviceRegistrationStateEventConfiguration.Builder> deviceRegistrationState) {
            return deviceRegistrationState(DeviceRegistrationStateEventConfiguration.builder()
                    .applyMutation(deviceRegistrationState).build());
        }

        /**
         * <p>
         * Event configuration for the proximity event.
         * </p>
         * 
         * @param proximity
         *        Event configuration for the proximity event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proximity(ProximityEventConfiguration proximity);

        /**
         * <p>
         * Event configuration for the proximity event.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProximityEventConfiguration.Builder}
         * avoiding the need to create one manually via {@link ProximityEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProximityEventConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #proximity(ProximityEventConfiguration)}.
         * 
         * @param proximity
         *        a consumer that will call methods on {@link ProximityEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proximity(ProximityEventConfiguration)
         */
        default Builder proximity(Consumer<ProximityEventConfiguration.Builder> proximity) {
            return proximity(ProximityEventConfiguration.builder().applyMutation(proximity).build());
        }

        /**
         * <p>
         * Event configuration for the join event.
         * </p>
         * 
         * @param join
         *        Event configuration for the join event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder join(JoinEventConfiguration join);

        /**
         * <p>
         * Event configuration for the join event.
         * </p>
         * This is a convenience method that creates an instance of the {@link JoinEventConfiguration.Builder} avoiding
         * the need to create one manually via {@link JoinEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JoinEventConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #join(JoinEventConfiguration)}.
         * 
         * @param join
         *        a consumer that will call methods on {@link JoinEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #join(JoinEventConfiguration)
         */
        default Builder join(Consumer<JoinEventConfiguration.Builder> join) {
            return join(JoinEventConfiguration.builder().applyMutation(join).build());
        }

        /**
         * <p>
         * Event configuration for the connection status event.
         * </p>
         * 
         * @param connectionStatus
         *        Event configuration for the connection status event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionStatus(ConnectionStatusEventConfiguration connectionStatus);

        /**
         * <p>
         * Event configuration for the connection status event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConnectionStatusEventConfiguration.Builder} avoiding the need to create one manually via
         * {@link ConnectionStatusEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionStatusEventConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionStatus(ConnectionStatusEventConfiguration)}.
         * 
         * @param connectionStatus
         *        a consumer that will call methods on {@link ConnectionStatusEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionStatus(ConnectionStatusEventConfiguration)
         */
        default Builder connectionStatus(Consumer<ConnectionStatusEventConfiguration.Builder> connectionStatus) {
            return connectionStatus(ConnectionStatusEventConfiguration.builder().applyMutation(connectionStatus).build());
        }

        /**
         * <p>
         * Event configuration for the message delivery status event.
         * </p>
         * 
         * @param messageDeliveryStatus
         *        Event configuration for the message delivery status event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageDeliveryStatus(MessageDeliveryStatusEventConfiguration messageDeliveryStatus);

        /**
         * <p>
         * Event configuration for the message delivery status event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MessageDeliveryStatusEventConfiguration.Builder} avoiding the need to create one manually via
         * {@link MessageDeliveryStatusEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageDeliveryStatusEventConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #messageDeliveryStatus(MessageDeliveryStatusEventConfiguration)}.
         * 
         * @param messageDeliveryStatus
         *        a consumer that will call methods on {@link MessageDeliveryStatusEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageDeliveryStatus(MessageDeliveryStatusEventConfiguration)
         */
        default Builder messageDeliveryStatus(Consumer<MessageDeliveryStatusEventConfiguration.Builder> messageDeliveryStatus) {
            return messageDeliveryStatus(MessageDeliveryStatusEventConfiguration.builder().applyMutation(messageDeliveryStatus)
                    .build());
        }
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private DeviceRegistrationStateEventConfiguration deviceRegistrationState;

        private ProximityEventConfiguration proximity;

        private JoinEventConfiguration join;

        private ConnectionStatusEventConfiguration connectionStatus;

        private MessageDeliveryStatusEventConfiguration messageDeliveryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceEventConfigurationResponse model) {
            super(model);
            deviceRegistrationState(model.deviceRegistrationState);
            proximity(model.proximity);
            join(model.join);
            connectionStatus(model.connectionStatus);
            messageDeliveryStatus(model.messageDeliveryStatus);
        }

        public final DeviceRegistrationStateEventConfiguration.Builder getDeviceRegistrationState() {
            return deviceRegistrationState != null ? deviceRegistrationState.toBuilder() : null;
        }

        public final void setDeviceRegistrationState(DeviceRegistrationStateEventConfiguration.BuilderImpl deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState != null ? deviceRegistrationState.build() : null;
        }

        @Override
        public final Builder deviceRegistrationState(DeviceRegistrationStateEventConfiguration deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState;
            return this;
        }

        public final ProximityEventConfiguration.Builder getProximity() {
            return proximity != null ? proximity.toBuilder() : null;
        }

        public final void setProximity(ProximityEventConfiguration.BuilderImpl proximity) {
            this.proximity = proximity != null ? proximity.build() : null;
        }

        @Override
        public final Builder proximity(ProximityEventConfiguration proximity) {
            this.proximity = proximity;
            return this;
        }

        public final JoinEventConfiguration.Builder getJoin() {
            return join != null ? join.toBuilder() : null;
        }

        public final void setJoin(JoinEventConfiguration.BuilderImpl join) {
            this.join = join != null ? join.build() : null;
        }

        @Override
        public final Builder join(JoinEventConfiguration join) {
            this.join = join;
            return this;
        }

        public final ConnectionStatusEventConfiguration.Builder getConnectionStatus() {
            return connectionStatus != null ? connectionStatus.toBuilder() : null;
        }

        public final void setConnectionStatus(ConnectionStatusEventConfiguration.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatusEventConfiguration connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        public final MessageDeliveryStatusEventConfiguration.Builder getMessageDeliveryStatus() {
            return messageDeliveryStatus != null ? messageDeliveryStatus.toBuilder() : null;
        }

        public final void setMessageDeliveryStatus(MessageDeliveryStatusEventConfiguration.BuilderImpl messageDeliveryStatus) {
            this.messageDeliveryStatus = messageDeliveryStatus != null ? messageDeliveryStatus.build() : null;
        }

        @Override
        public final Builder messageDeliveryStatus(MessageDeliveryStatusEventConfiguration messageDeliveryStatus) {
            this.messageDeliveryStatus = messageDeliveryStatus;
            return this;
        }

        @Override
        public GetResourceEventConfigurationResponse build() {
            return new GetResourceEventConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
