/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWirelessGatewayStatisticsResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetWirelessGatewayStatisticsResponse.Builder, GetWirelessGatewayStatisticsResponse> {
    private static final SdkField<String> WIRELESS_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WirelessGatewayId").getter(getter(GetWirelessGatewayStatisticsResponse::wirelessGatewayId))
            .setter(setter(Builder::wirelessGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayId").build()).build();

    private static final SdkField<String> LAST_UPLINK_RECEIVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUplinkReceivedAt").getter(getter(GetWirelessGatewayStatisticsResponse::lastUplinkReceivedAt))
            .setter(setter(Builder::lastUplinkReceivedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUplinkReceivedAt").build())
            .build();

    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionStatus").getter(getter(GetWirelessGatewayStatisticsResponse::connectionStatusAsString))
            .setter(setter(Builder::connectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIRELESS_GATEWAY_ID_FIELD,
            LAST_UPLINK_RECEIVED_AT_FIELD, CONNECTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String wirelessGatewayId;

    private final String lastUplinkReceivedAt;

    private final String connectionStatus;

    private GetWirelessGatewayStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.wirelessGatewayId = builder.wirelessGatewayId;
        this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
        this.connectionStatus = builder.connectionStatus;
    }

    /**
     * <p>
     * The ID of the wireless gateway.
     * </p>
     * 
     * @return The ID of the wireless gateway.
     */
    public final String wirelessGatewayId() {
        return wirelessGatewayId;
    }

    /**
     * <p>
     * The date and time when the most recent uplink was received.
     * </p>
     * <note>
     * <p>
     * This value is only valid for 3 months.
     * </p>
     * </note>
     * 
     * @return The date and time when the most recent uplink was received.</p> <note>
     *         <p>
     *         This value is only valid for 3 months.
     *         </p>
     */
    public final String lastUplinkReceivedAt() {
        return lastUplinkReceivedAt;
    }

    /**
     * <p>
     * The connection status of the wireless gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The connection status of the wireless gateway.
     * @see ConnectionStatus
     */
    public final ConnectionStatus connectionStatus() {
        return ConnectionStatus.fromValue(connectionStatus);
    }

    /**
     * <p>
     * The connection status of the wireless gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The connection status of the wireless gateway.
     * @see ConnectionStatus
     */
    public final String connectionStatusAsString() {
        return connectionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(wirelessGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUplinkReceivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessGatewayStatisticsResponse)) {
            return false;
        }
        GetWirelessGatewayStatisticsResponse other = (GetWirelessGatewayStatisticsResponse) obj;
        return Objects.equals(wirelessGatewayId(), other.wirelessGatewayId())
                && Objects.equals(lastUplinkReceivedAt(), other.lastUplinkReceivedAt())
                && Objects.equals(connectionStatusAsString(), other.connectionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWirelessGatewayStatisticsResponse").add("WirelessGatewayId", wirelessGatewayId())
                .add("LastUplinkReceivedAt", lastUplinkReceivedAt()).add("ConnectionStatus", connectionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WirelessGatewayId":
            return Optional.ofNullable(clazz.cast(wirelessGatewayId()));
        case "LastUplinkReceivedAt":
            return Optional.ofNullable(clazz.cast(lastUplinkReceivedAt()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WirelessGatewayId", WIRELESS_GATEWAY_ID_FIELD);
        map.put("LastUplinkReceivedAt", LAST_UPLINK_RECEIVED_AT_FIELD);
        map.put("ConnectionStatus", CONNECTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessGatewayStatisticsResponse, T> g) {
        return obj -> g.apply((GetWirelessGatewayStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWirelessGatewayStatisticsResponse> {
        /**
         * <p>
         * The ID of the wireless gateway.
         * </p>
         * 
         * @param wirelessGatewayId
         *        The ID of the wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewayId(String wirelessGatewayId);

        /**
         * <p>
         * The date and time when the most recent uplink was received.
         * </p>
         * <note>
         * <p>
         * This value is only valid for 3 months.
         * </p>
         * </note>
         * 
         * @param lastUplinkReceivedAt
         *        The date and time when the most recent uplink was received.</p> <note>
         *        <p>
         *        This value is only valid for 3 months.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUplinkReceivedAt(String lastUplinkReceivedAt);

        /**
         * <p>
         * The connection status of the wireless gateway.
         * </p>
         * 
         * @param connectionStatus
         *        The connection status of the wireless gateway.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder connectionStatus(String connectionStatus);

        /**
         * <p>
         * The connection status of the wireless gateway.
         * </p>
         * 
         * @param connectionStatus
         *        The connection status of the wireless gateway.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder connectionStatus(ConnectionStatus connectionStatus);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String wirelessGatewayId;

        private String lastUplinkReceivedAt;

        private String connectionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessGatewayStatisticsResponse model) {
            super(model);
            wirelessGatewayId(model.wirelessGatewayId);
            lastUplinkReceivedAt(model.lastUplinkReceivedAt);
            connectionStatus(model.connectionStatus);
        }

        public final String getWirelessGatewayId() {
            return wirelessGatewayId;
        }

        public final void setWirelessGatewayId(String wirelessGatewayId) {
            this.wirelessGatewayId = wirelessGatewayId;
        }

        @Override
        public final Builder wirelessGatewayId(String wirelessGatewayId) {
            this.wirelessGatewayId = wirelessGatewayId;
            return this;
        }

        public final String getLastUplinkReceivedAt() {
            return lastUplinkReceivedAt;
        }

        public final void setLastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
        }

        @Override
        public final Builder lastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        public final String getConnectionStatus() {
            return connectionStatus;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        @Override
        public GetWirelessGatewayStatisticsResponse build() {
            return new GetWirelessGatewayStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
