/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDestinationsResponse extends IotWirelessResponse implements
        ToCopyableBuilder<ListDestinationsResponse.Builder, ListDestinationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDestinationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Destinations>> DESTINATION_LIST_FIELD = SdkField
            .<List<Destinations>> builder(MarshallingType.LIST)
            .memberName("DestinationList")
            .getter(getter(ListDestinationsResponse::destinationList))
            .setter(setter(Builder::destinationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Destinations> builder(MarshallingType.SDK_POJO)
                                            .constructor(Destinations::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            DESTINATION_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<Destinations> destinationList;

    private ListDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.destinationList = builder.destinationList;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinationList() {
        return destinationList != null && !(destinationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of destinations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationList} method.
     * </p>
     * 
     * @return The list of destinations.
     */
    public final List<Destinations> destinationList() {
        return destinationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationList() ? destinationList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDestinationsResponse)) {
            return false;
        }
        ListDestinationsResponse other = (ListDestinationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasDestinationList() == other.hasDestinationList()
                && Objects.equals(destinationList(), other.destinationList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDestinationsResponse").add("NextToken", nextToken())
                .add("DestinationList", hasDestinationList() ? destinationList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DestinationList":
            return Optional.ofNullable(clazz.cast(destinationList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DestinationList", DESTINATION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDestinationsResponse, T> g) {
        return obj -> g.apply((ListDestinationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDestinationsResponse> {
        /**
         * <p>
         * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of destinations.
         * </p>
         * 
         * @param destinationList
         *        The list of destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationList(Collection<Destinations> destinationList);

        /**
         * <p>
         * The list of destinations.
         * </p>
         * 
         * @param destinationList
         *        The list of destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationList(Destinations... destinationList);

        /**
         * <p>
         * The list of destinations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.Destinations.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotwireless.model.Destinations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.Destinations.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationList(List<Destinations>)}.
         * 
         * @param destinationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.Destinations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationList(java.util.Collection<Destinations>)
         */
        Builder destinationList(Consumer<Destinations.Builder>... destinationList);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Destinations> destinationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDestinationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            destinationList(model.destinationList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Destinations.Builder> getDestinationList() {
            List<Destinations.Builder> result = DestinationListCopier.copyToBuilder(this.destinationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationList(Collection<Destinations.BuilderImpl> destinationList) {
            this.destinationList = DestinationListCopier.copyFromBuilder(destinationList);
        }

        @Override
        public final Builder destinationList(Collection<Destinations> destinationList) {
            this.destinationList = DestinationListCopier.copy(destinationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationList(Destinations... destinationList) {
            destinationList(Arrays.asList(destinationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationList(Consumer<Destinations.Builder>... destinationList) {
            destinationList(Stream.of(destinationList).map(c -> Destinations.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDestinationsResponse build() {
            return new ListDestinationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
