/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventConfigurationsResponse extends IotWirelessResponse implements
        ToCopyableBuilder<ListEventConfigurationsResponse.Builder, ListEventConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEventConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<EventConfigurationItem>> EVENT_CONFIGURATIONS_LIST_FIELD = SdkField
            .<List<EventConfigurationItem>> builder(MarshallingType.LIST)
            .memberName("EventConfigurationsList")
            .getter(getter(ListEventConfigurationsResponse::eventConfigurationsList))
            .setter(setter(Builder::eventConfigurationsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventConfigurationsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventConfigurationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventConfigurationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            EVENT_CONFIGURATIONS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<EventConfigurationItem> eventConfigurationsList;

    private ListEventConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.eventConfigurationsList = builder.eventConfigurationsList;
    }

    /**
     * <p>
     * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     * <b>null</b> to receive the first set of results.
     * </p>
     * 
     * @return To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     *         <b>null</b> to receive the first set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventConfigurationsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEventConfigurationsList() {
        return eventConfigurationsList != null && !(eventConfigurationsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Event configurations of all events for a single resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventConfigurationsList} method.
     * </p>
     * 
     * @return Event configurations of all events for a single resource.
     */
    public final List<EventConfigurationItem> eventConfigurationsList() {
        return eventConfigurationsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventConfigurationsList() ? eventConfigurationsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventConfigurationsResponse)) {
            return false;
        }
        ListEventConfigurationsResponse other = (ListEventConfigurationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasEventConfigurationsList() == other.hasEventConfigurationsList()
                && Objects.equals(eventConfigurationsList(), other.eventConfigurationsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventConfigurationsResponse").add("NextToken", nextToken())
                .add("EventConfigurationsList", hasEventConfigurationsList() ? eventConfigurationsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "EventConfigurationsList":
            return Optional.ofNullable(clazz.cast(eventConfigurationsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("EventConfigurationsList", EVENT_CONFIGURATIONS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEventConfigurationsResponse, T> g) {
        return obj -> g.apply((ListEventConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEventConfigurationsResponse> {
        /**
         * <p>
         * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
         * <b>null</b> to receive the first set of results.
         * </p>
         * 
         * @param nextToken
         *        To retrieve the next set of results, the <code>nextToken</code> value from a previous response;
         *        otherwise <b>null</b> to receive the first set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Event configurations of all events for a single resource.
         * </p>
         * 
         * @param eventConfigurationsList
         *        Event configurations of all events for a single resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfigurationsList(Collection<EventConfigurationItem> eventConfigurationsList);

        /**
         * <p>
         * Event configurations of all events for a single resource.
         * </p>
         * 
         * @param eventConfigurationsList
         *        Event configurations of all events for a single resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfigurationsList(EventConfigurationItem... eventConfigurationsList);

        /**
         * <p>
         * Event configurations of all events for a single resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.EventConfigurationItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotwireless.model.EventConfigurationItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.EventConfigurationItem.Builder#build()} is called
         * immediately and its result is passed to {@link #eventConfigurationsList(List<EventConfigurationItem>)}.
         * 
         * @param eventConfigurationsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.EventConfigurationItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventConfigurationsList(java.util.Collection<EventConfigurationItem>)
         */
        Builder eventConfigurationsList(Consumer<EventConfigurationItem.Builder>... eventConfigurationsList);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<EventConfigurationItem> eventConfigurationsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventConfigurationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            eventConfigurationsList(model.eventConfigurationsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EventConfigurationItem.Builder> getEventConfigurationsList() {
            List<EventConfigurationItem.Builder> result = EventConfigurationsListCopier
                    .copyToBuilder(this.eventConfigurationsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventConfigurationsList(Collection<EventConfigurationItem.BuilderImpl> eventConfigurationsList) {
            this.eventConfigurationsList = EventConfigurationsListCopier.copyFromBuilder(eventConfigurationsList);
        }

        @Override
        public final Builder eventConfigurationsList(Collection<EventConfigurationItem> eventConfigurationsList) {
            this.eventConfigurationsList = EventConfigurationsListCopier.copy(eventConfigurationsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventConfigurationsList(EventConfigurationItem... eventConfigurationsList) {
            eventConfigurationsList(Arrays.asList(eventConfigurationsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventConfigurationsList(Consumer<EventConfigurationItem.Builder>... eventConfigurationsList) {
            eventConfigurationsList(Stream.of(eventConfigurationsList)
                    .map(c -> EventConfigurationItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEventConfigurationsResponse build() {
            return new ListEventConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
