/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueuedMessagesResponse extends IotWirelessResponse implements
        ToCopyableBuilder<ListQueuedMessagesResponse.Builder, ListQueuedMessagesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListQueuedMessagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<DownlinkQueueMessage>> DOWNLINK_QUEUE_MESSAGES_LIST_FIELD = SdkField
            .<List<DownlinkQueueMessage>> builder(MarshallingType.LIST)
            .memberName("DownlinkQueueMessagesList")
            .getter(getter(ListQueuedMessagesResponse::downlinkQueueMessagesList))
            .setter(setter(Builder::downlinkQueueMessagesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownlinkQueueMessagesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DownlinkQueueMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(DownlinkQueueMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            DOWNLINK_QUEUE_MESSAGES_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<DownlinkQueueMessage> downlinkQueueMessagesList;

    private ListQueuedMessagesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.downlinkQueueMessagesList = builder.downlinkQueueMessagesList;
    }

    /**
     * <p>
     * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     * <b>null</b> to receive the first set of results.
     * </p>
     * 
     * @return To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     *         <b>null</b> to receive the first set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DownlinkQueueMessagesList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDownlinkQueueMessagesList() {
        return downlinkQueueMessagesList != null && !(downlinkQueueMessagesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The messages in the downlink queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDownlinkQueueMessagesList} method.
     * </p>
     * 
     * @return The messages in the downlink queue.
     */
    public final List<DownlinkQueueMessage> downlinkQueueMessagesList() {
        return downlinkQueueMessagesList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasDownlinkQueueMessagesList() ? downlinkQueueMessagesList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuedMessagesResponse)) {
            return false;
        }
        ListQueuedMessagesResponse other = (ListQueuedMessagesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasDownlinkQueueMessagesList() == other.hasDownlinkQueueMessagesList()
                && Objects.equals(downlinkQueueMessagesList(), other.downlinkQueueMessagesList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueuedMessagesResponse").add("NextToken", nextToken())
                .add("DownlinkQueueMessagesList", hasDownlinkQueueMessagesList() ? downlinkQueueMessagesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DownlinkQueueMessagesList":
            return Optional.ofNullable(clazz.cast(downlinkQueueMessagesList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DownlinkQueueMessagesList", DOWNLINK_QUEUE_MESSAGES_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueuedMessagesResponse, T> g) {
        return obj -> g.apply((ListQueuedMessagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListQueuedMessagesResponse> {
        /**
         * <p>
         * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
         * <b>null</b> to receive the first set of results.
         * </p>
         * 
         * @param nextToken
         *        To retrieve the next set of results, the <code>nextToken</code> value from a previous response;
         *        otherwise <b>null</b> to receive the first set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The messages in the downlink queue.
         * </p>
         * 
         * @param downlinkQueueMessagesList
         *        The messages in the downlink queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkQueueMessagesList(Collection<DownlinkQueueMessage> downlinkQueueMessagesList);

        /**
         * <p>
         * The messages in the downlink queue.
         * </p>
         * 
         * @param downlinkQueueMessagesList
         *        The messages in the downlink queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkQueueMessagesList(DownlinkQueueMessage... downlinkQueueMessagesList);

        /**
         * <p>
         * The messages in the downlink queue.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.DownlinkQueueMessage.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotwireless.model.DownlinkQueueMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.DownlinkQueueMessage.Builder#build()} is called
         * immediately and its result is passed to {@link #downlinkQueueMessagesList(List<DownlinkQueueMessage>)}.
         * 
         * @param downlinkQueueMessagesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.DownlinkQueueMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #downlinkQueueMessagesList(java.util.Collection<DownlinkQueueMessage>)
         */
        Builder downlinkQueueMessagesList(Consumer<DownlinkQueueMessage.Builder>... downlinkQueueMessagesList);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<DownlinkQueueMessage> downlinkQueueMessagesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuedMessagesResponse model) {
            super(model);
            nextToken(model.nextToken);
            downlinkQueueMessagesList(model.downlinkQueueMessagesList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DownlinkQueueMessage.Builder> getDownlinkQueueMessagesList() {
            List<DownlinkQueueMessage.Builder> result = DownlinkQueueMessagesListCopier
                    .copyToBuilder(this.downlinkQueueMessagesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDownlinkQueueMessagesList(Collection<DownlinkQueueMessage.BuilderImpl> downlinkQueueMessagesList) {
            this.downlinkQueueMessagesList = DownlinkQueueMessagesListCopier.copyFromBuilder(downlinkQueueMessagesList);
        }

        @Override
        public final Builder downlinkQueueMessagesList(Collection<DownlinkQueueMessage> downlinkQueueMessagesList) {
            this.downlinkQueueMessagesList = DownlinkQueueMessagesListCopier.copy(downlinkQueueMessagesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder downlinkQueueMessagesList(DownlinkQueueMessage... downlinkQueueMessagesList) {
            downlinkQueueMessagesList(Arrays.asList(downlinkQueueMessagesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder downlinkQueueMessagesList(Consumer<DownlinkQueueMessage.Builder>... downlinkQueueMessagesList) {
            downlinkQueueMessagesList(Stream.of(downlinkQueueMessagesList)
                    .map(c -> DownlinkQueueMessage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListQueuedMessagesResponse build() {
            return new ListQueuedMessagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
