/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWirelessDeviceImportTasksResponse extends IotWirelessResponse implements
        ToCopyableBuilder<ListWirelessDeviceImportTasksResponse.Builder, ListWirelessDeviceImportTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWirelessDeviceImportTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<WirelessDeviceImportTask>> WIRELESS_DEVICE_IMPORT_TASK_LIST_FIELD = SdkField
            .<List<WirelessDeviceImportTask>> builder(MarshallingType.LIST)
            .memberName("WirelessDeviceImportTaskList")
            .getter(getter(ListWirelessDeviceImportTasksResponse::wirelessDeviceImportTaskList))
            .setter(setter(Builder::wirelessDeviceImportTaskList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceImportTaskList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WirelessDeviceImportTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(WirelessDeviceImportTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WIRELESS_DEVICE_IMPORT_TASK_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<WirelessDeviceImportTask> wirelessDeviceImportTaskList;

    private ListWirelessDeviceImportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.wirelessDeviceImportTaskList = builder.wirelessDeviceImportTaskList;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <code>null</code> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <code>null</code> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessDeviceImportTaskList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWirelessDeviceImportTaskList() {
        return wirelessDeviceImportTaskList != null && !(wirelessDeviceImportTaskList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of import tasks and summary information of onboarding status of devices in each import task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessDeviceImportTaskList} method.
     * </p>
     * 
     * @return List of import tasks and summary information of onboarding status of devices in each import task.
     */
    public final List<WirelessDeviceImportTask> wirelessDeviceImportTaskList() {
        return wirelessDeviceImportTaskList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessDeviceImportTaskList() ? wirelessDeviceImportTaskList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWirelessDeviceImportTasksResponse)) {
            return false;
        }
        ListWirelessDeviceImportTasksResponse other = (ListWirelessDeviceImportTasksResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasWirelessDeviceImportTaskList() == other.hasWirelessDeviceImportTaskList()
                && Objects.equals(wirelessDeviceImportTaskList(), other.wirelessDeviceImportTaskList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWirelessDeviceImportTasksResponse").add("NextToken", nextToken())
                .add("WirelessDeviceImportTaskList", hasWirelessDeviceImportTaskList() ? wirelessDeviceImportTaskList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WirelessDeviceImportTaskList":
            return Optional.ofNullable(clazz.cast(wirelessDeviceImportTaskList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WirelessDeviceImportTaskList", WIRELESS_DEVICE_IMPORT_TASK_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWirelessDeviceImportTasksResponse, T> g) {
        return obj -> g.apply((ListWirelessDeviceImportTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWirelessDeviceImportTasksResponse> {
        /**
         * <p>
         * The token to use to get the next set of results, or <code>null</code> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <code>null</code> if there are no additional
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of import tasks and summary information of onboarding status of devices in each import task.
         * </p>
         * 
         * @param wirelessDeviceImportTaskList
         *        List of import tasks and summary information of onboarding status of devices in each import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDeviceImportTaskList(Collection<WirelessDeviceImportTask> wirelessDeviceImportTaskList);

        /**
         * <p>
         * List of import tasks and summary information of onboarding status of devices in each import task.
         * </p>
         * 
         * @param wirelessDeviceImportTaskList
         *        List of import tasks and summary information of onboarding status of devices in each import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDeviceImportTaskList(WirelessDeviceImportTask... wirelessDeviceImportTaskList);

        /**
         * <p>
         * List of import tasks and summary information of onboarding status of devices in each import task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.WirelessDeviceImportTask.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotwireless.model.WirelessDeviceImportTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.WirelessDeviceImportTask.Builder#build()} is called
         * immediately and its result is passed to {@link #wirelessDeviceImportTaskList(List<WirelessDeviceImportTask>)}.
         * 
         * @param wirelessDeviceImportTaskList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.WirelessDeviceImportTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wirelessDeviceImportTaskList(java.util.Collection<WirelessDeviceImportTask>)
         */
        Builder wirelessDeviceImportTaskList(Consumer<WirelessDeviceImportTask.Builder>... wirelessDeviceImportTaskList);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<WirelessDeviceImportTask> wirelessDeviceImportTaskList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWirelessDeviceImportTasksResponse model) {
            super(model);
            nextToken(model.nextToken);
            wirelessDeviceImportTaskList(model.wirelessDeviceImportTaskList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WirelessDeviceImportTask.Builder> getWirelessDeviceImportTaskList() {
            List<WirelessDeviceImportTask.Builder> result = WirelessDeviceImportTaskListCopier
                    .copyToBuilder(this.wirelessDeviceImportTaskList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWirelessDeviceImportTaskList(
                Collection<WirelessDeviceImportTask.BuilderImpl> wirelessDeviceImportTaskList) {
            this.wirelessDeviceImportTaskList = WirelessDeviceImportTaskListCopier.copyFromBuilder(wirelessDeviceImportTaskList);
        }

        @Override
        public final Builder wirelessDeviceImportTaskList(Collection<WirelessDeviceImportTask> wirelessDeviceImportTaskList) {
            this.wirelessDeviceImportTaskList = WirelessDeviceImportTaskListCopier.copy(wirelessDeviceImportTaskList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceImportTaskList(WirelessDeviceImportTask... wirelessDeviceImportTaskList) {
            wirelessDeviceImportTaskList(Arrays.asList(wirelessDeviceImportTaskList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceImportTaskList(
                Consumer<WirelessDeviceImportTask.Builder>... wirelessDeviceImportTaskList) {
            wirelessDeviceImportTaskList(Stream.of(wirelessDeviceImportTaskList)
                    .map(c -> WirelessDeviceImportTask.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWirelessDeviceImportTasksResponse build() {
            return new ListWirelessDeviceImportTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
