/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWirelessDevicesRequest extends IotWirelessRequest implements
        ToCopyableBuilder<ListWirelessDevicesRequest.Builder, ListWirelessDevicesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListWirelessDevicesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWirelessDevicesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(ListWirelessDevicesRequest::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destinationName").build())
            .build();

    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceProfileId").getter(getter(ListWirelessDevicesRequest::deviceProfileId))
            .setter(setter(Builder::deviceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deviceProfileId").build())
            .build();

    private static final SdkField<String> SERVICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceProfileId").getter(getter(ListWirelessDevicesRequest::serviceProfileId))
            .setter(setter(Builder::serviceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("serviceProfileId").build())
            .build();

    private static final SdkField<String> WIRELESS_DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WirelessDeviceType").getter(getter(ListWirelessDevicesRequest::wirelessDeviceTypeAsString))
            .setter(setter(Builder::wirelessDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("wirelessDeviceType").build())
            .build();

    private static final SdkField<String> FUOTA_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FuotaTaskId").getter(getter(ListWirelessDevicesRequest::fuotaTaskId))
            .setter(setter(Builder::fuotaTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fuotaTaskId").build()).build();

    private static final SdkField<String> MULTICAST_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MulticastGroupId").getter(getter(ListWirelessDevicesRequest::multicastGroupId))
            .setter(setter(Builder::multicastGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("multicastGroupId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, DESTINATION_NAME_FIELD, DEVICE_PROFILE_ID_FIELD, SERVICE_PROFILE_ID_FIELD,
            WIRELESS_DEVICE_TYPE_FIELD, FUOTA_TASK_ID_FIELD, MULTICAST_GROUP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String destinationName;

    private final String deviceProfileId;

    private final String serviceProfileId;

    private final String wirelessDeviceType;

    private final String fuotaTaskId;

    private final String multicastGroupId;

    private ListWirelessDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.destinationName = builder.destinationName;
        this.deviceProfileId = builder.deviceProfileId;
        this.serviceProfileId = builder.serviceProfileId;
        this.wirelessDeviceType = builder.wirelessDeviceType;
        this.fuotaTaskId = builder.fuotaTaskId;
        this.multicastGroupId = builder.multicastGroupId;
    }

    /**
     * <p>
     * The maximum number of results to return in this operation.
     * </p>
     * 
     * @return The maximum number of results to return in this operation.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     * <b>null</b> to receive the first set of results.
     * </p>
     * 
     * @return To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     *         <b>null</b> to receive the first set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A filter to list only the wireless devices that use as uplink destination.
     * </p>
     * 
     * @return A filter to list only the wireless devices that use as uplink destination.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * A filter to list only the wireless devices that use this device profile.
     * </p>
     * 
     * @return A filter to list only the wireless devices that use this device profile.
     */
    public final String deviceProfileId() {
        return deviceProfileId;
    }

    /**
     * <p>
     * A filter to list only the wireless devices that use this service profile.
     * </p>
     * 
     * @return A filter to list only the wireless devices that use this service profile.
     */
    public final String serviceProfileId() {
        return serviceProfileId;
    }

    /**
     * <p>
     * A filter to list only the wireless devices that use this wireless device type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessDeviceType} will return {@link WirelessDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #wirelessDeviceTypeAsString}.
     * </p>
     * 
     * @return A filter to list only the wireless devices that use this wireless device type.
     * @see WirelessDeviceType
     */
    public final WirelessDeviceType wirelessDeviceType() {
        return WirelessDeviceType.fromValue(wirelessDeviceType);
    }

    /**
     * <p>
     * A filter to list only the wireless devices that use this wireless device type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessDeviceType} will return {@link WirelessDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #wirelessDeviceTypeAsString}.
     * </p>
     * 
     * @return A filter to list only the wireless devices that use this wireless device type.
     * @see WirelessDeviceType
     */
    public final String wirelessDeviceTypeAsString() {
        return wirelessDeviceType;
    }

    /**
     * Returns the value of the FuotaTaskId property for this object.
     * 
     * @return The value of the FuotaTaskId property for this object.
     */
    public final String fuotaTaskId() {
        return fuotaTaskId;
    }

    /**
     * Returns the value of the MulticastGroupId property for this object.
     * 
     * @return The value of the MulticastGroupId property for this object.
     */
    public final String multicastGroupId() {
        return multicastGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(wirelessDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fuotaTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(multicastGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWirelessDevicesRequest)) {
            return false;
        }
        ListWirelessDevicesRequest other = (ListWirelessDevicesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(destinationName(), other.destinationName())
                && Objects.equals(deviceProfileId(), other.deviceProfileId())
                && Objects.equals(serviceProfileId(), other.serviceProfileId())
                && Objects.equals(wirelessDeviceTypeAsString(), other.wirelessDeviceTypeAsString())
                && Objects.equals(fuotaTaskId(), other.fuotaTaskId())
                && Objects.equals(multicastGroupId(), other.multicastGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWirelessDevicesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("DestinationName", destinationName()).add("DeviceProfileId", deviceProfileId())
                .add("ServiceProfileId", serviceProfileId()).add("WirelessDeviceType", wirelessDeviceTypeAsString())
                .add("FuotaTaskId", fuotaTaskId()).add("MulticastGroupId", multicastGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "DeviceProfileId":
            return Optional.ofNullable(clazz.cast(deviceProfileId()));
        case "ServiceProfileId":
            return Optional.ofNullable(clazz.cast(serviceProfileId()));
        case "WirelessDeviceType":
            return Optional.ofNullable(clazz.cast(wirelessDeviceTypeAsString()));
        case "FuotaTaskId":
            return Optional.ofNullable(clazz.cast(fuotaTaskId()));
        case "MulticastGroupId":
            return Optional.ofNullable(clazz.cast(multicastGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("destinationName", DESTINATION_NAME_FIELD);
        map.put("deviceProfileId", DEVICE_PROFILE_ID_FIELD);
        map.put("serviceProfileId", SERVICE_PROFILE_ID_FIELD);
        map.put("wirelessDeviceType", WIRELESS_DEVICE_TYPE_FIELD);
        map.put("fuotaTaskId", FUOTA_TASK_ID_FIELD);
        map.put("multicastGroupId", MULTICAST_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWirelessDevicesRequest, T> g) {
        return obj -> g.apply((ListWirelessDevicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListWirelessDevicesRequest> {
        /**
         * <p>
         * The maximum number of results to return in this operation.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
         * <b>null</b> to receive the first set of results.
         * </p>
         * 
         * @param nextToken
         *        To retrieve the next set of results, the <code>nextToken</code> value from a previous response;
         *        otherwise <b>null</b> to receive the first set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A filter to list only the wireless devices that use as uplink destination.
         * </p>
         * 
         * @param destinationName
         *        A filter to list only the wireless devices that use as uplink destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * A filter to list only the wireless devices that use this device profile.
         * </p>
         * 
         * @param deviceProfileId
         *        A filter to list only the wireless devices that use this device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceProfileId(String deviceProfileId);

        /**
         * <p>
         * A filter to list only the wireless devices that use this service profile.
         * </p>
         * 
         * @param serviceProfileId
         *        A filter to list only the wireless devices that use this service profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceProfileId(String serviceProfileId);

        /**
         * <p>
         * A filter to list only the wireless devices that use this wireless device type.
         * </p>
         * 
         * @param wirelessDeviceType
         *        A filter to list only the wireless devices that use this wireless device type.
         * @see WirelessDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceType
         */
        Builder wirelessDeviceType(String wirelessDeviceType);

        /**
         * <p>
         * A filter to list only the wireless devices that use this wireless device type.
         * </p>
         * 
         * @param wirelessDeviceType
         *        A filter to list only the wireless devices that use this wireless device type.
         * @see WirelessDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceType
         */
        Builder wirelessDeviceType(WirelessDeviceType wirelessDeviceType);

        /**
         * Sets the value of the FuotaTaskId property for this object.
         *
         * @param fuotaTaskId
         *        The new value for the FuotaTaskId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fuotaTaskId(String fuotaTaskId);

        /**
         * Sets the value of the MulticastGroupId property for this object.
         *
         * @param multicastGroupId
         *        The new value for the MulticastGroupId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastGroupId(String multicastGroupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String destinationName;

        private String deviceProfileId;

        private String serviceProfileId;

        private String wirelessDeviceType;

        private String fuotaTaskId;

        private String multicastGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWirelessDevicesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            destinationName(model.destinationName);
            deviceProfileId(model.deviceProfileId);
            serviceProfileId(model.serviceProfileId);
            wirelessDeviceType(model.wirelessDeviceType);
            fuotaTaskId(model.fuotaTaskId);
            multicastGroupId(model.multicastGroupId);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getDeviceProfileId() {
            return deviceProfileId;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final String getServiceProfileId() {
            return serviceProfileId;
        }

        public final void setServiceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
        }

        @Override
        public final Builder serviceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
            return this;
        }

        public final String getWirelessDeviceType() {
            return wirelessDeviceType;
        }

        public final void setWirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
        }

        @Override
        public final Builder wirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
            return this;
        }

        @Override
        public final Builder wirelessDeviceType(WirelessDeviceType wirelessDeviceType) {
            this.wirelessDeviceType(wirelessDeviceType == null ? null : wirelessDeviceType.toString());
            return this;
        }

        public final String getFuotaTaskId() {
            return fuotaTaskId;
        }

        public final void setFuotaTaskId(String fuotaTaskId) {
            this.fuotaTaskId = fuotaTaskId;
        }

        @Override
        public final Builder fuotaTaskId(String fuotaTaskId) {
            this.fuotaTaskId = fuotaTaskId;
            return this;
        }

        public final String getMulticastGroupId() {
            return multicastGroupId;
        }

        public final void setMulticastGroupId(String multicastGroupId) {
            this.multicastGroupId = multicastGroupId;
        }

        @Override
        public final Builder multicastGroupId(String multicastGroupId) {
            this.multicastGroupId = multicastGroupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWirelessDevicesRequest build() {
            return new ListWirelessDevicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
