/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWANGateway object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANGateway implements SdkPojo, Serializable, ToCopyableBuilder<LoRaWANGateway.Builder, LoRaWANGateway> {
    private static final SdkField<String> GATEWAY_EUI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayEui").getter(getter(LoRaWANGateway::gatewayEui)).setter(setter(Builder::gatewayEui))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayEui").build()).build();

    private static final SdkField<String> RF_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RfRegion").getter(getter(LoRaWANGateway::rfRegion)).setter(setter(Builder::rfRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RfRegion").build()).build();

    private static final SdkField<List<List<String>>> JOIN_EUI_FILTERS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("JoinEuiFilters")
            .getter(getter(LoRaWANGateway::joinEuiFilters))
            .setter(setter(Builder::joinEuiFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinEuiFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> NET_ID_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetIdFilters")
            .getter(getter(LoRaWANGateway::netIdFilters))
            .setter(setter(Builder::netIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> SUB_BANDS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("SubBands")
            .getter(getter(LoRaWANGateway::subBands))
            .setter(setter(Builder::subBands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubBands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Beaconing> BEACONING_FIELD = SdkField.<Beaconing> builder(MarshallingType.SDK_POJO)
            .memberName("Beaconing").getter(getter(LoRaWANGateway::beaconing)).setter(setter(Builder::beaconing))
            .constructor(Beaconing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Beaconing").build()).build();

    private static final SdkField<Float> MAX_EIRP_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("MaxEirp")
            .getter(getter(LoRaWANGateway::maxEirp)).setter(setter(Builder::maxEirp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEirp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_EUI_FIELD,
            RF_REGION_FIELD, JOIN_EUI_FILTERS_FIELD, NET_ID_FILTERS_FIELD, SUB_BANDS_FIELD, BEACONING_FIELD, MAX_EIRP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String gatewayEui;

    private final String rfRegion;

    private final List<List<String>> joinEuiFilters;

    private final List<String> netIdFilters;

    private final List<Integer> subBands;

    private final Beaconing beaconing;

    private final Float maxEirp;

    private LoRaWANGateway(BuilderImpl builder) {
        this.gatewayEui = builder.gatewayEui;
        this.rfRegion = builder.rfRegion;
        this.joinEuiFilters = builder.joinEuiFilters;
        this.netIdFilters = builder.netIdFilters;
        this.subBands = builder.subBands;
        this.beaconing = builder.beaconing;
        this.maxEirp = builder.maxEirp;
    }

    /**
     * <p>
     * The gateway's EUI value.
     * </p>
     * 
     * @return The gateway's EUI value.
     */
    public final String gatewayEui() {
        return gatewayEui;
    }

    /**
     * <p>
     * The frequency band (RFRegion) value.
     * </p>
     * 
     * @return The frequency band (RFRegion) value.
     */
    public final String rfRegion() {
        return rfRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the JoinEuiFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJoinEuiFilters() {
        return joinEuiFilters != null && !(joinEuiFilters instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the JoinEuiFilters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJoinEuiFilters} method.
     * </p>
     * 
     * @return The value of the JoinEuiFilters property for this object.
     */
    public final List<List<String>> joinEuiFilters() {
        return joinEuiFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetIdFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetIdFilters() {
        return netIdFilters != null && !(netIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the NetIdFilters property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetIdFilters} method.
     * </p>
     * 
     * @return The value of the NetIdFilters property for this object.
     */
    public final List<String> netIdFilters() {
        return netIdFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubBands property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubBands() {
        return subBands != null && !(subBands instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SubBands property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubBands} method.
     * </p>
     * 
     * @return The value of the SubBands property for this object.
     */
    public final List<Integer> subBands() {
        return subBands;
    }

    /**
     * <p>
     * Beaconing object information, which consists of the data rate and frequency parameters.
     * </p>
     * 
     * @return Beaconing object information, which consists of the data rate and frequency parameters.
     */
    public final Beaconing beaconing() {
        return beaconing;
    }

    /**
     * <p>
     * The MaxEIRP value.
     * </p>
     * 
     * @return The MaxEIRP value.
     */
    public final Float maxEirp() {
        return maxEirp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayEui());
        hashCode = 31 * hashCode + Objects.hashCode(rfRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasJoinEuiFilters() ? joinEuiFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetIdFilters() ? netIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubBands() ? subBands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(beaconing());
        hashCode = 31 * hashCode + Objects.hashCode(maxEirp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANGateway)) {
            return false;
        }
        LoRaWANGateway other = (LoRaWANGateway) obj;
        return Objects.equals(gatewayEui(), other.gatewayEui()) && Objects.equals(rfRegion(), other.rfRegion())
                && hasJoinEuiFilters() == other.hasJoinEuiFilters() && Objects.equals(joinEuiFilters(), other.joinEuiFilters())
                && hasNetIdFilters() == other.hasNetIdFilters() && Objects.equals(netIdFilters(), other.netIdFilters())
                && hasSubBands() == other.hasSubBands() && Objects.equals(subBands(), other.subBands())
                && Objects.equals(beaconing(), other.beaconing()) && Objects.equals(maxEirp(), other.maxEirp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANGateway").add("GatewayEui", gatewayEui()).add("RfRegion", rfRegion())
                .add("JoinEuiFilters", hasJoinEuiFilters() ? joinEuiFilters() : null)
                .add("NetIdFilters", hasNetIdFilters() ? netIdFilters() : null)
                .add("SubBands", hasSubBands() ? subBands() : null).add("Beaconing", beaconing()).add("MaxEirp", maxEirp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayEui":
            return Optional.ofNullable(clazz.cast(gatewayEui()));
        case "RfRegion":
            return Optional.ofNullable(clazz.cast(rfRegion()));
        case "JoinEuiFilters":
            return Optional.ofNullable(clazz.cast(joinEuiFilters()));
        case "NetIdFilters":
            return Optional.ofNullable(clazz.cast(netIdFilters()));
        case "SubBands":
            return Optional.ofNullable(clazz.cast(subBands()));
        case "Beaconing":
            return Optional.ofNullable(clazz.cast(beaconing()));
        case "MaxEirp":
            return Optional.ofNullable(clazz.cast(maxEirp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayEui", GATEWAY_EUI_FIELD);
        map.put("RfRegion", RF_REGION_FIELD);
        map.put("JoinEuiFilters", JOIN_EUI_FILTERS_FIELD);
        map.put("NetIdFilters", NET_ID_FILTERS_FIELD);
        map.put("SubBands", SUB_BANDS_FIELD);
        map.put("Beaconing", BEACONING_FIELD);
        map.put("MaxEirp", MAX_EIRP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANGateway, T> g) {
        return obj -> g.apply((LoRaWANGateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANGateway> {
        /**
         * <p>
         * The gateway's EUI value.
         * </p>
         * 
         * @param gatewayEui
         *        The gateway's EUI value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayEui(String gatewayEui);

        /**
         * <p>
         * The frequency band (RFRegion) value.
         * </p>
         * 
         * @param rfRegion
         *        The frequency band (RFRegion) value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rfRegion(String rfRegion);

        /**
         * Sets the value of the JoinEuiFilters property for this object.
         *
         * @param joinEuiFilters
         *        The new value for the JoinEuiFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinEuiFilters(Collection<? extends Collection<String>> joinEuiFilters);

        /**
         * Sets the value of the JoinEuiFilters property for this object.
         *
         * @param joinEuiFilters
         *        The new value for the JoinEuiFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinEuiFilters(Collection<String>... joinEuiFilters);

        /**
         * Sets the value of the NetIdFilters property for this object.
         *
         * @param netIdFilters
         *        The new value for the NetIdFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netIdFilters(Collection<String> netIdFilters);

        /**
         * Sets the value of the NetIdFilters property for this object.
         *
         * @param netIdFilters
         *        The new value for the NetIdFilters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netIdFilters(String... netIdFilters);

        /**
         * Sets the value of the SubBands property for this object.
         *
         * @param subBands
         *        The new value for the SubBands property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subBands(Collection<Integer> subBands);

        /**
         * Sets the value of the SubBands property for this object.
         *
         * @param subBands
         *        The new value for the SubBands property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subBands(Integer... subBands);

        /**
         * <p>
         * Beaconing object information, which consists of the data rate and frequency parameters.
         * </p>
         * 
         * @param beaconing
         *        Beaconing object information, which consists of the data rate and frequency parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beaconing(Beaconing beaconing);

        /**
         * <p>
         * Beaconing object information, which consists of the data rate and frequency parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link Beaconing.Builder} avoiding the need to
         * create one manually via {@link Beaconing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Beaconing.Builder#build()} is called immediately and its result
         * is passed to {@link #beaconing(Beaconing)}.
         * 
         * @param beaconing
         *        a consumer that will call methods on {@link Beaconing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #beaconing(Beaconing)
         */
        default Builder beaconing(Consumer<Beaconing.Builder> beaconing) {
            return beaconing(Beaconing.builder().applyMutation(beaconing).build());
        }

        /**
         * <p>
         * The MaxEIRP value.
         * </p>
         * 
         * @param maxEirp
         *        The MaxEIRP value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxEirp(Float maxEirp);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayEui;

        private String rfRegion;

        private List<List<String>> joinEuiFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> netIdFilters = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> subBands = DefaultSdkAutoConstructList.getInstance();

        private Beaconing beaconing;

        private Float maxEirp;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANGateway model) {
            gatewayEui(model.gatewayEui);
            rfRegion(model.rfRegion);
            joinEuiFilters(model.joinEuiFilters);
            netIdFilters(model.netIdFilters);
            subBands(model.subBands);
            beaconing(model.beaconing);
            maxEirp(model.maxEirp);
        }

        public final String getGatewayEui() {
            return gatewayEui;
        }

        public final void setGatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
        }

        @Override
        public final Builder gatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
            return this;
        }

        public final String getRfRegion() {
            return rfRegion;
        }

        public final void setRfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
        }

        @Override
        public final Builder rfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
            return this;
        }

        public final Collection<? extends Collection<String>> getJoinEuiFilters() {
            if (joinEuiFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return joinEuiFilters;
        }

        public final void setJoinEuiFilters(Collection<? extends Collection<String>> joinEuiFilters) {
            this.joinEuiFilters = JoinEuiFiltersCopier.copy(joinEuiFilters);
        }

        @Override
        public final Builder joinEuiFilters(Collection<? extends Collection<String>> joinEuiFilters) {
            this.joinEuiFilters = JoinEuiFiltersCopier.copy(joinEuiFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinEuiFilters(Collection<String>... joinEuiFilters) {
            joinEuiFilters(Arrays.asList(joinEuiFilters));
            return this;
        }

        public final Collection<String> getNetIdFilters() {
            if (netIdFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return netIdFilters;
        }

        public final void setNetIdFilters(Collection<String> netIdFilters) {
            this.netIdFilters = NetIdFiltersCopier.copy(netIdFilters);
        }

        @Override
        public final Builder netIdFilters(Collection<String> netIdFilters) {
            this.netIdFilters = NetIdFiltersCopier.copy(netIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder netIdFilters(String... netIdFilters) {
            netIdFilters(Arrays.asList(netIdFilters));
            return this;
        }

        public final Collection<Integer> getSubBands() {
            if (subBands instanceof SdkAutoConstructList) {
                return null;
            }
            return subBands;
        }

        public final void setSubBands(Collection<Integer> subBands) {
            this.subBands = SubBandsCopier.copy(subBands);
        }

        @Override
        public final Builder subBands(Collection<Integer> subBands) {
            this.subBands = SubBandsCopier.copy(subBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBands(Integer... subBands) {
            subBands(Arrays.asList(subBands));
            return this;
        }

        public final Beaconing.Builder getBeaconing() {
            return beaconing != null ? beaconing.toBuilder() : null;
        }

        public final void setBeaconing(Beaconing.BuilderImpl beaconing) {
            this.beaconing = beaconing != null ? beaconing.build() : null;
        }

        @Override
        public final Builder beaconing(Beaconing beaconing) {
            this.beaconing = beaconing;
            return this;
        }

        public final Float getMaxEirp() {
            return maxEirp;
        }

        public final void setMaxEirp(Float maxEirp) {
            this.maxEirp = maxEirp;
        }

        @Override
        public final Builder maxEirp(Float maxEirp) {
            this.maxEirp = maxEirp;
            return this;
        }

        @Override
        public LoRaWANGateway build() {
            return new LoRaWANGateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
