/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWAN gateway metatdata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANGatewayMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANGatewayMetadata.Builder, LoRaWANGatewayMetadata> {
    private static final SdkField<String> GATEWAY_EUI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayEui").getter(getter(LoRaWANGatewayMetadata::gatewayEui)).setter(setter(Builder::gatewayEui))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayEui").build()).build();

    private static final SdkField<Double> SNR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Snr")
            .getter(getter(LoRaWANGatewayMetadata::snr)).setter(setter(Builder::snr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snr").build()).build();

    private static final SdkField<Double> RSSI_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Rssi")
            .getter(getter(LoRaWANGatewayMetadata::rssi)).setter(setter(Builder::rssi))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rssi").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_EUI_FIELD, SNR_FIELD,
            RSSI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String gatewayEui;

    private final Double snr;

    private final Double rssi;

    private LoRaWANGatewayMetadata(BuilderImpl builder) {
        this.gatewayEui = builder.gatewayEui;
        this.snr = builder.snr;
        this.rssi = builder.rssi;
    }

    /**
     * <p>
     * The gateway's EUI value.
     * </p>
     * 
     * @return The gateway's EUI value.
     */
    public final String gatewayEui() {
        return gatewayEui;
    }

    /**
     * <p>
     * The SNR value.
     * </p>
     * 
     * @return The SNR value.
     */
    public final Double snr() {
        return snr;
    }

    /**
     * <p>
     * The RSSI value.
     * </p>
     * 
     * @return The RSSI value.
     */
    public final Double rssi() {
        return rssi;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayEui());
        hashCode = 31 * hashCode + Objects.hashCode(snr());
        hashCode = 31 * hashCode + Objects.hashCode(rssi());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANGatewayMetadata)) {
            return false;
        }
        LoRaWANGatewayMetadata other = (LoRaWANGatewayMetadata) obj;
        return Objects.equals(gatewayEui(), other.gatewayEui()) && Objects.equals(snr(), other.snr())
                && Objects.equals(rssi(), other.rssi());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANGatewayMetadata").add("GatewayEui", gatewayEui()).add("Snr", snr()).add("Rssi", rssi())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayEui":
            return Optional.ofNullable(clazz.cast(gatewayEui()));
        case "Snr":
            return Optional.ofNullable(clazz.cast(snr()));
        case "Rssi":
            return Optional.ofNullable(clazz.cast(rssi()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayEui", GATEWAY_EUI_FIELD);
        map.put("Snr", SNR_FIELD);
        map.put("Rssi", RSSI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANGatewayMetadata, T> g) {
        return obj -> g.apply((LoRaWANGatewayMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANGatewayMetadata> {
        /**
         * <p>
         * The gateway's EUI value.
         * </p>
         * 
         * @param gatewayEui
         *        The gateway's EUI value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayEui(String gatewayEui);

        /**
         * <p>
         * The SNR value.
         * </p>
         * 
         * @param snr
         *        The SNR value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snr(Double snr);

        /**
         * <p>
         * The RSSI value.
         * </p>
         * 
         * @param rssi
         *        The RSSI value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rssi(Double rssi);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayEui;

        private Double snr;

        private Double rssi;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANGatewayMetadata model) {
            gatewayEui(model.gatewayEui);
            snr(model.snr);
            rssi(model.rssi);
        }

        public final String getGatewayEui() {
            return gatewayEui;
        }

        public final void setGatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
        }

        @Override
        public final Builder gatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
            return this;
        }

        public final Double getSnr() {
            return snr;
        }

        public final void setSnr(Double snr) {
            this.snr = snr;
        }

        @Override
        public final Builder snr(Double snr) {
            this.snr = snr;
            return this;
        }

        public final Double getRssi() {
            return rssi;
        }

        public final void setRssi(Double rssi) {
            this.rssi = rssi;
        }

        @Override
        public final Builder rssi(Double rssi) {
            this.rssi = rssi;
            return this;
        }

        @Override
        public LoRaWANGatewayMetadata build() {
            return new LoRaWANGatewayMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
