/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWANGatewayVersion object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANGatewayVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANGatewayVersion.Builder, LoRaWANGatewayVersion> {
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(LoRaWANGatewayVersion::packageVersion))
            .setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Model")
            .getter(getter(LoRaWANGatewayVersion::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<String> STATION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Station")
            .getter(getter(LoRaWANGatewayVersion::station)).setter(setter(Builder::station))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Station").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_FIELD,
            MODEL_FIELD, STATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String packageVersion;

    private final String model;

    private final String station;

    private LoRaWANGatewayVersion(BuilderImpl builder) {
        this.packageVersion = builder.packageVersion;
        this.model = builder.model;
        this.station = builder.station;
    }

    /**
     * <p>
     * The version of the wireless gateway firmware.
     * </p>
     * 
     * @return The version of the wireless gateway firmware.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * The model number of the wireless gateway.
     * </p>
     * 
     * @return The model number of the wireless gateway.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The basic station version of the wireless gateway.
     * </p>
     * 
     * @return The basic station version of the wireless gateway.
     */
    public final String station() {
        return station;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(station());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANGatewayVersion)) {
            return false;
        }
        LoRaWANGatewayVersion other = (LoRaWANGatewayVersion) obj;
        return Objects.equals(packageVersion(), other.packageVersion()) && Objects.equals(model(), other.model())
                && Objects.equals(station(), other.station());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANGatewayVersion").add("PackageVersion", packageVersion()).add("Model", model())
                .add("Station", station()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "Station":
            return Optional.ofNullable(clazz.cast(station()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PackageVersion", PACKAGE_VERSION_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("Station", STATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANGatewayVersion, T> g) {
        return obj -> g.apply((LoRaWANGatewayVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANGatewayVersion> {
        /**
         * <p>
         * The version of the wireless gateway firmware.
         * </p>
         * 
         * @param packageVersion
         *        The version of the wireless gateway firmware.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * The model number of the wireless gateway.
         * </p>
         * 
         * @param model
         *        The model number of the wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The basic station version of the wireless gateway.
         * </p>
         * 
         * @param station
         *        The basic station version of the wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder station(String station);
    }

    static final class BuilderImpl implements Builder {
        private String packageVersion;

        private String model;

        private String station;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANGatewayVersion model) {
            packageVersion(model.packageVersion);
            model(model.model);
            station(model.station);
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getStation() {
            return station;
        }

        public final void setStation(String station) {
            this.station = station;
        }

        @Override
        public final Builder station(String station) {
            this.station = station;
            return this;
        }

        @Override
        public LoRaWANGatewayVersion build() {
            return new LoRaWANGatewayVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
