/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The LoRaWAN information that is to be returned from getting multicast group information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANMulticastGet implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANMulticastGet.Builder, LoRaWANMulticastGet> {
    private static final SdkField<String> RF_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RfRegion").getter(getter(LoRaWANMulticastGet::rfRegionAsString)).setter(setter(Builder::rfRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RfRegion").build()).build();

    private static final SdkField<String> DL_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DlClass").getter(getter(LoRaWANMulticastGet::dlClassAsString)).setter(setter(Builder::dlClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlClass").build()).build();

    private static final SdkField<Integer> NUMBER_OF_DEVICES_REQUESTED_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("NumberOfDevicesRequested")
            .getter(getter(LoRaWANMulticastGet::numberOfDevicesRequested)).setter(setter(Builder::numberOfDevicesRequested))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDevicesRequested").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_DEVICES_IN_GROUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfDevicesInGroup").getter(getter(LoRaWANMulticastGet::numberOfDevicesInGroup))
            .setter(setter(Builder::numberOfDevicesInGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDevicesInGroup").build())
            .build();

    private static final SdkField<ParticipatingGatewaysMulticast> PARTICIPATING_GATEWAYS_FIELD = SdkField
            .<ParticipatingGatewaysMulticast> builder(MarshallingType.SDK_POJO).memberName("ParticipatingGateways")
            .getter(getter(LoRaWANMulticastGet::participatingGateways)).setter(setter(Builder::participatingGateways))
            .constructor(ParticipatingGatewaysMulticast::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipatingGateways").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RF_REGION_FIELD,
            DL_CLASS_FIELD, NUMBER_OF_DEVICES_REQUESTED_FIELD, NUMBER_OF_DEVICES_IN_GROUP_FIELD, PARTICIPATING_GATEWAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String rfRegion;

    private final String dlClass;

    private final Integer numberOfDevicesRequested;

    private final Integer numberOfDevicesInGroup;

    private final ParticipatingGatewaysMulticast participatingGateways;

    private LoRaWANMulticastGet(BuilderImpl builder) {
        this.rfRegion = builder.rfRegion;
        this.dlClass = builder.dlClass;
        this.numberOfDevicesRequested = builder.numberOfDevicesRequested;
        this.numberOfDevicesInGroup = builder.numberOfDevicesInGroup;
        this.participatingGateways = builder.participatingGateways;
    }

    /**
     * Returns the value of the RfRegion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rfRegion} will
     * return {@link SupportedRfRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rfRegionAsString}.
     * </p>
     * 
     * @return The value of the RfRegion property for this object.
     * @see SupportedRfRegion
     */
    public final SupportedRfRegion rfRegion() {
        return SupportedRfRegion.fromValue(rfRegion);
    }

    /**
     * Returns the value of the RfRegion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rfRegion} will
     * return {@link SupportedRfRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rfRegionAsString}.
     * </p>
     * 
     * @return The value of the RfRegion property for this object.
     * @see SupportedRfRegion
     */
    public final String rfRegionAsString() {
        return rfRegion;
    }

    /**
     * Returns the value of the DlClass property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dlClass} will
     * return {@link DlClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dlClassAsString}.
     * </p>
     * 
     * @return The value of the DlClass property for this object.
     * @see DlClass
     */
    public final DlClass dlClass() {
        return DlClass.fromValue(dlClass);
    }

    /**
     * Returns the value of the DlClass property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dlClass} will
     * return {@link DlClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dlClassAsString}.
     * </p>
     * 
     * @return The value of the DlClass property for this object.
     * @see DlClass
     */
    public final String dlClassAsString() {
        return dlClass;
    }

    /**
     * Returns the value of the NumberOfDevicesRequested property for this object.
     * 
     * @return The value of the NumberOfDevicesRequested property for this object.
     */
    public final Integer numberOfDevicesRequested() {
        return numberOfDevicesRequested;
    }

    /**
     * Returns the value of the NumberOfDevicesInGroup property for this object.
     * 
     * @return The value of the NumberOfDevicesInGroup property for this object.
     */
    public final Integer numberOfDevicesInGroup() {
        return numberOfDevicesInGroup;
    }

    /**
     * Returns the value of the ParticipatingGateways property for this object.
     * 
     * @return The value of the ParticipatingGateways property for this object.
     */
    public final ParticipatingGatewaysMulticast participatingGateways() {
        return participatingGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rfRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dlClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDevicesRequested());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDevicesInGroup());
        hashCode = 31 * hashCode + Objects.hashCode(participatingGateways());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANMulticastGet)) {
            return false;
        }
        LoRaWANMulticastGet other = (LoRaWANMulticastGet) obj;
        return Objects.equals(rfRegionAsString(), other.rfRegionAsString())
                && Objects.equals(dlClassAsString(), other.dlClassAsString())
                && Objects.equals(numberOfDevicesRequested(), other.numberOfDevicesRequested())
                && Objects.equals(numberOfDevicesInGroup(), other.numberOfDevicesInGroup())
                && Objects.equals(participatingGateways(), other.participatingGateways());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANMulticastGet").add("RfRegion", rfRegionAsString()).add("DlClass", dlClassAsString())
                .add("NumberOfDevicesRequested", numberOfDevicesRequested())
                .add("NumberOfDevicesInGroup", numberOfDevicesInGroup()).add("ParticipatingGateways", participatingGateways())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RfRegion":
            return Optional.ofNullable(clazz.cast(rfRegionAsString()));
        case "DlClass":
            return Optional.ofNullable(clazz.cast(dlClassAsString()));
        case "NumberOfDevicesRequested":
            return Optional.ofNullable(clazz.cast(numberOfDevicesRequested()));
        case "NumberOfDevicesInGroup":
            return Optional.ofNullable(clazz.cast(numberOfDevicesInGroup()));
        case "ParticipatingGateways":
            return Optional.ofNullable(clazz.cast(participatingGateways()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RfRegion", RF_REGION_FIELD);
        map.put("DlClass", DL_CLASS_FIELD);
        map.put("NumberOfDevicesRequested", NUMBER_OF_DEVICES_REQUESTED_FIELD);
        map.put("NumberOfDevicesInGroup", NUMBER_OF_DEVICES_IN_GROUP_FIELD);
        map.put("ParticipatingGateways", PARTICIPATING_GATEWAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANMulticastGet, T> g) {
        return obj -> g.apply((LoRaWANMulticastGet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANMulticastGet> {
        /**
         * Sets the value of the RfRegion property for this object.
         *
         * @param rfRegion
         *        The new value for the RfRegion property for this object.
         * @see SupportedRfRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedRfRegion
         */
        Builder rfRegion(String rfRegion);

        /**
         * Sets the value of the RfRegion property for this object.
         *
         * @param rfRegion
         *        The new value for the RfRegion property for this object.
         * @see SupportedRfRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedRfRegion
         */
        Builder rfRegion(SupportedRfRegion rfRegion);

        /**
         * Sets the value of the DlClass property for this object.
         *
         * @param dlClass
         *        The new value for the DlClass property for this object.
         * @see DlClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DlClass
         */
        Builder dlClass(String dlClass);

        /**
         * Sets the value of the DlClass property for this object.
         *
         * @param dlClass
         *        The new value for the DlClass property for this object.
         * @see DlClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DlClass
         */
        Builder dlClass(DlClass dlClass);

        /**
         * Sets the value of the NumberOfDevicesRequested property for this object.
         *
         * @param numberOfDevicesRequested
         *        The new value for the NumberOfDevicesRequested property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDevicesRequested(Integer numberOfDevicesRequested);

        /**
         * Sets the value of the NumberOfDevicesInGroup property for this object.
         *
         * @param numberOfDevicesInGroup
         *        The new value for the NumberOfDevicesInGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDevicesInGroup(Integer numberOfDevicesInGroup);

        /**
         * Sets the value of the ParticipatingGateways property for this object.
         *
         * @param participatingGateways
         *        The new value for the ParticipatingGateways property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participatingGateways(ParticipatingGatewaysMulticast participatingGateways);

        /**
         * Sets the value of the ParticipatingGateways property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ParticipatingGatewaysMulticast.Builder}
         * avoiding the need to create one manually via {@link ParticipatingGatewaysMulticast#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipatingGatewaysMulticast.Builder#build()} is called
         * immediately and its result is passed to {@link #participatingGateways(ParticipatingGatewaysMulticast)}.
         * 
         * @param participatingGateways
         *        a consumer that will call methods on {@link ParticipatingGatewaysMulticast.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participatingGateways(ParticipatingGatewaysMulticast)
         */
        default Builder participatingGateways(Consumer<ParticipatingGatewaysMulticast.Builder> participatingGateways) {
            return participatingGateways(ParticipatingGatewaysMulticast.builder().applyMutation(participatingGateways).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String rfRegion;

        private String dlClass;

        private Integer numberOfDevicesRequested;

        private Integer numberOfDevicesInGroup;

        private ParticipatingGatewaysMulticast participatingGateways;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANMulticastGet model) {
            rfRegion(model.rfRegion);
            dlClass(model.dlClass);
            numberOfDevicesRequested(model.numberOfDevicesRequested);
            numberOfDevicesInGroup(model.numberOfDevicesInGroup);
            participatingGateways(model.participatingGateways);
        }

        public final String getRfRegion() {
            return rfRegion;
        }

        public final void setRfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
        }

        @Override
        public final Builder rfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
            return this;
        }

        @Override
        public final Builder rfRegion(SupportedRfRegion rfRegion) {
            this.rfRegion(rfRegion == null ? null : rfRegion.toString());
            return this;
        }

        public final String getDlClass() {
            return dlClass;
        }

        public final void setDlClass(String dlClass) {
            this.dlClass = dlClass;
        }

        @Override
        public final Builder dlClass(String dlClass) {
            this.dlClass = dlClass;
            return this;
        }

        @Override
        public final Builder dlClass(DlClass dlClass) {
            this.dlClass(dlClass == null ? null : dlClass.toString());
            return this;
        }

        public final Integer getNumberOfDevicesRequested() {
            return numberOfDevicesRequested;
        }

        public final void setNumberOfDevicesRequested(Integer numberOfDevicesRequested) {
            this.numberOfDevicesRequested = numberOfDevicesRequested;
        }

        @Override
        public final Builder numberOfDevicesRequested(Integer numberOfDevicesRequested) {
            this.numberOfDevicesRequested = numberOfDevicesRequested;
            return this;
        }

        public final Integer getNumberOfDevicesInGroup() {
            return numberOfDevicesInGroup;
        }

        public final void setNumberOfDevicesInGroup(Integer numberOfDevicesInGroup) {
            this.numberOfDevicesInGroup = numberOfDevicesInGroup;
        }

        @Override
        public final Builder numberOfDevicesInGroup(Integer numberOfDevicesInGroup) {
            this.numberOfDevicesInGroup = numberOfDevicesInGroup;
            return this;
        }

        public final ParticipatingGatewaysMulticast.Builder getParticipatingGateways() {
            return participatingGateways != null ? participatingGateways.toBuilder() : null;
        }

        public final void setParticipatingGateways(ParticipatingGatewaysMulticast.BuilderImpl participatingGateways) {
            this.participatingGateways = participatingGateways != null ? participatingGateways.build() : null;
        }

        @Override
        public final Builder participatingGateways(ParticipatingGatewaysMulticast participatingGateways) {
            this.participatingGateways = participatingGateways;
            return this;
        }

        @Override
        public LoRaWANMulticastGet build() {
            return new LoRaWANMulticastGet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
