/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWAN public gateway metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANPublicGatewayMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANPublicGatewayMetadata.Builder, LoRaWANPublicGatewayMetadata> {
    private static final SdkField<String> PROVIDER_NET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderNetId").getter(getter(LoRaWANPublicGatewayMetadata::providerNetId))
            .setter(setter(Builder::providerNetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderNetId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(LoRaWANPublicGatewayMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Double> RSSI_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Rssi")
            .getter(getter(LoRaWANPublicGatewayMetadata::rssi)).setter(setter(Builder::rssi))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rssi").build()).build();

    private static final SdkField<Double> SNR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Snr")
            .getter(getter(LoRaWANPublicGatewayMetadata::snr)).setter(setter(Builder::snr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snr").build()).build();

    private static final SdkField<String> RF_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RfRegion").getter(getter(LoRaWANPublicGatewayMetadata::rfRegion)).setter(setter(Builder::rfRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RfRegion").build()).build();

    private static final SdkField<Boolean> DL_ALLOWED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DlAllowed").getter(getter(LoRaWANPublicGatewayMetadata::dlAllowed)).setter(setter(Builder::dlAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlAllowed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NET_ID_FIELD,
            ID_FIELD, RSSI_FIELD, SNR_FIELD, RF_REGION_FIELD, DL_ALLOWED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String providerNetId;

    private final String id;

    private final Double rssi;

    private final Double snr;

    private final String rfRegion;

    private final Boolean dlAllowed;

    private LoRaWANPublicGatewayMetadata(BuilderImpl builder) {
        this.providerNetId = builder.providerNetId;
        this.id = builder.id;
        this.rssi = builder.rssi;
        this.snr = builder.snr;
        this.rfRegion = builder.rfRegion;
        this.dlAllowed = builder.dlAllowed;
    }

    /**
     * <p>
     * The ID of the LoRaWAN public network provider.
     * </p>
     * 
     * @return The ID of the LoRaWAN public network provider.
     */
    public final String providerNetId() {
        return providerNetId;
    }

    /**
     * <p>
     * The ID of the gateways that are operated by the network provider.
     * </p>
     * 
     * @return The ID of the gateways that are operated by the network provider.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The RSSI (received signal strength indicator) value.
     * </p>
     * 
     * @return The RSSI (received signal strength indicator) value.
     */
    public final Double rssi() {
        return rssi;
    }

    /**
     * <p>
     * The SNR (signal to noise ratio) value.
     * </p>
     * 
     * @return The SNR (signal to noise ratio) value.
     */
    public final Double snr() {
        return snr;
    }

    /**
     * Returns the value of the RfRegion property for this object.
     * 
     * @return The value of the RfRegion property for this object.
     */
    public final String rfRegion() {
        return rfRegion;
    }

    /**
     * <p>
     * Boolean that indicates whether downlink is allowed using the network.
     * </p>
     * 
     * @return Boolean that indicates whether downlink is allowed using the network.
     */
    public final Boolean dlAllowed() {
        return dlAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerNetId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(rssi());
        hashCode = 31 * hashCode + Objects.hashCode(snr());
        hashCode = 31 * hashCode + Objects.hashCode(rfRegion());
        hashCode = 31 * hashCode + Objects.hashCode(dlAllowed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANPublicGatewayMetadata)) {
            return false;
        }
        LoRaWANPublicGatewayMetadata other = (LoRaWANPublicGatewayMetadata) obj;
        return Objects.equals(providerNetId(), other.providerNetId()) && Objects.equals(id(), other.id())
                && Objects.equals(rssi(), other.rssi()) && Objects.equals(snr(), other.snr())
                && Objects.equals(rfRegion(), other.rfRegion()) && Objects.equals(dlAllowed(), other.dlAllowed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANPublicGatewayMetadata").add("ProviderNetId", providerNetId()).add("Id", id())
                .add("Rssi", rssi()).add("Snr", snr()).add("RfRegion", rfRegion()).add("DlAllowed", dlAllowed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderNetId":
            return Optional.ofNullable(clazz.cast(providerNetId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Rssi":
            return Optional.ofNullable(clazz.cast(rssi()));
        case "Snr":
            return Optional.ofNullable(clazz.cast(snr()));
        case "RfRegion":
            return Optional.ofNullable(clazz.cast(rfRegion()));
        case "DlAllowed":
            return Optional.ofNullable(clazz.cast(dlAllowed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProviderNetId", PROVIDER_NET_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Rssi", RSSI_FIELD);
        map.put("Snr", SNR_FIELD);
        map.put("RfRegion", RF_REGION_FIELD);
        map.put("DlAllowed", DL_ALLOWED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANPublicGatewayMetadata, T> g) {
        return obj -> g.apply((LoRaWANPublicGatewayMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANPublicGatewayMetadata> {
        /**
         * <p>
         * The ID of the LoRaWAN public network provider.
         * </p>
         * 
         * @param providerNetId
         *        The ID of the LoRaWAN public network provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerNetId(String providerNetId);

        /**
         * <p>
         * The ID of the gateways that are operated by the network provider.
         * </p>
         * 
         * @param id
         *        The ID of the gateways that are operated by the network provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The RSSI (received signal strength indicator) value.
         * </p>
         * 
         * @param rssi
         *        The RSSI (received signal strength indicator) value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rssi(Double rssi);

        /**
         * <p>
         * The SNR (signal to noise ratio) value.
         * </p>
         * 
         * @param snr
         *        The SNR (signal to noise ratio) value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snr(Double snr);

        /**
         * Sets the value of the RfRegion property for this object.
         *
         * @param rfRegion
         *        The new value for the RfRegion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rfRegion(String rfRegion);

        /**
         * <p>
         * Boolean that indicates whether downlink is allowed using the network.
         * </p>
         * 
         * @param dlAllowed
         *        Boolean that indicates whether downlink is allowed using the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dlAllowed(Boolean dlAllowed);
    }

    static final class BuilderImpl implements Builder {
        private String providerNetId;

        private String id;

        private Double rssi;

        private Double snr;

        private String rfRegion;

        private Boolean dlAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANPublicGatewayMetadata model) {
            providerNetId(model.providerNetId);
            id(model.id);
            rssi(model.rssi);
            snr(model.snr);
            rfRegion(model.rfRegion);
            dlAllowed(model.dlAllowed);
        }

        public final String getProviderNetId() {
            return providerNetId;
        }

        public final void setProviderNetId(String providerNetId) {
            this.providerNetId = providerNetId;
        }

        @Override
        public final Builder providerNetId(String providerNetId) {
            this.providerNetId = providerNetId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Double getRssi() {
            return rssi;
        }

        public final void setRssi(Double rssi) {
            this.rssi = rssi;
        }

        @Override
        public final Builder rssi(Double rssi) {
            this.rssi = rssi;
            return this;
        }

        public final Double getSnr() {
            return snr;
        }

        public final void setSnr(Double snr) {
            this.snr = snr;
        }

        @Override
        public final Builder snr(Double snr) {
            this.snr = snr;
            return this;
        }

        public final String getRfRegion() {
            return rfRegion;
        }

        public final void setRfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
        }

        @Override
        public final Builder rfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
            return this;
        }

        public final Boolean getDlAllowed() {
            return dlAllowed;
        }

        public final void setDlAllowed(Boolean dlAllowed) {
            this.dlAllowed = dlAllowed;
        }

        @Override
        public final Builder dlAllowed(Boolean dlAllowed) {
            this.dlAllowed = dlAllowed;
            return this;
        }

        @Override
        public LoRaWANPublicGatewayMetadata build() {
            return new LoRaWANPublicGatewayMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
